/*************************************************
* Secure Memory Allocator Header File            *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_SECURE_ALLOCATOR_H__
#define BOTAN_SECURE_ALLOCATOR_H__

#include <botan/exceptn.h>

namespace Botan {

/*************************************************
* Secure Allocator Base Class                    *
*************************************************/
class SecureAllocator
   {
   public:
      struct Memory_Exhaustion : public Exception
         {
         Memory_Exhaustion() :
            Exception("SecureAllocator: Ran out of memory") {}
         };

      virtual void* allocate(u32bit) const;
      virtual void deallocate(void*, u32bit) const;
      virtual SecureAllocator* clone() = 0;
      bool single_copy() const { return single; }

      SecureAllocator(bool s) : single(s) {}
      virtual ~SecureAllocator() {}
   private:
      virtual void* alloc_block(u32bit) const = 0;
      virtual void dealloc_block(void*, u32bit) const = 0;
      const bool single;
   };

}

#endif
