/*************************************************
* SecureQueue Header File                        *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_SECURE_QUEUE_H__
#define BOTAN_SECURE_QUEUE_H__

#include <botan/filter.h>

namespace Botan {

/*************************************************
* SecureQueue                                    *
*************************************************/
class SecureQueue : public Filter
   {
   public:
      void write(const byte[], u32bit);

      u32bit read(byte[], u32bit);
      u32bit peek(byte[], u32bit) const;

      u32bit size() const;
      bool attachable() { return false; }

      SecureQueue& operator=(const SecureQueue&);
      SecureQueue();
      SecureQueue(const SecureQueue&);
      ~SecureQueue() { destroy(); }
   private:
      void destroy();
      class SecureQueueNode* head;
      class SecureQueueNode* tail;
   };

}

#endif
