/*************************************************
* SHA2-256 Header File                           *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_SHA2_256_H__
#define BOTAN_SHA2_256_H__

#include <botan/mdx_hash.h>

namespace Botan {

/*************************************************
* SHA2-256                                       *
*************************************************/
class SHA2_256 : public MDx_HashFunction
   {
   public:
      void clear() throw();
      std::string name() const { return "SHA2-256"; }
      HashFunction* clone() const { return new SHA2_256; }
      SHA2_256() : MDx_HashFunction(32, 64) { clear(); }
   private:
      void final_result(byte[]);
      void hash(const byte[]);
      static void F1(u32bit, u32bit, u32bit, u32bit&, u32bit,
                     u32bit, u32bit, u32bit&, u32bit, u32bit);
      static u32bit rho(u32bit, u32bit, u32bit, u32bit);
      static u32bit sigma(u32bit, u32bit, u32bit, u32bit);
      SecureBuffer<u32bit, 64> W;
      SecureBuffer<u32bit, 8> digest;
   };

}

#endif
