/*************************************************
* SHA2-512 Header File                           *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_SHA2_512_H__
#define BOTAN_SHA2_512_H__

#include <botan/mdx_hash.h>

namespace Botan {

/*************************************************
* SHA2-512                                       *
*************************************************/
class SHA2_512 : public MDx_HashFunction
   {
   public:
      void clear() throw();
      std::string name() const { return "SHA2-512"; }
      HashFunction* clone() const { return new SHA2_512; }
      SHA2_512() : MDx_HashFunction(64, 128) { clear(); }
   private:
      void final_result(byte[]);
      void hash(const byte[]);
      static void F1(u64bit, u64bit, u64bit, u64bit&, u64bit,
                     u64bit, u64bit, u64bit&, u64bit, u64bit);
      static u64bit rho(u64bit, u32bit, u32bit, u32bit);
      static u64bit sigma(u64bit, u32bit, u32bit, u32bit);
      SecureBuffer<u64bit, 80> W;
      SecureBuffer<u64bit, 8> digest;
   };

}

#endif
