/*************************************************
* ANSI X9.17 RNG Header File                     *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_ANSI_X917_RNG_H__
#define BOTAN_ANSI_X917_RNG_H__

#include <botan/base.h>

namespace Botan {

/*************************************************
* ANSI X9.17 RNG                                 *
*************************************************/
class ANSI_X917_RNG : public RandomNumberGenerator
   {
   public:
      byte random();
      void randomize(byte[], u32bit);
      void clear() throw();
      std::string name() const;
      ANSI_X917_RNG();
      ~ANSI_X917_RNG() { delete cipher; }
   private:
      void add_randomness(const byte[], u32bit) throw();
      void generate(u64bit);
      void reseed();
      const u32bit ITERATIONS_BEFORE_RESEED, MAX_OUT_PER_BUFFER;
      BlockCipher* cipher;
      SecureVector<byte> buffer, state, tstamp;
      u32bit position, iteration;
   };

}

#endif
