/*en    Laurent Constantin's network library (lcrzo)
                 lcrzo_global module

  Functions herein allow to specify global functionnalities.
*/
/*fr    Bibliotheque reseau de Laurent Constantin (lcrzo)
                 Module lcrzo_global

  Ce module permet de gerer la configuration de certaines fonctionnalites.
*/

/*-------------------------------------------------------------*/
/*EN************************************************************
 * Note about the following functions :                         *
 * The default values are correct for most applications.       *
 * You should modify their parameters only if you know         *
 * what you are doing.                                         *
 ***************************************************************/
/*FR************************************************************
 * Note sur les fonctions suivantes :                          *
 * Les valeurs par defaut sont correctes pour la majorite des  *
 * applications.                                               *
 * Vous ne devriez modifier les parametres que si vous savez   *
 * ce que vous faites.                                         *
 ***************************************************************/

/*-------------------------------------------------------------*/
/*en select the language */
/*fr selectionne la langue */
#define LCRZO_GLOBAL_LANG_EN 1
#define LCRZO_GLOBAL_LANG_FR 2
int lcrzo_global_set_language(lcrzo_int16 language);
int lcrzo_global_get_language(lcrzo_int16 *planguage);

/*-------------------------------------------------------------*/
/*en change the backlog for tcp servers */
/*fr change le backlog des serveurs tcp */
int lcrzo_global_set_sock_tcpser_backlog(lcrzo_uint8 backlog);
int lcrzo_global_get_sock_tcpser_backlog(lcrzo_uint8 *pbacklog);

/*-------------------------------------------------------------*/
/*en change thresholds for lcrzo_time_sleep */
/*fr change les seuils pour lcrzo_time_sleep */
int lcrzo_global_set_time_sleep_1threshold(lcrzo_uint32 threshold);
int lcrzo_global_set_time_sleep_2threshold(lcrzo_uint32 threshold);
int lcrzo_global_set_time_sleep_3threshold(lcrzo_uint32 threshold);
int lcrzo_global_get_time_sleep_1threshold(lcrzo_uint32 *pthreshold);
int lcrzo_global_get_time_sleep_2threshold(lcrzo_uint32 *pthreshold);
int lcrzo_global_get_time_sleep_3threshold(lcrzo_uint32 *pthreshold);

/*-------------------------------------------------------------*/
/*en when open a record, decide if the file must exist or not */
/*fr lors de l'ouverture d'un record, decide si le fichier
   doit prealablement exister, ou non */
int lcrzo_global_set_record_open_existentfile(lcrzo_bool yesitmustbe);
int lcrzo_global_set_record_open_newfile(lcrzo_bool yesitmustbe);
int lcrzo_global_get_record_open_existentfile(lcrzo_bool *pyesitmustbe);
int lcrzo_global_get_record_open_newfile(lcrzo_bool *pyesitmustbe);

/*-------------------------------------------------------------*/
/*en decide if the library has to recompute header fields */
/*fr decide si la bibliotheque dot recalculer les champs d'entetes */
int lcrzo_global_set_hdr_compfields(lcrzo_bool yes);
int lcrzo_global_get_hdr_compfields(lcrzo_bool *pyes);
int lcrzo_global_set_hdr_cf_ethtype(lcrzo_bool yes);
int lcrzo_global_get_hdr_cf_ethtype(lcrzo_bool *pyes);
int lcrzo_global_set_hdr_cf_iptotlen(lcrzo_bool yes);
int lcrzo_global_get_hdr_cf_iptotlen(lcrzo_bool *pyes);
int lcrzo_global_set_hdr_cf_ipihl(lcrzo_bool yes);
int lcrzo_global_get_hdr_cf_ipihl(lcrzo_bool *pyes);
int lcrzo_global_set_hdr_cf_ipcheck(lcrzo_bool yes);
int lcrzo_global_get_hdr_cf_ipcheck(lcrzo_bool *pyes);
int lcrzo_global_set_hdr_cf_ipprotocol(lcrzo_bool yes);
int lcrzo_global_get_hdr_cf_ipprotocol(lcrzo_bool *pyes);
int lcrzo_global_set_hdr_cf_udplen(lcrzo_bool yes);
int lcrzo_global_get_hdr_cf_udplen(lcrzo_bool *pyes);
int lcrzo_global_set_hdr_cf_udpcheck(lcrzo_bool yes);
int lcrzo_global_get_hdr_cf_udpcheck(lcrzo_bool *pyes);
int lcrzo_global_set_hdr_cf_tcpdoff(lcrzo_bool yes);
int lcrzo_global_get_hdr_cf_tcpdoff(lcrzo_bool *pyes);
int lcrzo_global_set_hdr_cf_tcpcheck(lcrzo_bool yes);
int lcrzo_global_get_hdr_cf_tcpcheck(lcrzo_bool *pyes);
int lcrzo_global_set_hdr_cf_icmpcheck(lcrzo_bool yes);
int lcrzo_global_get_hdr_cf_icmpcheck(lcrzo_bool *pyes);

/*-------------------------------------------------------------*/
/*en decide what addresses to use for internal spoofing */
/*fr decide les adresses a utiliser pour les spoof internes */
/*en random *//*fr aleatoire*/
#define LCRZO_INTSPOOF_TYPE_RAND 0
/*en random, but constant over the various calls */
/*fr aleatoire, mais constant d'un appel a l'autre */
#define LCRZO_INTSPOOF_TYPE_RANDCONST 1
/*en user specified *//*fr specifie par l'utilisateur */
#define LCRZO_INTSPOOF_TYPE_USER 2
/*en computed for the best value */
/*fr calcule a la meilleure valeur */
#define LCRZO_INTSPOOF_TYPE_COMP 3
/*en computed for the best value, and keep this value */
/*fr calcule a la meilleure valeur, et utilise toujours cette valeur */
#define LCRZO_INTSPOOF_TYPE_COMPCONST 4
/*en use the Ethernet and IP address of the device */
/*fr utilise les adresses Ethernet et IP du device */
#define LCRZO_INTSPOOF_TYPE_CONF 5
int lcrzo_global_set_intspoof_eth_type(lcrzo_uint8 intspoof_eth_type);
int lcrzo_global_get_intspoof_eth_type(lcrzo_uint8 *pintspoof_eth_type);
int lcrzo_global_set_intspoof_eth_address(lcrzo_constetha eth_address);
int lcrzo_global_get_intspoof_eth_address(lcrzo_etha intspoof_eth_address);
int lcrzo_global_set_intspoof_ip_type(lcrzo_uint8 intspoof_ip_type);
int lcrzo_global_get_intspoof_ip_type(lcrzo_uint8 *pintspoof_ip_type);
int lcrzo_global_set_intspoof_ip_address(lcrzo_constetha intspoof_ip_address);
int lcrzo_global_get_intspoof_ip_address(lcrzo_etha intspoof_ip_address);

/*-------------------------------------------------------------*/
/*en timeout for hs<-->ipa resolution */
/*fr timeout pour les resolutions hs<-->ipa */
int lcrzo_global_set_resolver_timeout(lcrzo_uint8 timeout);
int lcrzo_global_get_resolver_timeout(lcrzo_uint8 *ptimeout);

/*-------------------------------------------------------------*/
/*en if we want virtual clients/servers to answer to arp/rarp/ping */
/*fr si on veut que les clients/serveurs virtuels repondent
     aux requetes arp/rarp/ping */
int lcrzo_global_set_sock_virt_answeralive(lcrzo_bool answeralive);
int lcrzo_global_get_sock_virt_answeralive(lcrzo_bool *pansweralive);

/*-------------------------------------------------------------*/
/*en if we are sensitive to case in regular expressions of
    lcrzo_data and lcrzo_string functions */
/*fr si on est sensible a la casse dans les expressions regulieres
    de lcrzo_data et lcrzo_string */
int lcrzo_global_set_data_regexp_casesensitive(lcrzo_bool casesensitive);
int lcrzo_global_get_data_regexp_casesensitive(lcrzo_bool *pcasesensitive);

/*-------------------------------------------------------------*/
/*EN************************************************************
 * Note about the following functions :                         *
 * They values can be overwritten by local functions.          *
 ***************************************************************/
/*FR************************************************************
 * Note sur les fonctions suivantes :                          *
 * Leurs valeurs peuvent etre remodifiees par les fonctions    *
 * locales.                                                    *
 ***************************************************************/

/*-------------------------------------------------------------*/
/*en change timeouts for sniff */
/*fr modifie les timeout des sniffs */
int lcrzo_global_set_sniff_ipreas1timeout(lcrzo_uint16 timeout);
int lcrzo_global_set_sniff_ipreas2timeout(lcrzo_uint16 timeout);
int lcrzo_global_set_sniff_tcpreor1timeout(lcrzo_uint16 timeout);
int lcrzo_global_set_sniff_tcpreor2timeout(lcrzo_uint16 timeout);
int lcrzo_global_get_sniff_ipreas1timeout(lcrzo_uint16 *ptimeout);
int lcrzo_global_get_sniff_ipreas2timeout(lcrzo_uint16 *ptimeout);
int lcrzo_global_get_sniff_tcpreor1timeout(lcrzo_uint16 *ptimeout);
int lcrzo_global_get_sniff_tcpreor2timeout(lcrzo_uint16 *ptimeout);

/*-------------------------------------------------------------*/
/*en change the IP fragmentation size */
/*fr change la taille des fragments IP */ 
int lcrzo_global_set_spoof_fragoctosize(lcrzo_uint16 fragoctosize);
int lcrzo_global_get_spoof_fragoctosize(lcrzo_uint16 *pfragoctosize);

/*-------------------------------------------------------------*/
/*en decide if packets are to be printed before spoofing */
/*fr decide si les paquets spoofes doivent etre affiches avant
   d'etre envoyes*/
int lcrzo_global_set_spoof_printbeforesending(lcrzo_bool printbeforesending);
int lcrzo_global_get_spoof_printbeforesending(lcrzo_bool *pprintbeforesending);

/*-------------------------------------------------------------*/
/*en define the printprofile to use when printing spoofed packets */
/*fr definit le printprofile a utiliser lors de l'affichage des 
   paquets spoofes. */
int lcrzo_global_set_spoof_printprofile(lcrzo_printprofile printprofile);
int lcrzo_global_get_spoof_printprofile(lcrzo_printprofile *pprintprofile);

/*-------------------------------------------------------------*/
/*en if we spoof ethernet packet when the user wants to only 
     spoof IP. This is very useful on systems like Solaris
     which modify IP header values. */
/*fr definit si l'on spoofe des paquets Ethernet lorsque l'utilisateur
     veut spoofer des paquets IP. C'est tres utile sur des 
     systemes comme Solaris qui modifient les valeurs des entetes
     IP. */
int lcrzo_global_set_spoof_useethforip(lcrzo_bool useethforip);
int lcrzo_global_get_spoof_useethforip(lcrzo_bool *puseethforip);

/*-------------------------------------------------------------*/
/*en function to display user specific error */
/*fr fonction a employer pour afficher les erreurs de l'utilisateur */
int lcrzo_global_set_err_displayfunction(int (*pfunc)(int ret));
int lcrzo_global_get_err_displayfunction(int (**ppfunc)(int ret));

