// include/libecc/config.ho.  Generated from config.ho.in by configure.
//!
//! \file  libecc/config.h
//! \brief Configuration defines.
//!
//! This header file defines macros that reflect the options that libecc was compiled with.
//!
//! \sa \link group_configuration Configuration Options And Macros \endlink
//
// This file is part of the libecc package.
// Copyright (C) 2002, by
// 
// Carlo Wood, Run on IRC <carlo@alinoe.com>
// RSA-1024 0x624ACAD5 1997-01-26                    Sign & Encrypt
// Fingerprint16 = 32 EC A7 B6 AC DB 65 A6  F6 F6 55 DD 1C DC FF 61
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#ifndef LIBECC_CONFIG_H
#define LIBECC_CONFIG_H

//
// DO NOT CHANGE THIS FILE
//
// The defines in this file are configuration options chosen during
// compilation of libecc.  To change these options, run `configure'
// with the appropriate commandline options (Use `configure --help'
// for more details).
//

/**
 * \addtogroup group_configuration Configuration Options And Macros
 * \ingroup book_start
 *
 * Libecc uses autoconf; configuration is done with the usual \shellcommand configure \endshellcommand script.&nbsp;
 * You can list all options of configure by issuing \shellcommand configure --help \endshellcommand.
 *
 * This section describes the configure options specific to libecc.&nbsp;
 * The name of the macros that are related to the respective features are given between parenthesis after the option.&nbsp;
 * You can not define these macros yourself, you may only use them in an <CODE>##if ... ##endif</CODE> test.&nbsp;
 * The macros are always defined; when a configure option was used then the macro is defined to <code>1</code>,
 * otherwise it is defined to 0.&nbsp;
 * This makes it possible for the compiler to warn you when you made a typo in the name of a macro.
 *
 * <b>Example:</b>
 *
 * \code
 * #include <libecc/config.h>
 *
 * // Use '#if' not '#ifdef'.
 * #if ECC_DEBUG
 *   assert( i == 1 ); 
 * #endif
 * \endcode
 */

/** \defgroup enable_debug --enable-debug (ECC_DEBUG)
 * \ingroup group_configuration
 *
 * \par Description
 *
 * Turns on internal consistency checks of libecc.&nbsp;
 * The use of these checks can slow down libecc and are mainly intended for the maintainer of libecc.
 *
 * \par When to use it
 *
 * When you think you found a bug in libecc.
 *
 * \par Configure option
 *
 * This is disabled by default.&nbsp;
 * Use \shellcommand configure --enable-debug \endshellcommand to enable it.
 */

#define ECC_DEBUG 0

/** \defgroup enable_debug_output --enable-debug-output (ECC_DEBUGOUTPUT)
 * \ingroup group_configuration
 *
 * \par Description
 *
 * When \ref enable_debug is enabled, this turns on a lot of extra debugging
 * output concerning the internal state of libecc.&nbsp;
 *
 * \par When to use it
 *
 * Never, unless you are a developer of libecc.
 *
 * \par Configure option
 *
 * This is disabled by default.&nbsp;
 * Use \shellcommand configure --enable-debug-output \endshellcommand to enable it.
 */

#define ECC_DEBUGOUTPUT (ECC_DEBUG && 1)

//
// autoconf defines that are needed.
//

#endif // LIBECC_CONFIG_H
