/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import org.xml.sax.SAXException;

public class FOPException
extends Exception {
    private static final String EXCEPTION_SEPARATOR = "\n---------\n";
    private Throwable _exception;

    public FOPException(String string) {
        super(string);
    }

    public FOPException(String string, Throwable throwable) {
        super(string);
        this.setException(throwable);
    }

    public FOPException(Throwable throwable) {
        super(throwable.getMessage());
        this.setException(throwable);
    }

    public Throwable getException() {
        return this._exception;
    }

    protected Throwable getRootException() {
        Throwable throwable = this._exception;
        if (throwable instanceof SAXException) {
            throwable = ((SAXException)throwable).getException();
        }
        if (throwable instanceof InvocationTargetException) {
            throwable = ((InvocationTargetException)throwable).getTargetException();
        }
        if (throwable != this._exception) {
            return throwable;
        }
        return null;
    }

    public void printStackTrace() {
        PrintStream printStream = System.err;
        synchronized (printStream) {
            super.printStackTrace();
            if (this._exception != null) {
                System.err.println(EXCEPTION_SEPARATOR);
                this._exception.printStackTrace();
            }
            if (this.getRootException() != null) {
                System.err.println(EXCEPTION_SEPARATOR);
                this.getRootException().printStackTrace();
            }
        }
    }

    public void printStackTrace(PrintStream printStream) {
        PrintStream printStream2 = printStream;
        synchronized (printStream2) {
            super.printStackTrace(printStream);
            if (this._exception != null) {
                printStream.println(EXCEPTION_SEPARATOR);
                this._exception.printStackTrace(printStream);
            }
            if (this.getRootException() != null) {
                System.err.println(EXCEPTION_SEPARATOR);
                this.getRootException().printStackTrace(printStream);
            }
        }
    }

    public void printStackTrace(PrintWriter printWriter) {
        PrintWriter printWriter2 = printWriter;
        synchronized (printWriter2) {
            super.printStackTrace(printWriter);
            if (this._exception != null) {
                printWriter.println(EXCEPTION_SEPARATOR);
                this._exception.printStackTrace(printWriter);
            }
            if (this.getRootException() != null) {
                System.err.println(EXCEPTION_SEPARATOR);
                this.getRootException().printStackTrace(printWriter);
            }
        }
    }

    protected void setException(Throwable throwable) {
        this._exception = throwable;
    }
}

