/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.File;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.InputHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;

public class TraxInputHandler
extends InputHandler {
    File xmlfile;
    File xsltfile;

    public TraxInputHandler(File file, File file2) {
        this.xmlfile = file;
        this.xsltfile = file2;
    }

    public InputSource getInputSource() {
        return InputHandler.fileInputSource(this.xmlfile);
    }

    public XMLReader getParser() throws FOPException {
        return TraxInputHandler.getXMLFilter(this.xmlfile, this.xsltfile);
    }

    public static XMLFilter getXMLFilter(File file, File file2) throws FOPException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            if (transformerFactory.getFeature("http://javax.xml.transform.sax.SAXSource/feature") && transformerFactory.getFeature("http://javax.xml.transform.sax.SAXResult/feature")) {
                SAXTransformerFactory sAXTransformerFactory = (SAXTransformerFactory)transformerFactory;
                XMLFilter xMLFilter = sAXTransformerFactory.newXMLFilter(new StreamSource(file2));
                XMLReader xMLReader = InputHandler.createParser();
                if (xMLReader == null) {
                    throw new FOPException("Unable to create SAX parser");
                }
                xMLFilter.setParent(xMLReader);
                return xMLFilter;
            }
            throw new FOPException("Your parser doesn't support the features SAXSource and SAXResult.\nMake sure you are using a xsl parser which supports TrAX");
        }
        catch (Exception exception) {
            if (exception instanceof FOPException) {
                throw (FOPException)exception;
            }
            throw new FOPException(exception);
        }
    }
}

