/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.viewer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.apache.fop.apps.AWTStarter;
import org.apache.fop.apps.FOPException;
import org.apache.fop.messaging.MessageEvent;
import org.apache.fop.messaging.MessageListener;
import org.apache.fop.render.awt.AWTRenderer;
import org.apache.fop.viewer.Command;
import org.apache.fop.viewer.GoToPageDialog;
import org.apache.fop.viewer.IconToolBar;
import org.apache.fop.viewer.PreviewDialogAboutBox;
import org.apache.fop.viewer.ProgressListener;
import org.apache.fop.viewer.Translator;

public class PreviewDialog
extends JFrame
implements ProgressListener,
MessageListener {
    protected Translator res;
    protected int currentPage = 0;
    protected int pageCount = 0;
    protected AWTRenderer renderer;
    protected AWTStarter starter;
    protected IconToolBar toolBar = new IconToolBar();
    protected Command printAction;
    protected Command firstPageAction;
    protected Command previousPageAction;
    protected Command nextPageAction;
    protected Command lastPageAction;
    protected Command reloadAction;
    protected Reloader reloader;
    protected JLabel zoomLabel = new JLabel();
    protected JComboBox scale = new JComboBox(){

        public float getAlignmentY() {
            return 0.5f;
        }
    };
    protected JScrollPane previewArea = new JScrollPane();
    protected JPanel statusBar = new JPanel();
    protected GridBagLayout statusBarLayout = new GridBagLayout();
    protected JLabel statisticsStatus = new JLabel();
    protected JLabel processStatus = new JLabel();
    protected JLabel infoStatus = new JLabel();
    protected JLabel previewImageLabel = new JLabel();

    public PreviewDialog(AWTStarter aWTStarter, AWTRenderer aWTRenderer, Translator translator) {
        this(aWTRenderer, translator);
        this.starter = aWTStarter;
    }

    public PreviewDialog(AWTRenderer aWTRenderer, Translator translator) {
        this.res = translator;
        this.renderer = aWTRenderer;
        this.printAction = new Command(this.res.getString("Print"), "Print"){

            public void doit() {
                PreviewDialog.this.print();
            }
        };
        this.firstPageAction = new Command(this.res.getString("First page"), "firstpg"){

            public void doit() {
                PreviewDialog.this.goToFirstPage(null);
            }
        };
        this.previousPageAction = new Command(this.res.getString("Previous page"), "prevpg"){

            public void doit() {
                PreviewDialog.this.goToPreviousPage(null);
            }
        };
        this.nextPageAction = new Command(this.res.getString("Next page"), "nextpg"){

            public void doit() {
                PreviewDialog.this.goToNextPage(null);
            }
        };
        this.lastPageAction = new Command(this.res.getString("Last page"), "lastpg"){

            public void doit() {
                PreviewDialog.this.goToLastPage(null);
            }
        };
        this.reloadAction = new Command(this.res.getString("Reload"), "reload"){

            public void doit() {
                PreviewDialog.this.reload(null);
            }
        };
        this.setDefaultCloseOperation(2);
        ((Component)this).setSize(new Dimension(379, 476));
        this.previewArea.setMinimumSize(new Dimension(50, 50));
        this.setTitle("FOP: AWT-" + this.res.getString("Preview"));
        this.scale.addItem("25");
        this.scale.addItem("50");
        this.scale.addItem("75");
        this.scale.addItem("100");
        this.scale.addItem("150");
        this.scale.addItem("200");
        this.scale.setMaximumSize(new Dimension(80, 24));
        this.scale.setPreferredSize(new Dimension(80, 24));
        this.scale.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreviewDialog.this.scale_actionPerformed(actionEvent);
            }
        });
        this.scale.setSelectedItem("100");
        this.renderer.setScaleFactor(100.0);
        this.zoomLabel.setText(this.res.getString("Zoom"));
        this.setJMenuBar(this.setupMenue());
        this.getContentPane().add((Component)this.toolBar, "North");
        this.toolBar.add(this.printAction);
        this.toolBar.add(this.reloadAction);
        this.toolBar.addSeparator();
        this.toolBar.add(this.firstPageAction);
        this.toolBar.add(this.previousPageAction);
        this.toolBar.add(this.nextPageAction);
        this.toolBar.add(this.lastPageAction);
        this.toolBar.addSeparator();
        this.toolBar.add((Component)this.zoomLabel, null);
        this.toolBar.addSeparator();
        this.toolBar.add((Component)this.scale, null);
        this.getContentPane().add((Component)this.previewArea, "Center");
        this.getContentPane().add((Component)this.statusBar, "South");
        this.statisticsStatus.setBorder(BorderFactory.createEtchedBorder());
        this.processStatus.setBorder(BorderFactory.createEtchedBorder());
        this.infoStatus.setBorder(BorderFactory.createEtchedBorder());
        this.statusBar.setLayout(this.statusBarLayout);
        this.processStatus.setPreferredSize(new Dimension(200, 21));
        this.statisticsStatus.setPreferredSize(new Dimension(100, 21));
        this.infoStatus.setPreferredSize(new Dimension(100, 21));
        this.processStatus.setMinimumSize(new Dimension(200, 21));
        this.statisticsStatus.setMinimumSize(new Dimension(100, 21));
        this.infoStatus.setMinimumSize(new Dimension(100, 21));
        this.statusBar.add((Component)this.processStatus, new GridBagConstraints(0, 0, 2, 1, 2.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.statusBar.add((Component)this.statisticsStatus, new GridBagConstraints(2, 0, 1, 2, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.statusBar.add((Component)this.infoStatus, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.previewArea.getViewport().add(this.previewImageLabel);
        this.showPage();
    }

    private void goToFirstPage(ActionEvent actionEvent) {
        if (this.currentPage == 0) {
            return;
        }
        this.currentPage = 0;
        this.goToPage(this.currentPage);
    }

    private void goToLastPage(ActionEvent actionEvent) {
        if (this.currentPage == this.pageCount - 1) {
            return;
        }
        this.currentPage = this.pageCount - 1;
        this.goToPage(this.currentPage);
    }

    private void goToNextPage(ActionEvent actionEvent) {
        if (this.currentPage >= this.pageCount - 1) {
            return;
        }
        ++this.currentPage;
        this.goToPage(this.currentPage);
    }

    private void goToPage(int n) {
        this.currentPage = n;
        this.renderer.setPageNumber(n);
        this.showPage();
    }

    private void goToPage(ActionEvent actionEvent) {
        GoToPageDialog goToPageDialog = new GoToPageDialog(this, this.res.getString("Go to Page"), true);
        ((Component)goToPageDialog).setLocation((int)this.getLocation().getX() + 50, (int)this.getLocation().getY() + 50);
        goToPageDialog.show();
        this.currentPage = goToPageDialog.getPageNumber();
        if (this.currentPage < 1 || this.currentPage > this.pageCount) {
            return;
        }
        --this.currentPage;
        this.goToPage(this.currentPage);
    }

    private void goToPreviousPage(ActionEvent actionEvent) {
        if (this.currentPage <= 0) {
            return;
        }
        --this.currentPage;
        this.goToPage(this.currentPage);
    }

    private void print() {
        block2: {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            printerJob.setPageable(this.renderer);
            if (!printerJob.printDialog()) break block2;
            try {
                printerJob.print();
            }
            catch (PrinterException printerException) {
                printerException.printStackTrace();
            }
        }
    }

    public void processMessage(MessageEvent messageEvent) {
        String string = messageEvent.getMessage();
        String string2 = this.processStatus.getText();
        FontMetrics fontMetrics = ((Component)this.processStatus).getFontMetrics(this.processStatus.getFont());
        int n = this.processStatus.getWidth() - fontMetrics.stringWidth("...");
        if (messageEvent.getMessageType() == 0) {
            if (!string2.endsWith("\n")) {
                string2 = String.valueOf(string2) + string;
                while (fontMetrics.stringWidth(string2) > n) {
                    string2 = string2.substring(1);
                    n = this.processStatus.getWidth() - fontMetrics.stringWidth("...");
                }
            } else {
                string2 = string;
            }
            this.progress(string2);
        } else {
            showProgress showProgress2;
            if ((string = string.trim()).equals(">")) {
                string2 = String.valueOf(string2) + string;
                while (fontMetrics.stringWidth(string2) > n) {
                    string2 = string2.substring(1);
                    n = this.processStatus.getWidth() - fontMetrics.stringWidth("...");
                }
                this.progress(String.valueOf(this.processStatus.getText()) + string);
                return;
            }
            if (string.equals("")) {
                return;
            }
            if (string.length() < 60) {
                showProgress2 = new showProgress(string, true);
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                Vector<String> vector = new Vector<String>();
                StringBuffer stringBuffer = new StringBuffer();
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    if (stringBuffer.length() + string3.length() + 1 < 60) {
                        stringBuffer.append(" ").append(string3);
                        continue;
                    }
                    vector.add(stringBuffer.toString());
                    stringBuffer = new StringBuffer();
                    stringBuffer.append(string3);
                }
                vector.add(stringBuffer.toString());
                String[] stringArray = new String[vector.size()];
                int n2 = 0;
                while (n2 < vector.size()) {
                    stringArray[n2] = vector.elementAt(n2).toString();
                    ++n2;
                }
                showProgress2 = new showProgress(stringArray, true);
            }
            if (SwingUtilities.isEventDispatchThread()) {
                showProgress2.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(showProgress2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.progress(messageEvent.getMessage());
                }
            }
        }
    }

    public void progress(int n) {
        this.progress(new String(String.valueOf(n) + "%"));
    }

    public void progress(int n, String string) {
        this.progress(new String(String.valueOf(string) + " " + n + "%"));
    }

    public void progress(String string) {
        SwingUtilities.invokeLater(new showProgress(string, false));
    }

    private synchronized void reload(ActionEvent actionEvent) {
        if (this.reloader == null || !this.reloader.isAlive()) {
            this.reloader = new Reloader();
            this.reloader.start();
        }
    }

    public void reportException(Exception exception) {
        String string = this.res.getString("An exception has occured");
        this.progress(string);
        JOptionPane.showMessageDialog(this.getContentPane(), "<html><b>" + string + ":</b><br>" + exception.getClass().getName() + "<br>" + exception.getMessage() + "</html>", this.res.getString("Fatal error"), 0);
    }

    void scale_actionPerformed(ActionEvent actionEvent) {
        this.setScale(new Double((String)this.scale.getSelectedItem()));
    }

    public void setScale(double d) {
        if (d == 25.0) {
            this.scale.setSelectedIndex(0);
        } else if (d == 50.0) {
            this.scale.setSelectedIndex(1);
        } else if (d == 75.0) {
            this.scale.setSelectedIndex(2);
        } else if (d == 100.0) {
            this.scale.setSelectedIndex(3);
        } else if (d == 150.0) {
            this.scale.setSelectedIndex(4);
        } else if (d == 200.0) {
            this.scale.setSelectedIndex(5);
        }
        this.renderer.setScaleFactor(d);
        this.showPage();
    }

    private JMenuBar setupMenue() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu(this.res.getString("File"));
        JMenu jMenu2 = new JMenu("OutputFormat");
        jMenu2.add(new Command("mHTML"));
        jMenu2.add(new Command("mPDF"));
        jMenu2.add(new Command("mRTF"));
        jMenu2.add(new Command("mTEXT"));
        jMenu.add(new Command(this.res.getString("Print")){

            public void doit() {
                PreviewDialog.this.print();
            }
        });
        jMenu.add(new Command(this.res.getString("Reload")){

            public void doit() {
                PreviewDialog.this.reload(null);
            }
        });
        jMenu.addSeparator();
        jMenu.add(new Command(this.res.getString("Exit")){

            public void doit() {
                PreviewDialog.this.dispose();
            }
        });
        jMenuBar.add(jMenu);
        jMenu = new JMenu(this.res.getString("View"));
        jMenu.add(new Command(this.res.getString("First page")){

            public void doit() {
                PreviewDialog.this.goToFirstPage(null);
            }
        });
        jMenu.add(new Command(this.res.getString("Previous page")){

            public void doit() {
                PreviewDialog.this.goToPreviousPage(null);
            }
        });
        jMenu.add(new Command(this.res.getString("Next page")){

            public void doit() {
                PreviewDialog.this.goToNextPage(null);
            }
        });
        jMenu.add(new Command(this.res.getString("Last page")){

            public void doit() {
                PreviewDialog.this.goToLastPage(null);
            }
        });
        jMenu.add(new Command(String.valueOf(this.res.getString("Go to Page")) + " ..."){

            public void doit() {
                PreviewDialog.this.goToPage(null);
            }
        });
        jMenu.addSeparator();
        jMenu2 = new JMenu(this.res.getString("Zoom"));
        jMenu2.add(new Command("25%"){

            public void doit() {
                PreviewDialog.this.setScale(25.0);
            }
        });
        jMenu2.add(new Command("50%"){

            public void doit() {
                PreviewDialog.this.setScale(50.0);
            }
        });
        jMenu2.add(new Command("75%"){

            public void doit() {
                PreviewDialog.this.setScale(75.0);
            }
        });
        jMenu2.add(new Command("100%"){

            public void doit() {
                PreviewDialog.this.setScale(100.0);
            }
        });
        jMenu2.add(new Command("150%"){

            public void doit() {
                PreviewDialog.this.setScale(150.0);
            }
        });
        jMenu2.add(new Command("200%"){

            public void doit() {
                PreviewDialog.this.setScale(200.0);
            }
        });
        jMenu.add(jMenu2);
        jMenu.addSeparator();
        jMenu.add(new Command(this.res.getString("Default zoom")){

            public void doit() {
                PreviewDialog.this.setScale(100.0);
            }
        });
        jMenuBar.add(jMenu);
        jMenu = new JMenu(this.res.getString("Help"));
        jMenu.add(new Command(this.res.getString("Index")));
        jMenu.addSeparator();
        jMenu.add(new Command(this.res.getString("Introduction")));
        jMenu.addSeparator();
        jMenu.add(new Command(this.res.getString("About")){

            public void doit() {
                PreviewDialog.this.startHelpAbout(null);
            }
        });
        jMenuBar.add(jMenu);
        return jMenuBar;
    }

    public void showPage() {
        showPageImage showPageImage2 = new showPageImage();
        if (SwingUtilities.isEventDispatchThread()) {
            showPageImage2.run();
        } else {
            SwingUtilities.invokeLater(showPageImage2);
        }
    }

    public void startHelpAbout(ActionEvent actionEvent) {
        PreviewDialogAboutBox previewDialogAboutBox = new PreviewDialogAboutBox(this);
        Dimension dimension = previewDialogAboutBox.getPreferredSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocation();
        ((Component)previewDialogAboutBox).setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
        previewDialogAboutBox.setModal(true);
        previewDialogAboutBox.show();
    }

    private class Reloader
    extends Thread {
        Reloader() {
        }

        public void run() {
            PreviewDialog.this.previewImageLabel.setIcon(null);
            PreviewDialog.this.statisticsStatus.setText("");
            while (PreviewDialog.this.renderer.getPageCount() != 0) {
                PreviewDialog.this.renderer.removePage(0);
            }
            try {
                PreviewDialog.this.starter.run();
            }
            catch (FOPException fOPException) {
                fOPException.printStackTrace();
            }
        }
    }

    class showProgress
    implements Runnable {
        Object message;
        boolean isErrorMessage = false;

        public showProgress(Object object, boolean bl) {
            this.message = object;
            this.isErrorMessage = bl;
        }

        public void run() {
            if (this.isErrorMessage) {
                JOptionPane.showMessageDialog(null, this.message, "Error", 0);
            } else {
                PreviewDialog.this.processStatus.setText(this.message.toString());
            }
        }
    }

    class showPageImage
    implements Runnable {
        showPageImage() {
        }

        public void run() {
            BufferedImage bufferedImage = null;
            Graphics graphics = null;
            PreviewDialog.this.renderer.render(PreviewDialog.this.currentPage);
            bufferedImage = PreviewDialog.this.renderer.getLastRenderedPage();
            if (bufferedImage == null) {
                return;
            }
            graphics = bufferedImage.getGraphics();
            graphics.setColor(Color.black);
            graphics.drawRect(0, 0, bufferedImage.getWidth() - 1, bufferedImage.getHeight() - 1);
            PreviewDialog.this.previewImageLabel.setIcon(new ImageIcon(bufferedImage));
            PreviewDialog.this.pageCount = PreviewDialog.this.renderer.getPageCount();
            PreviewDialog.this.statisticsStatus.setText(String.valueOf(PreviewDialog.this.res.getString("Page")) + " " + (PreviewDialog.this.currentPage + 1) + " " + PreviewDialog.this.res.getString("of") + " " + PreviewDialog.this.pageCount);
        }
    }
}

