/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.io.IOException;
import java.util.HashMap;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.dom.svg.SVGDocumentFactory;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.DocumentDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;

public class DocumentLoader {
    protected SVGDocumentFactory documentFactory;
    protected HashMap cacheMap = new HashMap();
    protected UserAgent userAgent;
    protected BridgeContext bridgeContext;

    protected DocumentLoader() {
    }

    public DocumentLoader(UserAgent userAgent) {
        this.userAgent = userAgent;
        this.documentFactory = new SAXSVGDocumentFactory(userAgent.getXMLParserClassName(), true);
        this.documentFactory.setValidating(userAgent.isXMLParserValidating());
    }

    public Document loadDocument(String string) throws IOException {
        DocumentState documentState;
        int n = string.indexOf(35);
        if (n != -1) {
            string = string.substring(0, n);
        }
        if ((documentState = (DocumentState)this.cacheMap.get(string)) == null) {
            SVGOMDocument sVGOMDocument = this.documentFactory.createDocument(string);
            if (this.bridgeContext != null) {
                this.bridgeContext.initializeDocument(sVGOMDocument);
            }
            DocumentDescriptor documentDescriptor = this.documentFactory.getDocumentDescriptor();
            documentState = new DocumentState(string, sVGOMDocument, documentDescriptor);
            this.cacheMap.put(string, documentState);
        }
        return documentState.document;
    }

    public void setBridgeContext(BridgeContext bridgeContext) {
        this.bridgeContext = bridgeContext;
    }

    public void dispose() {
        this.cacheMap.clear();
    }

    public int getLineNumber(Element element) {
        String string = ((SVGDocument)element.getOwnerDocument()).getURL();
        DocumentState documentState = (DocumentState)this.cacheMap.get(string);
        if (documentState == null) {
            return -1;
        }
        return documentState.desc.getLocationLine(element);
    }

    private static class DocumentState {
        private String uri;
        private Document document;
        private DocumentDescriptor desc;

        public DocumentState(String string, Document document, DocumentDescriptor documentDescriptor) {
            this.uri = string;
            this.document = document;
            this.desc = documentDescriptor;
        }

        public DocumentDescriptor getDocumentDescriptor() {
            return this.desc;
        }

        public String getURI() {
            return this.uri;
        }

        public Document getDocument() {
            return this.document;
        }
    }
}

