/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import org.apache.batik.dom.svg.AbstractElement;
import org.apache.batik.dom.svg.LiveAttributeValue;
import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.parser.LengthParser;
import org.apache.batik.parser.ParseException;
import org.apache.batik.util.UnitProcessor;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGAnimatedLength;
import org.w3c.dom.svg.SVGLength;

public abstract class AbstractSVGAnimatedLength
implements SVGAnimatedLength,
LiveAttributeValue {
    public static final short HORIZONTAL_LENGTH = 2;
    public static final short VERTICAL_LENGTH = 1;
    public static final short OTHER_LENGTH = 0;
    protected static final String[] UNITS = new String[]{"", "", "%", "em", "ex", "px", "cm", "mm", "in", "pt", "pc"};
    protected AbstractElement element;
    protected String namespaceURI;
    protected String localName;
    protected short direction;
    protected BaseSVGLength baseVal;
    protected boolean changing;

    protected AbstractSVGAnimatedLength(AbstractElement abstractElement, String string, String string2, short s) {
        this.element = abstractElement;
        this.namespaceURI = string;
        this.localName = string2;
        this.direction = s;
    }

    protected abstract String getDefaultValue();

    public SVGLength getBaseVal() {
        if (this.baseVal == null) {
            this.baseVal = new BaseSVGLength();
        }
        return this.baseVal;
    }

    public SVGLength getAnimVal() {
        throw new RuntimeException("!!! TODO: getAnimVal()");
    }

    public void attrAdded(Attr attr, String string) {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
    }

    public void attrModified(Attr attr, String string, String string2) {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
    }

    public void attrRemoved(Attr attr, String string) {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
    }

    protected class BaseSVGLength
    implements SVGLength {
        protected short unitType;
        protected float value;
        protected boolean valid;
        protected UnitProcessor.Context context = new DefaultContext();

        public void invalidate() {
            this.valid = false;
        }

        public short getUnitType() {
            this.revalidate();
            return this.unitType;
        }

        public float getValue() {
            this.revalidate();
            return UnitProcessor.svgToUserSpace(this.value, this.unitType, AbstractSVGAnimatedLength.this.direction, this.context);
        }

        public void setValue(float f) throws DOMException {
            this.revalidate();
            this.value = UnitProcessor.userSpaceToSVG(f, this.unitType, AbstractSVGAnimatedLength.this.direction, this.context);
            this.resetAttribute();
        }

        public float getValueInSpecifiedUnits() {
            this.revalidate();
            return this.value;
        }

        public void setValueInSpecifiedUnits(float f) throws DOMException {
            this.revalidate();
            this.value = f;
            this.resetAttribute();
        }

        public String getValueAsString() {
            Attr attr = AbstractSVGAnimatedLength.this.element.getAttributeNodeNS(AbstractSVGAnimatedLength.this.namespaceURI, AbstractSVGAnimatedLength.this.localName);
            if (attr == null) {
                return AbstractSVGAnimatedLength.this.getDefaultValue();
            }
            return attr.getValue();
        }

        public void setValueAsString(String string) throws DOMException {
            AbstractSVGAnimatedLength.this.element.setAttributeNS(AbstractSVGAnimatedLength.this.namespaceURI, AbstractSVGAnimatedLength.this.localName, string);
        }

        public void newValueSpecifiedUnits(short s, float f) {
            this.unitType = s;
            this.value = f;
            this.resetAttribute();
        }

        public void convertToSpecifiedUnits(short s) {
            float f = this.getValue();
            this.unitType = s;
            this.setValue(f);
        }

        protected void resetAttribute() {
            try {
                AbstractSVGAnimatedLength.this.changing = true;
                this.setValueAsString(this.value + UNITS[this.unitType]);
                Object var2_1 = null;
                AbstractSVGAnimatedLength.this.changing = false;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                AbstractSVGAnimatedLength.this.changing = false;
                throw throwable;
            }
        }

        protected void revalidate() {
            if (this.valid) {
                return;
            }
            String string = this.getValueAsString();
            try {
                LengthParser lengthParser = new LengthParser();
                UnitProcessor.UnitResolver unitResolver = new UnitProcessor.UnitResolver();
                lengthParser.setLengthHandler(unitResolver);
                lengthParser.parse(string);
                this.unitType = unitResolver.unit;
                this.value = unitResolver.value;
            }
            catch (ParseException parseException) {
                this.unitType = 0;
                this.value = 0.0f;
            }
            this.valid = true;
        }

        protected class DefaultContext
        implements UnitProcessor.Context {
            protected DefaultContext() {
            }

            public Element getElement() {
                return ((BaseSVGLength)BaseSVGLength.this).AbstractSVGAnimatedLength.this.element;
            }

            public float getPixelToMM() {
                return ((SVGOMElement)((BaseSVGLength)BaseSVGLength.this).AbstractSVGAnimatedLength.this.element).getSVGContext().getPixelToMM();
            }

            public float getFontSize() {
                return ((SVGOMElement)((BaseSVGLength)BaseSVGLength.this).AbstractSVGAnimatedLength.this.element).getSVGContext().getFontSize();
            }

            public float getXHeight() {
                return 0.5f;
            }

            public float getViewportWidth() {
                return ((SVGOMElement)((BaseSVGLength)BaseSVGLength.this).AbstractSVGAnimatedLength.this.element).getSVGContext().getViewportWidth();
            }

            public float getViewportHeight() {
                return ((SVGOMElement)((BaseSVGLength)BaseSVGLength.this).AbstractSVGAnimatedLength.this.element).getSVGContext().getViewportHeight();
            }
        }
    }
}

