/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.image;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.batik.ext.awt.image.codec.PNGEncodeParam;
import org.apache.batik.ext.awt.image.codec.PNGImageEncoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.resources.Messages;
import org.apache.batik.transcoder.keys.FloatKey;

public class PNGTranscoder
extends ImageTranscoder {
    public static final TranscodingHints.Key KEY_FORCE_TRANSPARENT_WHITE = ImageTranscoder.KEY_FORCE_TRANSPARENT_WHITE;
    public static final TranscodingHints.Key KEY_GAMMA = new FloatKey();

    public PNGTranscoder() {
        this.hints.put(KEY_FORCE_TRANSPARENT_WHITE, Boolean.FALSE);
    }

    public BufferedImage createImage(int n, int n2) {
        return new BufferedImage(n, n2, 2);
    }

    public void writeImage(BufferedImage bufferedImage, TranscoderOutput transcoderOutput) throws TranscoderException {
        OutputStream outputStream = transcoderOutput.getOutputStream();
        if (outputStream == null) {
            throw new TranscoderException(Messages.formatMessage("png.badoutput", null));
        }
        PNGEncodeParam.RGB rGB = (PNGEncodeParam.RGB)PNGEncodeParam.getDefaultEncodeParam(bufferedImage);
        rGB.setBackgroundRGB(new int[]{255, 255, 255});
        if (this.hints.containsKey(KEY_GAMMA)) {
            rGB.setGamma(((Float)this.hints.get(KEY_GAMMA)).floatValue());
        }
        rGB.setSRGBIntent(0);
        float f = this.userAgent.getPixelToMM();
        int n = (int)((double)(1000.0f / f) + 0.5);
        rGB.setPhysicalDimension(n, n, 1);
        boolean bl = false;
        if (this.hints.containsKey(KEY_FORCE_TRANSPARENT_WHITE)) {
            bl = (Boolean)this.hints.get(KEY_FORCE_TRANSPARENT_WHITE);
        }
        if (bl) {
            int n2 = bufferedImage.getWidth();
            int n3 = bufferedImage.getHeight();
            DataBufferInt dataBufferInt = (DataBufferInt)bufferedImage.getRaster().getDataBuffer();
            int n4 = ((SinglePixelPackedSampleModel)bufferedImage.getSampleModel()).getScanlineStride();
            int n5 = dataBufferInt.getOffset();
            int[] nArray = dataBufferInt.getBankData()[0];
            int n6 = n5;
            int n7 = n4 - n2;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            int n13 = 0;
            while (n13 < n3) {
                int n14 = 0;
                while (n14 < n2) {
                    n12 = nArray[n6];
                    n8 = n12 >> 24 & 0xFF;
                    n9 = n12 >> 16 & 0xFF;
                    n10 = n12 >> 8 & 0xFF;
                    n11 = n12 & 0xFF;
                    n9 = (255 * (255 - n8) + n8 * n9) / 255;
                    n10 = (255 * (255 - n8) + n8 * n10) / 255;
                    n11 = (255 * (255 - n8) + n8 * n11) / 255;
                    nArray[n6++] = n8 << 24 & 0xFF000000 | n9 << 16 & 0xFF0000 | n10 << 8 & 0xFF00 | n11 & 0xFF;
                    ++n14;
                }
                n6 += n7;
                ++n13;
            }
        }
        try {
            PNGImageEncoder pNGImageEncoder = new PNGImageEncoder(outputStream, rGB);
            pNGImageEncoder.encode(bufferedImage);
            outputStream.close();
        }
        catch (IOException iOException) {
            throw new TranscoderException(iOException);
        }
    }
}

