/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.tools.anttasks;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.apache.fop.layout.hyphenation.HyphenationException;
import org.apache.fop.layout.hyphenation.HyphenationTree;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;

public class SerializeHyphPattern
extends MatchingTask {
    private File sourceDir;
    private File targetDir;
    private boolean errorDump = false;

    public void execute() throws BuildException {
        DirectoryScanner directoryScanner = this.getDirectoryScanner(this.sourceDir);
        String[] stringArray = directoryScanner.getIncludedFiles();
        int n = 0;
        while (n < stringArray.length) {
            this.processFile(stringArray[n].substring(0, stringArray[n].length() - 4));
            ++n;
        }
    }

    public void setSourceDir(String string) {
        File file = new File(string);
        if (!file.exists()) {
            System.err.println("Fatal Error: source directory " + string + " for hyphenation files doesn't exist.");
            System.exit(1);
        }
        this.sourceDir = file;
    }

    public void setTargetDir(String string) {
        File file;
        this.targetDir = file = new File(string);
    }

    public void setErrorDump(boolean bl) {
        this.errorDump = bl;
    }

    private void processFile(String string) {
        File file = new File(this.sourceDir, string + ".xml");
        File file2 = new File(this.targetDir, string + ".hyp");
        long l = file2.lastModified();
        boolean bl = true;
        bl = this.rebuild(file, file2);
        if (bl) {
            this.buildPatternFile(file, file2);
        }
    }

    private void buildPatternFile(File file, File file2) {
        HyphenationTree hyphenationTree;
        block5: {
            System.out.println("Processing " + file);
            hyphenationTree = new HyphenationTree();
            try {
                hyphenationTree.loadPatterns(file.toString());
                if (this.errorDump) {
                    System.out.println("Stats: ");
                    hyphenationTree.printStats();
                }
            }
            catch (HyphenationException hyphenationException) {
                System.err.println("Can't load patterns from xml file " + file + " - Maybe hyphenation.dtd is missing?");
                if (!this.errorDump) break block5;
                System.err.println(hyphenationException.toString());
            }
        }
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file2));
            objectOutputStream.writeObject(hyphenationTree);
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            System.err.println("Can't write compiled pattern file: " + file2);
            System.err.println(iOException);
        }
    }

    private boolean rebuild(File file, File file2) {
        if (file2.exists()) {
            return file2.lastModified() < file.lastModified();
        }
        return true;
    }
}

