/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.fo.flow.Inline;
import org.apache.fop.layout.AccessibilityProps;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.AuralProps;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.LinkSet;
import org.apache.fop.layout.MarginInlineProps;
import org.apache.fop.layout.Page;
import org.apache.fop.layout.RelativePositionProps;

public class BasicLink
extends Inline {
    public BasicLink(FObj fObj, PropertyList propertyList) throws FOPException {
        super(fObj, propertyList);
        this.name = "fo:basic-link";
    }

    public Status layout(Area area) throws FOPException {
        Object object;
        Object object2;
        int n;
        AccessibilityProps accessibilityProps = this.propMgr.getAccessibilityProps();
        AuralProps auralProps = this.propMgr.getAuralProps();
        BorderAndPadding borderAndPadding = this.propMgr.getBorderAndPadding();
        BackgroundProps backgroundProps = this.propMgr.getBackgroundProps();
        MarginInlineProps marginInlineProps = this.propMgr.getMarginInlineProps();
        RelativePositionProps relativePositionProps = this.propMgr.getRelativePositionProps();
        String string = this.properties.get("internal-destination").getString();
        if (!string.equals("")) {
            n = 0;
        } else {
            string = this.properties.get("external-destination").getString();
            if (!string.equals("")) {
                n = 1;
            } else {
                throw new FOPException("internal-destination or external-destination must be specified in basic-link");
            }
        }
        if (this.marker == -1000) {
            object2 = this.properties.get("id").getString();
            area.getIDReferences().initializeID((String)object2, area);
            this.marker = 0;
        }
        object2 = new LinkSet(string, area, n);
        Page page = area.getPage();
        AreaContainer areaContainer = page.getBody().getCurrentColumnArea();
        if (areaContainer == null) {
            throw new FOPException("Couldn't get ancestor AreaContainer when processing basic-link");
        }
        int n2 = this.children.size();
        int n3 = this.marker;
        while (n3 < n2) {
            object = (FONode)this.children.elementAt(n3);
            ((FONode)object).setLinkSet((LinkSet)object2);
            Status status = ((FONode)object).layout(area);
            if (status.isIncomplete()) {
                this.marker = n3;
                return status;
            }
            ++n3;
        }
        ((LinkSet)object2).applyAreaContainerOffsets(areaContainer, area);
        object = System.getProperty("links.merge");
        if (object != null && !((String)object).equalsIgnoreCase("no")) {
            ((LinkSet)object2).mergeLinks();
        }
        page.addLinkSet((LinkSet)object2);
        return new Status(1);
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new BasicLink(fObj, propertyList);
        }
    }
}

