/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layout;

import java.util.Hashtable;
import org.apache.fop.apps.FOPException;
import org.apache.fop.layout.FontMetric;
import org.apache.fop.messaging.MessageHandler;

public class FontInfo {
    Hashtable usedFonts;
    Hashtable triplets = new Hashtable();
    Hashtable fonts = new Hashtable();

    public FontInfo() {
        this.usedFonts = new Hashtable();
    }

    public void addFontProperties(String string, String string2, String string3, String string4) {
        String string5 = FontInfo.createFontKey(string2, string3, string4);
        this.triplets.put(string5, string);
    }

    public void addMetrics(String string, FontMetric fontMetric) {
        this.fonts.put(string, fontMetric);
    }

    public static String createFontKey(String string, String string2, String string3) {
        int n;
        try {
            n = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        if (n > 600) {
            string3 = "bold";
        } else if (n > 0) {
            string3 = "normal";
        }
        return String.valueOf(string) + "," + string2 + "," + string3;
    }

    public String fontLookup(String string) throws FOPException {
        String string2 = (String)this.triplets.get(string);
        if (string2 == null) {
            int n = string.indexOf(44);
            String string3 = "any" + string.substring(n);
            string2 = (String)this.triplets.get(string3);
            if (string2 == null) {
                string2 = (String)this.triplets.get("any,normal,normal");
                if (string2 == null) {
                    throw new FOPException("no default font defined by OutputConverter");
                }
                MessageHandler.errorln("defaulted font to any,normal,normal");
            }
            MessageHandler.errorln("unknown font " + string + " so defaulted font to any");
        }
        this.usedFonts.put(string2, this.fonts.get(string2));
        return string2;
    }

    public String fontLookup(String string, String string2, String string3) throws FOPException {
        return this.fontLookup(FontInfo.createFontKey(string, string2, string3));
    }

    public Hashtable getFonts() {
        return this.fonts;
    }

    public FontMetric getMetricsFor(String string) throws FOPException {
        this.usedFonts.put(string, this.fonts.get(string));
        return (FontMetric)this.fonts.get(string);
    }

    public Hashtable getUsedFonts() {
        return this.usedFonts;
    }

    public boolean hasFont(String string) {
        return this.triplets.get(string) != null;
    }

    public boolean hasFont(String string, String string2, String string3) {
        String string4 = FontInfo.createFontKey(string, string2, string3);
        return this.triplets.get(string4) != null;
    }
}

