/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class ResultManager {
    int numberOfOutputTypes;
    GUI gui;
    String[] header;
    long elapsedTime;
    String text;
    int resultsPointer;
    boolean reverseResults;
    String temp;
    Result[] results;
    boolean statusBarVisible = false;
    JFrame newWindow;
    Component[] outputCache;
    Component[] outputInNewWindowCache;
    final String INTERLINGUAWORD_EXPRESSION = "^ ([:alpha:]|[\\-\\.\\,])+( ?, ?([:alpha:]|[\\-\\.\\,])+)* $";
    RE wordRegexp;
    Prefs prefs;
    OutputTypeChooserToolBar outputTypeChooserToolBar;

    public ResultManager(boolean reverseResults, GUI gui, int maxNumberOfResults, Prefs prefs, String text) {
        this.prefs = prefs;
        this.reverseResults = reverseResults;
        this.gui = gui;
        this.text = text;
        try {
            this.wordRegexp = !reverseResults ? new RE("^ ([:alpha:]|[\\-\\.\\,])+( ?, ?([:alpha:]|[\\-\\.\\,])+)* $") : new RE("^ ([:alpha:]|[\\-\\.\\,])+( ?, ?([:alpha:]|[\\-\\.\\,])+)* $");
        }
        catch (RESyntaxException rESyntaxException) {
            // empty catch block
        }
        this.results = new Result[maxNumberOfResults + 1];
        this.text = reverseResults ? String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf('\"'))).append(text).append('\"').append(" (").append(Resources.getString("Column2")).append(" - ").append(Resources.getString("Column1")).append(")"))) : String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf('\"'))).append(text).append('\"').append(" (").append(Resources.getString("Column1")).append(" - ").append(Resources.getString("Column2")).append(")")));
        this.numberOfOutputTypes = 2;
        this.outputCache = new Component[this.numberOfOutputTypes];
        this.outputInNewWindowCache = new Component[this.numberOfOutputTypes];
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void jbInit() {
        this.outputTypeChooserToolBar = new OutputTypeChooserToolBar(this.prefs, this.numberOfOutputTypes);
        this.outputTypeChooserToolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.outputTypeChooserToolBar.increment.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ResultManager.this.outputTypeChooserToolBar.increment();
                ResultManager.this.outputManager(false);
            }
        });
        this.outputTypeChooserToolBar.decrement.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ResultManager.this.outputTypeChooserToolBar.decrement();
                ResultManager.this.outputManager(false);
            }
        });
        this.outputTypeChooserToolBar.newWindow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ResultManager.this.outputManager(true);
            }
        });
    }

    public void putResult(Result result) {
        this.results[this.resultsPointer] = result;
        if (result == null) {
            if (this.resultsPointer > 0) {
                this.outputManager(false);
            } else {
                this.updateStatusBar();
            }
            return;
        }
        ++this.resultsPointer;
    }

    Component generateMassOutput() {
        Result result;
        JEditorPane htmlPane = new JEditorPane();
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().add(htmlPane);
        htmlPane.setEditable(false);
        htmlPane.setContentType("text/html");
        int n = 0;
        StringBuffer outputHTML = new StringBuffer("<table width=\"100%\"");
        boolean color = true;
        while ((result = this.results[n++]) != null) {
            if (color) {
                outputHTML.append(String.valueOf(String.valueOf(new StringBuffer("<font face=\"arial, helvetica\"><tr bgcolor=\"#F2F2F2\"><td><dl><dt><b>").append(result.getBase()).append("</b><dd>").append(result.getTranslation()).append("</dl></td></tr></font>"))));
            } else {
                outputHTML.append(String.valueOf(String.valueOf(new StringBuffer("<font face=\"arial, helvetica\"><tr><td><dl><dt><b>").append(result.getBase()).append("</b><dd>").append(result.getTranslation()).append("</dl></td></tr></font>"))));
            }
            color = !color;
        }
        outputHTML.append("</table>");
        htmlPane.setText(outputHTML.toString());
        htmlPane.addMouseListener(new HtmlPanePopup(htmlPane));
        return scrollPane;
    }

    Component generateTWSeparatedOutput() {
        JEditorPane wordPane = new JEditorPane();
        JEditorPane expressionPane = new JEditorPane();
        wordPane.setEditable(false);
        wordPane.setContentType("text/html");
        expressionPane.setEditable(false);
        expressionPane.setContentType("text/html");
        JTabbedPane outputTabbedPane = new JTabbedPane();
        JScrollPane expressionScrollPane = new JScrollPane();
        JScrollPane wordScrollPane = new JScrollPane();
        wordScrollPane.getViewport().add(wordPane);
        expressionScrollPane.getViewport().add(expressionPane);
        StringBuffer wordOutputHTML = new StringBuffer("<table width=\"100%\">");
        StringBuffer expressionOutputHTML = new StringBuffer("<table width=\"100%\">");
        boolean wordColor = true;
        boolean expressionColor = true;
        int wordCount = 0;
        int expressionCount = 0;
        int m = 0;
        Result result = null;
        Result[] expressions = new Result[this.resultsPointer];
        Result[] words = new Result[this.resultsPointer];
        while ((result = this.results[m++]) != null) {
            if (this.wordRegexp.match(result.getBase())) {
                words[wordCount] = result;
                ++wordCount;
                if (wordColor) {
                    wordOutputHTML.append(String.valueOf(String.valueOf(new StringBuffer("<font face=\"arial, helvetica\"><tr bgcolor=\"#F2F2F2\"><td><dl><dt><b>").append(result.getBase()).append("</b><dd>").append(result.getTranslation()).append("</dl></td></tr></font>"))));
                } else {
                    wordOutputHTML.append(String.valueOf(String.valueOf(new StringBuffer("<font face=\"arial, helvetica\"><tr><td><dl><dt><b>").append(result.getBase()).append("</b><dd>").append(result.getTranslation()).append("</dl></td></tr></font>"))));
                }
                wordColor = !wordColor;
                continue;
            }
            expressions[expressionCount] = result;
            ++expressionCount;
            if (expressionColor) {
                expressionOutputHTML.append(String.valueOf(String.valueOf(new StringBuffer("<font face=\"arial, helvetica\"><tr bgcolor=\"#F2F2F2\"><td><dl><dt><b>").append(result.getBase()).append("</b><dd>").append(result.getTranslation()).append("</dl></td></tr></font>"))));
            } else {
                expressionOutputHTML.append(String.valueOf(String.valueOf(new StringBuffer("<font face=\"arial, helvetica\"><tr><td><dl><dt><b>").append(result.getBase()).append("</b><dd>").append(result.getTranslation()).append("</dl></td></tr></font>"))));
            }
            expressionColor = !expressionColor;
        }
        wordOutputHTML.append("</table>");
        expressionOutputHTML.append("</table>");
        wordPane.setText(wordOutputHTML.toString());
        expressionPane.setText(expressionOutputHTML.toString());
        if (wordCount > 1) {
            outputTabbedPane.add(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Resources.getString("Words")))).append(" (").append(wordCount).append(" ").append(Resources.getString("Results")).append(") "))), wordScrollPane);
        } else if (wordCount == 1) {
            outputTabbedPane.add(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Resources.getString("Words")))).append(" (").append(wordCount).append(" ").append(Resources.getString("Result")).append(") "))), wordScrollPane);
        } else {
            outputTabbedPane.add(String.valueOf(String.valueOf(Resources.getString("Words"))).concat(String.valueOf(String.valueOf(Resources.getString("NoResult")))), wordScrollPane);
            outputTabbedPane.setEnabledAt(0, false);
        }
        if (expressionCount > 1) {
            outputTabbedPane.add(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Resources.getString("Terms")))).append(" (").append(expressionCount).append(" ").append(Resources.getString("Results")).append(") "))), expressionScrollPane);
        } else if (expressionCount == 1) {
            outputTabbedPane.add(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Resources.getString("Terms")))).append(" (").append(expressionCount).append(" ").append(Resources.getString("Result")).append(") "))), expressionScrollPane);
        } else {
            outputTabbedPane.add(String.valueOf(String.valueOf(Resources.getString("Terms"))).concat(String.valueOf(String.valueOf(Resources.getString("NoResult")))), expressionScrollPane);
            outputTabbedPane.setEnabledAt(1, false);
        }
        for (int n = 0; n < outputTabbedPane.getTabCount(); ++n) {
            if (!outputTabbedPane.isEnabledAt(n)) continue;
            outputTabbedPane.setSelectedIndex(n);
            break;
        }
        wordPane.addMouseListener(new HtmlPanePopup(wordPane));
        expressionPane.addMouseListener(new HtmlPanePopup(expressionPane));
        return outputTabbedPane;
    }

    void showOutput(Component component) {
        this.gui.outputPanel.removeAll();
        this.gui.outputPanel.setBackground(UIManager.getColor("Panel.background"));
        BorderLayout cfr_ignored_0 = (BorderLayout)this.gui.outputPanel.getLayout();
        this.gui.outputPanel.add(component, "Center", 0);
        this.gui.outputPanel.validate();
        this.gui.outputPanel.repaint();
    }

    void showOutputInNewWindow(Component comp) {
        if (this.newWindow != null) {
            ((Component)this.newWindow).setVisible(true);
            return;
        }
        this.newWindow = new JFrame(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Resources.getString("OutputFor")))).append(" ").append(this.text))));
        final BorderLayout borderLayout = new BorderLayout();
        Prefs tempPrefs = new Prefs();
        tempPrefs.lastSelectedOutputType = this.prefs.lastSelectedOutputType;
        final OutputTypeChooserToolBar typeChooser = new OutputTypeChooserToolBar(tempPrefs, this.numberOfOutputTypes, false);
        typeChooser.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        JLabel label = new JLabel(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Resources.getString("NumberOfResults")))).append(this.resultsPointer).append(Resources.getString("TakenTimePrefix")).append((float)this.elapsedTime / (float)1000).append(Resources.getString("TakenTimePostfix")).append("    "))), IconBank.info, 0);
        toolBar.add(label);
        toolBar.add(typeChooser);
        this.newWindow.getContentPane().setLayout(borderLayout);
        this.newWindow.getContentPane().add(comp, "Center", 0);
        this.newWindow.getContentPane().add((Component)toolBar, "South");
        ((Frame)this.newWindow).setIconImage(IconBank.world.getImage());
        this.newWindow.pack();
        ((Component)this.newWindow).setSize(500, 350);
        ((Component)this.newWindow).setVisible(true);
        typeChooser.increment.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                typeChooser.increment();
                Component comp = ResultManager.this.outputFactory(typeChooser, true);
                ResultManager.this.newWindow.getContentPane().remove(0);
                ResultManager.this.newWindow.getContentPane().add(comp, "Center", 0);
                ResultManager.this.newWindow.validate();
                ResultManager.this.newWindow.repaint();
            }
        });
        typeChooser.decrement.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                typeChooser.decrement();
                Component comp = ResultManager.this.outputFactory(typeChooser, true);
                ResultManager.this.newWindow.getContentPane().remove(0);
                ResultManager.this.newWindow.getContentPane().add(comp, "Center", 0);
                ResultManager.this.newWindow.validate();
                ResultManager.this.newWindow.repaint();
            }
        });
    }

    public void updateStatusBar() {
        if (this.statusBarVisible) {
            return;
        }
        String message = null;
        if (this.resultsPointer > 0) {
            message = new String(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Resources.getString("NumberOfResults")))).append(this.resultsPointer).append(Resources.getString("TakenTimePrefix")).append((float)this.elapsedTime / (float)1000).append(Resources.getString("TakenTimePostfix")).append("    "))));
            this.gui.setStatusMessage(message, IconBank.info, this.outputTypeChooserToolBar);
        } else {
            this.gui.putMessageToOutputPanel(Resources.getString("NoMatch"), IconBank.info);
        }
        this.statusBarVisible = true;
    }

    void outputManager(boolean showInNewWindow) {
        if (showInNewWindow) {
            this.showOutputInNewWindow(this.outputFactory(this.outputTypeChooserToolBar, true));
        } else {
            if (!this.statusBarVisible) {
                this.gui.putMessageToOutputPanel(Resources.getString("Generating"), IconBank.hourGlass);
            }
            this.showOutput(this.outputFactory(this.outputTypeChooserToolBar, false));
        }
        this.updateStatusBar();
    }

    Component outputFactory(OutputTypeChooserToolBar outputTypeChooserToolBar, boolean newWindow) {
        int selected = outputTypeChooserToolBar.getSelected();
        if (!newWindow && this.outputCache[selected] == null || newWindow && this.outputInNewWindowCache[selected] == null) {
            Component comp;
            switch (outputTypeChooserToolBar.getSelected()) {
                case 0: {
                    comp = this.generateMassOutput();
                    break;
                }
                case 1: {
                    comp = this.generateTWSeparatedOutput();
                    break;
                }
                default: {
                    comp = this.generateTWSeparatedOutput();
                }
            }
            if (newWindow) {
                this.outputInNewWindowCache[selected] = comp;
            } else {
                this.outputCache[selected] = comp;
            }
        }
        if (newWindow) {
            return this.outputInNewWindowCache[selected];
        }
        return this.outputCache[selected];
    }
}

