/* node.h
 * libxml++ and this file are copyright (C) 2000 by Ari Johnson, and
 * are covered by the GNU Lesser General Public License, which should be
 * included with libxml++ as the file COPYING.
 */

#ifndef __LIBXMLPP_NODES_NODE_H
#define __LIBXMLPP_NODES_NODE_H

#include <string>
#include <list>
#include <map>

#include <libxml/tree.h>

namespace xmlpp {

class TextNode;
class Element;

/** Represents XML Nodes.
 * You should never new or delete Nodes. The Parser will create and manage them for you.
 */
class Node
{
public:
  typedef std::list<Node*> NodeList;

  explicit Node(const std::string& name);
  explicit Node(const Node* from);
  explicit Node(xmlNodePtr node);
  virtual ~Node();

  std::string get_name() const;
  int get_line() const;

  bool has_content() const;
  
  TextNode* get_child_content();
  const TextNode* get_child_content() const;
  TextNode* add_content(const std::string& name = std::string());
  void set_child_content(const std::string& content);
  
  NodeList get_children(const std::string& name = std::string());
  const NodeList get_children(const std::string& name = std::string()) const;

  Element* add_child(const std::string& name);
  Node* add_child(Node* node);


  /** Remove the child node.
   * @param node The child node to remove. This Node will be deleted and therefore unusable after calling this method.
   */
  void remove_child(Node* node);

  virtual void write(xmlDocPtr doc, xmlNodePtr parent = 0) const;

protected:
  Node::NodeList _children;
  
private:
  std::string _name;
  int _line;
};

} // namespace xmlpp

#endif //__LIBXMLPP_NODES_NODE_H



