/* xml++.h
 * libxml++ and this file are copyright (C) 2000 by Ari Johnson, and
 * are covered by the GNU Lesser General Public License, which should be
 * included with libxml++ as the file COPYING.
 */

#ifndef __LIBXMLPP_PARSERS_SAXPARSER_H
#define __LIBXMLPP_PARSERS_SAXPARSER_H

#include <libxml/parser.h>
#include <libxml++/parsers/parser.h>
#include <list>
#include <map>


namespace xmlpp {

/** SAX XML parser.
 * Derive your own class and override the on_*() methods.
 */
class SaxParser : public Parser
{
public:
  SaxParser();
  virtual ~SaxParser();

  virtual void parse_file(const std::string& filename) throw(exception);
  virtual void parse_memory(const std::string& contents) throw(exception);
  virtual void parse_stream(std::istream& in) throw(exception);

protected:
  virtual xmlEntityPtr on_get_entity(const xmlChar* name);
  virtual void on_start_document();
  virtual void on_end_document();
  virtual void on_start_element(const std::string& name, const Element::AttributeMap& attributes);
  virtual void on_end_element(const std::string& name);
  virtual void on_characters(const std::string& characters);
  virtual void on_comment(const std::string& text);
  virtual void on_warning(const std::string& text);
  virtual void on_error(const std::string& text);
  virtual void on_fatal_error(const std::string& text);

private:
  void parse();
  void handleException(const exception& e);
  static xmlEntityPtr _callback_get_entity(void *_parser, const xmlChar *name);
  static void _callback_start_document(void *_parser);
  static void _callback_end_document(void *_parser);
  static void _callback_start_element(void *_parser, const xmlChar *name, const xmlChar **p);
  static void _callback_end_element(void *_parser, const xmlChar *name);
  static void _callback_characters(void *_parser, const xmlChar *ch, int len);
  static void _callback_comment(void *_parser, const xmlChar *value);
  static void _callback_warning(void *_parser, const char *fmt, ...);
  static void _callback_error(void *_parser, const char *fmt, ...);
  static void _callback_fatal_error(void *_parser, const char *fmt, ...);

  xmlParserCtxtPtr _context;
  xmlSAXHandler _sax_handler;
  exception * _exception;
};




} // namespace xmlpp

#endif //__LIBXMLPP_PARSERS_SAXPARSER_H



