from __future__ import generators

from urlparse import urlparse        

from rdflib.syntax.parser import Parser
from rdflib.syntax.nt_parser import NTParser

from rdflib.syntax.serializer import Serializer

from rdflib.URIRef import URIRef

from threading import Lock

from time import time, gmtime

def generate_path():
    sn = 0
    last_time_path = None
    while 1:
        t = time()
        year, month, day, hh, mm, ss, wd, y, z = gmtime(t)           
        time_path = "%0004d/%02d/%02d/T%02d/%02d/%02dZ" % ( year, month, day, hh, mm, ss)

        if time_path==last_time_path:
            sn = sn + 1
        else:
            sn = 0
            last_time_path = time_path

        path = time_path + "%.004d" % sn
        yield path

path_generator = generate_path()


class LoadSave(NTParser, Parser, Serializer, object):
    """LoadSave

    Mixed-in with a store that implements add and visit and provides
    I/O for that class. Also, needs to be mixed in with something that
    provides parse_URI and output methods.
    """
    
    def __init__(self):
        super(LoadSave, self).__init__()
        self.uri = None
        self.location = None
        self.__lock = Lock()

    def load(self, location, uri=None, create=0):
        self.uri = URIRef(uri or location)

        scheme, netloc, path, params, query, fragment = urlparse(location)
        if create and netloc=="":
            import os
            # TODO: is this equiv to os.path.exists?            
            if not os.access(path, os.F_OK): 
                self.save(path, None)
        if netloc=="":
            location = "file:%s" % location

        if location[-3:]==".nt":
            self.parse_nt_URI(location, self.uri)
        else:
            self.parse_URI(location, self.uri)

        if not self.location:
            self.location = location        
            

    def save(self, location=None, uri=None):
        try:
            self.__lock.acquire()
            location = location or self.location
            if not location:
                print "WARNING: not saving as no location has been set"
                return
            scheme, netloc, path, params, query, fragment = urlparse(location)
            if netloc!="":
                print "WARNING: not saving as location is not a local file reference"
                return

            uri = uri or self.uri

            import tempfile, shutil, os
            name = tempfile.mktemp()            
            stream = open(name, 'wb')
            self.output(stream)            
            stream.close()

            if os.path.isfile(path):
                os.remove(path)
            shutil.copy(name, path)
            os.unlink(name)

        finally:
            self.__lock.release()
        
