from rdflib.URIRef import URIRef
from rdflib.Namespace import Namespace

# Useful RDF constants

# SYNTAX
RDFNS = Namespace("http://www.w3.org/1999/02/22-rdf-syntax-ns#")

TYPE = RDFNS["type"]
PROPERTY = RDFNS["Property"]
STATEMENT = RDFNS["Statement"]
SUBJECT = RDFNS["subject"]
PREDICATE = RDFNS["predicate"]
OBJECT = RDFNS["object"]

FIRST = RDFNS["first"]
REST = RDFNS["rest"]
NIL = RDFNS["nil"]

# SCHEMA
RDFSNS = Namespace("http://www.w3.org/2000/01/rdf-schema#")

CLASS = RDFSNS["Class"]
RESOURCE = RDFSNS["Resource"]
SUBCLASSOF = RDFSNS["subClassOf"]
SUBPROPERTYOF = RDFSNS["subPropertyOf"]
ISDEFINEDBY = RDFSNS["isDefinedBy"]
LABEL = RDFSNS["label"]
COMMENT = RDFSNS["comment"]
RANGE = RDFSNS["range"]
DOMAIN = RDFSNS["domain"]
LITERAL = RDFSNS["Literal"]
CONTAINER = RDFSNS["Container"]

