# Tiny Tiny eRuby --- String output 
# 	Copyright (c) 1999-2000,2002 Masatoshi SEKI 
#       You can redistribute it and/or modify it under the same term as Ruby.

require 'thread'

class ERbStrIO
  def initialize(str='')
    @str = str.to_s
    @str.taint
    taint
  end
  attr_reader :str

  def write(str)
    @str.concat(str)
  end

  def self.as_stdout
    t = Thread.new {
      Thread.current[:ERbOut] = self.new
      yield
      Thread.current[:ERbOut].str
    }
    t.value
  end

  def self.write(str)
    out = Thread.current[:ERbOut] || @default
    out.write(str.to_s)
  end
  
  @default = $>
  $> = self
end


