
#==============================================================================#
# gyokuro/parts.rb
#==============================================================================#

#==============================================================================#
# Gyokuro Class
class Gyokuro

  class Parts
  end

  class Noun < Parts                   # ̾
    General    = Class.new(self)       #  
    ProperNoun = Class.new(self)       #  ͭ̾
    Pronoun    = Class.new(self)       #  ̾
    Adverb     = Class.new(self)       #  ǽ
    Number     = Class.new(self)       #  
    Special    = Class.new(self)       #  ü
    Suffix     = Class.new(self)       #  
  end

  class Prefix < Parts                 # Ƭ
  end

  class Verb < Parts                   # ư
    Independence   = Class.new(self)   #  Ω
    UnIndependence = Class.new(self)   #  Ω
    Suffix         = Class.new(self)   #  
  end

  class Adjective < Parts              # ƻ
    Independence   = Class.new(self)   #  Ω
    UnIndependence = Class.new(self)   #  Ω
    Suffix         = Class.new(self)   #  
  end

  class Adverb < Parts                 # 
    General = Class.new(self)          #  
  end

  class Attributive < Parts            # Ϣλ
  end

  class Conjunction < Parts            # ³
  end

  class Particle < Parts               # 
  end

  class AuxiliaryVerb < Parts          # ư
  end

  class Exclamation < Parts            # ư
  end

  class Mark < Parts                   # 
    General          = Class.new(self) #  
    Period           = Class.new(self) #  ԥꥪ
    Comma            = Class.new(self) #  
    Space            = Class.new(self) #  
    Alphabet         = Class.new(self) #  ե٥å
    OpenParenthesis  = Class.new(self) #  
    CloseParenthesis = Class.new(self) #  Ĥ
  end

  class Other < Parts                  # ¾
  end

  class Filler < Parts                 # ե顼
  end

  class NonLanguage < Parts            # 첻
  end

  class Fragment < Parts               # 
  end

  class Unknown < Parts                # 
  end

end # Gyokuro

#==============================================================================#
#==============================================================================#
