
#==============================================================================#
# gyokuro/table.rb
#==============================================================================#

#==============================================================================#
# Gyokuro Class
class Gyokuro

  #============================================================================#
  # ʻ 
  PART_OF_SPEECH = [
    [ 0, '̤θ',                        Unknown],
    [ 1, '̾',                          Noun],
    [ 2, '̾-',                     Noun::General],
    [ 3, '̾-ͭ̾',                 Noun::ProperNoun],
    [ 4, '̾-ͭ̾-',            Noun::ProperNoun],
    [ 5, '̾-ͭ̾-̾',            Noun::ProperNoun],
    [ 6, '̾-ͭ̾-̾-',       Noun::ProperNoun],
    [ 7, '̾-ͭ̾-̾-',         Noun::ProperNoun],
    [ 8, '̾-ͭ̾-̾-̾',         Noun::ProperNoun],
    [ 9, '̾-ͭ̾-ȿ',            Noun::ProperNoun],
    [10, '̾-ͭ̾-ϰ',            Noun::ProperNoun],
    [11, '̾-ͭ̾-ϰ-',       Noun::ProperNoun],
    [12, '̾-ͭ̾-ϰ-',         Noun::ProperNoun],
    [13, '̾-̾',                   Noun::Pronoun],
    [14, '̾-̾-',              Noun::Pronoun],
    [15, '̾-̾-',              Noun::Pronoun],
    [16, '̾-ǽ',                 Noun::Adverb],
    [17, '̾-³',                 Noun],
    [18, '̾-ư촴',             Noun],
    [19, '̾-',                       Noun::Number],
    [20, '̾-Ω',                   Noun],
    [21, '̾-Ω-',              Noun],
    [22, '̾-Ω-ǽ',          Noun],
    [23, '̾-Ω-ư촴',        Noun],
    [24, '̾-Ω-ư촴',      Noun],
    [25, '̾-ü',                     Noun::Special],
    [26, '̾-ü-ư촴',          Noun::Special],
    [27, '̾-',                     Noun::Suffix],
    [28, '̾--',                Noun::Suffix],
    [29, '̾--̾',                Noun::Suffix],
    [30, '̾--ϰ',                Noun::Suffix],
    [31, '̾--³',            Noun::Suffix],
    [32, '̾--ư촴',          Noun::Suffix],
    [33, '̾--ư촴',        Noun::Suffix],
    [34, '̾--ǽ',            Noun::Suffix],
    [35, '̾--',              Noun::Suffix],
    [36, '̾--ü',                Noun::Suffix],
    [37, '̾-³Ū',                 Noun],
    [38, '̾-ưΩŪ',             Noun],
    [39, '̾-ʸ',               Noun],
    [40, '̾-ʥƻ촴',           Noun],
    [41, 'Ƭ',                        Prefix],
    [42, 'Ƭ-̾³',               Prefix],
    [43, 'Ƭ-ư³',               Prefix],
    [44, 'Ƭ-ƻ³',             Prefix],
    [45, 'Ƭ-³',                 Prefix],
    [46, 'ư',                          Verb],
    [47, 'ư-Ω',                     Verb::Independence],
    [48, 'ư-Ω',                   Verb::UnIndependence],
    [49, 'ư-',                     Verb::Suffix],
    [50, 'ƻ',                        Adjective],
    [51, 'ƻ-Ω',                   Adjective::Independence],
    [52, 'ƻ-Ω',                 Adjective::UnIndependence],
    [53, 'ƻ-',                   Adjective::Suffix],
    [54, '',                          Adverb],
    [55, '-',                     Adverb::General],
    [56, '-³',               Adverb],
    [57, 'Ϣλ',                        Attributive],
    [58, '³',                        Conjunction],
    [59, '',                          Particle],
    [60, '-ʽ',                   Particle],
    [61, '-ʽ-',              Particle],
    [62, '-ʽ-',              Particle],
    [63, '-ʽ-Ϣ',              Particle],
    [64, '-³',                 Particle],
    [65, '-',                   Particle],
    [66, '-',                   Particle],
    [67, '-',                 Particle],
    [68, '-Ω',                 Particle],
    [69, '-',                   Particle],
    [70, '-졿Ω졿', Particle],
    [71, '-Ϣβ',                   Particle],
    [72, '-첽',                   Particle],
    [73, '-ü',                     Particle],
    [74, 'ư',                        AuxiliaryVerb],
    [75, 'ư',                        Exclamation],
    [76, '',                          Mark],
    [77, '-',                     Mark::General],
    [78, '-',                     Mark::Period],
    [79, '-',                     Mark::Comma],
    [80, '-',                     Mark::Space],
    [81, '-ե٥å',           Mark::Alphabet],
    [82, '-̳',                   Mark::OpenParenthesis],
    [83, '-',                   Mark::CloseParenthesis],
    [84, '¾',                        Other],
    [85, '¾-',                   Other],
    [86, 'ե顼',                      Filler],
    [87, '첻',                      NonLanguage],
    [88, '',                        Fragment],
  ]

  #============================================================================#
  # ѷ 
  CONJUGATED_TYPE = [
    [ 1, 'ѡ'],
    [ 2, 'ѡ'],
    [ 3, 'ѡ'],
    [ 4, 'ѡݥ'],
    [ 5, 'ѡݥ'],
    [ 6, ''],
    [ 7, 'ʡ¥'],
    [ 8, 'ʡԥ'],
    [ 9, 'ʡ¥'],
    [10, 'ʡ¥إ楯'],
    [11, 'ʡ'],
    [12, 'ʡ'],
    [13, 'ʡ'],
    [14, 'ʡʹ'],
    [15, 'ʡй'],
    [16, 'ʡ޹'],
    [17, 'ʡ'],
    [18, 'ʡԥ'],
    [19, 'ʡü'],
    [20, 'ʡԥ'],
    [21, 'ʡ¥'],
    [22, 'ʡ'],
    [23, 'ʡ'],
    [24, 'ʡ'],
    [25, 'ʡ'],
    [26, 'ʡй'],
    [27, 'ʡ޹'],
    [28, 'ʡ'],
    [29, 'ʡϹ'],
    [30, ''],
    [31, '󡦥'],
    [32, '󡦥Ϲ'],
    [33, '󡦥'],
    [34, '󡦥'],
    [35, '󡦥'],
    [36, '󡦥'],
    [37, '󡦥'],
    [38, '󡦥'],
    [39, '󡦥'],
    [40, '󡦥ʹ'],
    [41, '󡦥Ϲ'],
    [42, '󡦥й'],
    [43, '󡦥޹'],
    [44, '󡦥'],
    [45, '󡦥'],
    [46, '󡦥'],
    [47, ''],
    [48, 'ʡ'],
    [49, 'ʡ'],
    [50, 'ƻ졦'],
    [51, 'ƻ졦'],
    [52, 'ü졦ʥ'],
    [53, 'ü졦'],
    [54, 'ü졦'],
    [55, 'ü졦'],
    [56, 'ü졦ǥ'],
    [57, 'ü졦'],
    [58, 'ü졦ޥ'],
    [59, 'ü졦'],
    [60, 'ʸ졦٥'],
    [61, 'ʸ졦ȥ'],
    [62, 'ʸ졦ʥ'],
    [63, 'ʸ졦ޥ'],
    [64, 'ʸ졦'],
    [65, 'ʸ졦'],
    [66, 'ʸ졦'],
    [67, 'ʸ졦'],
    [68, 'ʸ졦'],
    [69, 'Ѳ'],
    [70, 'ʡ'],
    [71, 'ü졦'],
  ]

  #============================================================================#
  # ѷ 
  CONJUGATED_FORM = [
    [ 1,  1, 'ܷ'],
    [ 1,  2, '̤'],
    [ 1,  3, '̤³'],
    [ 1,  4, 'Ϣѷ'],
    [ 1,  5, ''],
    [ 1,  6, '̿'],
    [ 1,  7, '̿'],
    [ 1,  8, ''],
    [ 1,  9, 'θ³ü'],
    [ 1, 10, 'θ³ü죲'],
    [ 2,  1, 'ܷ'],
    [ 2,  2, '̤'],
    [ 2,  3, '̤³'],
    [ 2,  4, 'Ϣѷ'],
    [ 2,  5, ''],
    [ 2,  6, '̿'],
    [ 2,  7, '̿'],
    [ 2,  8, ''],
    [ 2,  9, 'θ³ü'],
    [ 2, 10, 'θ³ü죲'],
    [ 3,  1, 'ܷ'],
    [ 3,  2, 'ʸܷ'],
    [ 3,  3, '̤'],
    [ 3,  4, '̤³'],
    [ 3,  5, '̤³'],
    [ 3,  6, '̤³'],
    [ 3,  7, 'Ϣѷ'],
    [ 3,  8, ''],
    [ 3,  9, '̿'],
    [ 3, 10, '̿'],
    [ 3, 11, '̿'],
    [ 3, 12, ''],
    [ 3, 13, 'θ³ü'],
    [ 3, 14, 'θ³ü죲'],
    [ 4,  1, 'ܷ'],
    [ 4,  2, 'ʸܷ'],
    [ 4,  3, '̤'],
    [ 4,  4, '̤³'],
    [ 4,  5, '̤³'],
    [ 4,  6, ''],
    [ 4,  7, '̿'],
    [ 4,  8, '̿'],
    [ 4,  9, ''],
    [ 5,  1, 'ܷ'],
    [ 5,  2, 'ʸܷ'],
    [ 5,  3, '̤'],
    [ 5,  4, '̤³'],
    [ 5,  5, ''],
    [ 5,  6, '̿'],
    [ 5,  7, ''],
    [ 6,  1, 'ܷ'],
    [ 6,  2, '̤'],
    [ 6,  3, '̤³'],
    [ 6,  4, 'Ϣѷ'],
    [ 6,  5, ''],
    [ 6,  6, '̿'],
    [ 6,  7, '̿'],
    [ 6,  8, ''],
    [ 6,  9, 'θ³ü'],
    [ 7,  1, 'ܷ'],
    [ 8,  1, 'ܷ'],
    [ 8,  2, '̤'],
    [ 8,  3, '̤³'],
    [ 8,  4, 'Ϣѷ'],
    [ 8,  5, 'Ϣѥ³'],
    [ 8,  6, ''],
    [ 8,  7, '̿'],
    [ 8,  8, ''],
    [ 9,  1, 'ܷ'],
    [ 9,  2, '̤'],
    [ 9,  3, '̤³'],
    [ 9,  4, 'Ϣѷ'],
    [ 9,  5, 'Ϣѥ³'],
    [ 9,  6, ''],
    [ 9,  7, '̿'],
    [ 9,  8, ''],
    [10,  1, 'ܷ'],
    [10,  2, '̤'],
    [10,  3, '̤³'],
    [10,  4, 'Ϣѷ'],
    [10,  5, ''],
    [10,  6, '̿'],
    [10,  7, ''],
    [11,  1, 'ܷ'],
    [11,  2, '̤'],
    [11,  3, '̤³'],
    [11,  4, 'Ϣѷ'],
    [11,  5, 'Ϣѥ³'],
    [11,  6, ''],
    [11,  7, '̿'],
    [11,  8, ''],
    [12,  1, 'ܷ'],
    [12,  2, '̤'],
    [12,  3, '̤³'],
    [12,  4, 'Ϣѷ'],
    [12,  5, ''],
    [12,  6, '̿'],
    [12,  7, ''],
    [13,  1, 'ܷ'],
    [13,  2, '̤'],
    [13,  3, '̤³'],
    [13,  4, 'Ϣѷ'],
    [13,  5, 'Ϣѥ³'],
    [13,  6, ''],
    [13,  7, '̿'],
    [13,  8, ''],
    [14,  1, 'ܷ'],
    [14,  2, '̤'],
    [14,  3, '̤³'],
    [14,  4, 'Ϣѷ'],
    [14,  5, 'Ϣѥ³'],
    [14,  6, ''],
    [14,  7, '̿'],
    [14,  8, ''],
    [15,  1, 'ܷ'],
    [15,  2, '̤'],
    [15,  3, '̤³'],
    [15,  4, 'Ϣѷ'],
    [15,  5, 'Ϣѥ³'],
    [15,  6, ''],
    [15,  7, '̿'],
    [15,  8, ''],
    [16,  1, 'ܷ'],
    [16,  2, '̤'],
    [16,  3, '̤³'],
    [16,  4, 'Ϣѷ'],
    [16,  5, 'Ϣѥ³'],
    [16,  6, ''],
    [16,  7, '̿'],
    [16,  8, ''],
    [17,  1, 'ܷ'],
    [17,  2, '̤'],
    [17,  3, '̤ü'],
    [17,  4, '̤³'],
    [17,  5, 'Ϣѷ'],
    [17,  6, 'Ϣѥ³'],
    [17,  7, ''],
    [17,  8, '̿'],
    [17,  9, ''],
    [17, 10, 'θ³ü'],
    [17, 11, 'θ³ü죲'],
    [18,  1, 'ܷ'],
    [18,  2, '̤'],
    [18,  3, '̤³'],
    [18,  4, 'Ϣѷ'],
    [18,  5, 'Ϣѥ³'],
    [18,  6, ''],
    [18,  7, '̿'],
    [18,  8, ''],
    [18,  9, 'θ³ü'],
    [19,  1, 'ܷ'],
    [19,  2, '̤'],
    [19,  3, '̤ü'],
    [19,  4, '̤³'],
    [19,  5, 'Ϣѷ'],
    [19,  6, 'Ϣѥ³'],
    [19,  7, ''],
    [19,  8, '̿'],
    [19,  9, '̿'],
    [19, 10, ''],
    [20,  1, 'ܷ'],
    [20,  2, '̤'],
    [20,  3, '̤³'],
    [20,  4, 'Ϣѷ'],
    [20,  5, 'Ϣѥ³'],
    [20,  6, ''],
    [20,  7, '̿'],
    [21,  1, 'ܷ'],
    [21,  2, '̤'],
    [21,  3, '̤³'],
    [21,  4, 'Ϣѷ'],
    [21,  5, 'Ϣѥ³'],
    [21,  6, ''],
    [21,  7, '̿'],
    [22,  1, 'ܷ'],
    [22,  2, '̤'],
    [22,  3, 'Ϣѷ'],
    [22,  4, ''],
    [22,  5, '̿'],
    [23,  1, 'ܷ'],
    [23,  2, '̤'],
    [23,  3, 'Ϣѷ'],
    [23,  4, ''],
    [23,  5, '̿'],
    [24,  1, 'ܷ'],
    [24,  2, '̤'],
    [24,  3, 'Ϣѷ'],
    [24,  4, ''],
    [24,  5, '̿'],
    [25,  1, 'ܷ'],
    [25,  2, '̤'],
    [25,  3, 'Ϣѷ'],
    [25,  4, ''],
    [25,  5, '̿'],
    [26,  1, 'ܷ'],
    [26,  2, '̤'],
    [26,  3, 'Ϣѷ'],
    [26,  4, ''],
    [26,  5, '̿'],
    [27,  1, 'ܷ'],
    [27,  2, '̤'],
    [27,  3, 'Ϣѷ'],
    [27,  4, ''],
    [27,  5, '̿'],
    [28,  1, 'ܷ'],
    [28,  2, '̤'],
    [28,  3, 'Ϣѷ'],
    [28,  4, ''],
    [28,  5, '̿'],
    [29,  1, 'ܷ'],
    [29,  2, '̤'],
    [29,  3, 'Ϣѷ'],
    [29,  4, ''],
    [29,  5, '̿'],
    [30,  1, 'ܷ'],
    [30,  2, '̤'],
    [30,  3, 'Ϣѷ'],
    [30,  4, 'θ³'],
    [30,  5, ''],
    [30,  6, '̿'],
    [31,  1, 'ܷ'],
    [31,  2, 'ܷ'],
    [31,  3, '̤'],
    [31,  4, 'Ϣѷ'],
    [31,  5, 'θ³'],
    [31,  6, 'θ³'],
    [31,  7, ''],
    [31,  8, ''],
    [31,  9, '̿'],
    [32,  1, 'ܷ'],
    [32,  2, '̤'],
    [32,  3, 'Ϣѷ'],
    [32,  4, 'θ³'],
    [32,  5, ''],
    [32,  6, '̿'],
    [33,  1, 'ܷ'],
    [33,  2, '̤'],
    [33,  3, 'Ϣѷ'],
    [33,  4, 'θ³'],
    [33,  5, ''],
    [33,  6, '̿'],
    [34,  1, 'ܷ'],
    [34,  2, '̤'],
    [34,  3, 'Ϣѷ'],
    [34,  4, 'θ³'],
    [34,  5, ''],
    [34,  6, '̿'],
    [35,  1, 'ܷ'],
    [35,  2, '̤'],
    [35,  3, 'Ϣѷ'],
    [35,  4, 'θ³'],
    [35,  5, ''],
    [35,  6, '̿'],
    [36,  1, 'ܷ'],
    [36,  2, '̤'],
    [36,  3, 'Ϣѷ'],
    [36,  4, 'θ³'],
    [36,  5, ''],
    [36,  6, '̿'],
    [37,  1, 'ܷ'],
    [37,  2, '̤'],
    [37,  3, 'Ϣѷ'],
    [37,  4, 'θ³'],
    [37,  5, ''],
    [37,  6, '̿'],
    [38,  1, 'ܷ'],
    [38,  2, '̤'],
    [38,  3, 'Ϣѷ'],
    [38,  4, 'θ³'],
    [38,  5, ''],
    [38,  6, '̿'],
    [39,  1, 'ܷ'],
    [39,  2, '̤'],
    [39,  3, 'Ϣѷ'],
    [39,  4, 'θ³'],
    [39,  5, ''],
    [39,  6, '̿'],
    [40,  1, 'ܷ'],
    [40,  2, '̤'],
    [40,  3, 'Ϣѷ'],
    [40,  4, 'θ³'],
    [40,  5, ''],
    [40,  6, '̿'],
    [41,  1, 'ܷ'],
    [41,  2, '̤'],
    [41,  3, 'Ϣѷ'],
    [41,  4, 'θ³'],
    [41,  5, ''],
    [41,  6, '̿'],
    [42,  1, 'ܷ'],
    [42,  2, '̤'],
    [42,  3, 'Ϣѷ'],
    [42,  4, 'θ³'],
    [42,  5, ''],
    [42,  6, '̿'],
    [43,  1, 'ܷ'],
    [43,  2, '̤'],
    [43,  3, 'Ϣѷ'],
    [43,  4, 'θ³'],
    [43,  5, ''],
    [43,  6, '̿'],
    [44,  1, 'ܷ'],
    [44,  2, '̤'],
    [44,  3, 'Ϣѷ'],
    [44,  4, 'θ³'],
    [44,  5, ''],
    [44,  6, '̿'],
    [45,  1, 'ܷ'],
    [45,  2, '̤'],
    [45,  3, 'Ϣѷ'],
    [45,  4, 'θ³'],
    [45,  5, ''],
    [45,  6, '̿'],
    [46,  1, 'ܷ'],
    [46,  2, '̤'],
    [46,  3, 'Ϣѷ'],
    [46,  4, 'θ³'],
    [46,  5, ''],
    [46,  6, '̿'],
    [47,  1, 'ܷ'],
    [47,  2, '̤'],
    [47,  3, '̤³'],
    [47,  4, 'Ϣѷ'],
    [47,  5, 'θ³'],
    [47,  6, ''],
    [47,  7, '̿'],
    [48,  1, 'ܷ'],
    [48,  2, '̤'],
    [48,  3, '̤ü'],
    [48,  4, '̤³'],
    [48,  5, 'Ϣѷ'],
    [48,  6, ''],
    [48,  7, '̿'],
    [48,  8, '̿'],
    [48,  9, '̿'],
    [48, 10, ''],
    [49,  1, 'ܷ'],
    [49,  2, ''],
    [49,  3, '̿'],
    [49,  4, ''],
    [50,  1, 'ܷ'],
    [50,  2, 'ʸܷ'],
    [50,  3, '̤³'],
    [50,  4, '̤³'],
    [50,  5, 'Ϣѥ³'],
    [50,  6, 'Ϣѥ³'],
    [50,  7, 'Ϣѥ³'],
    [50,  8, 'Ϣѥ³'],
    [50,  9, 'Ϣѥ³'],
    [50, 10, 'θ³'],
    [50, 11, ''],
    [50, 12, '̿'],
    [50, 13, ''],
    [50, 14, ''],
    [50, 15, '³'],
    [51,  1, 'ܷ'],
    [51,  2, 'ʸܷ'],
    [51,  3, '̤³'],
    [51,  4, '̤³'],
    [51,  5, 'Ϣѥ³'],
    [51,  6, 'Ϣѥ³'],
    [51,  7, 'Ϣѥ³'],
    [51,  8, 'Ϣѥ³'],
    [51,  9, 'Ϣѥ³'],
    [51, 10, 'θ³'],
    [51, 11, ''],
    [51, 12, '̿'],
    [51, 13, ''],
    [51, 14, ''],
    [51, 15, '³'],
    [52,  1, 'ܷ'],
    [52,  2, 'شܷ'],
    [52,  3, 'شܷ'],
    [52,  4, 'ʸܷ'],
    [52,  5, '̤³'],
    [52,  6, '̤³'],
    [52,  7, 'Ϣѥ³'],
    [52,  8, 'Ϣѥ³'],
    [52,  9, 'Ϣѥ³'],
    [52, 10, 'Ϣѥ³'],
    [52, 11, 'Ϣѥ³'],
    [52, 12, 'Ϣѥ³'],
    [52, 13, 'θ³'],
    [52, 14, ''],
    [52, 15, '̿'],
    [52, 16, ''],
    [52, 17, ''],
    [52, 18, '³'],
    [53,  1, 'ܷ'],
    [53,  2, 'شܷ'],
    [53,  3, 'شܷ'],
    [53,  4, 'ʸܷ'],
    [53,  5, '̤³'],
    [53,  6, '̤³'],
    [53,  7, 'Ϣѥ³'],
    [53,  8, 'Ϣѥ³'],
    [53,  9, 'Ϣѥ³'],
    [53, 10, 'Ϣѥ³'],
    [53, 11, 'Ϣѥ³'],
    [53, 12, 'θ³'],
    [53, 13, ''],
    [53, 14, ''],
    [53, 15, ''],
    [53, 16, '³'],
    [54,  1, 'ܷ'],
    [54,  2, '̤'],
    [54,  3, ''],
    [55,  1, 'ܷ'],
    [55,  2, '̤'],
    [55,  3, '̤'],
    [55,  4, 'Ϣѷ'],
    [55,  5, 'Ϣѥ³'],
    [55,  6, 'θ³'],
    [55,  7, ''],
    [55,  8, '̿'],
    [56,  1, 'ܷ'],
    [56,  2, '̤'],
    [56,  3, 'Ϣѷ'],
    [57,  1, 'ܷ'],
    [57,  2, '̤'],
    [57,  3, 'Ϣѷ'],
    [58,  1, 'ܷ'],
    [58,  2, '̤'],
    [58,  3, '̤³'],
    [58,  4, 'Ϣѷ'],
    [58,  5, ''],
    [58,  6, '̿'],
    [58,  7, '̿'],
    [59,  1, 'ܷ'],
    [59,  2, 'ʸܷ'],
    [59,  3, 'Ϣѷ'],
    [59,  4, 'Ϣѥ³'],
    [59,  5, 'θ³'],
    [59,  6, ''],
    [59,  7, ''],
    [59,  8, ''],
    [60,  1, 'ܷ'],
    [60,  2, '̤'],
    [60,  3, 'Ϣѷ'],
    [60,  4, 'θ³'],
    [60,  5, ''],
    [61,  1, 'ܷ'],
    [61,  2, 'Ϣѷ'],
    [61,  3, 'θ³'],
    [62,  1, 'ܷ'],
    [62,  2, '̤'],
    [62,  3, 'θ³'],
    [62,  4, ''],
    [62,  5, '̿'],
    [63,  1, 'ܷ'],
    [63,  2, 'Ϣѷ'],
    [63,  3, 'θ³'],
    [63,  4, ''],
    [64,  1, 'ܷ'],
    [64,  2, '̤'],
    [64,  3, 'Ϣѷ'],
    [64,  4, 'θ³'],
    [64,  5, ''],
    [64,  6, '̿'],
    [64,  7, '̿'],
    [65,  1, 'ܷ'],
    [65,  2, 'θ³'],
    [65,  3, '̿'],
    [66,  1, 'ܷ'],
    [66,  2, 'θ³'],
    [67,  1, 'ܷ'],
    [67,  2, 'θ³'],
    [68,  1, 'ܷ'],
    [68,  2, '̤'],
    [68,  3, 'Ϣѷ'],
    [68,  4, 'θ³'],
    [68,  5, ''],
    [68,  6, '̿'],
    [68,  7, '̿'],
    [69,  1, 'ܷ'],
    [70,  1, 'ܷ'],
    [70,  2, ''],
    [71,  1, 'ܷ'],
    [71,  2, '̤'],
    [71,  3, 'Ϣѷ'],
  ]

end # Gyokuro

#==============================================================================#
#==============================================================================#
