module REXML
	# Adds named attributes to an object.
	module Namespace
		# The name of the object, valid if set
		attr_reader :name, :expanded_name
		# The expanded name of the object, valid if name is set
		attr_accessor :prefix

		# Sets the name and the expanded name
		def name=( name )
			@expanded_name = name
			if name.include? ":"
				name =~ /(\w+):(\w+)/
				@prefix = $1
				@name = $2
			else
				@name = name
				@namespace = ""
				@prefix = ""
			end
		end

		# Compares names optionally WITH namespaces
		def has_name?( other )
			if other.include? ":"
				return fully_expanded_name == other
			else
				return name == other
			end
		end

		alias :local_name :name

		# Fully expand the name, even if the prefix wasn't specified in the
		# source file.
		def fully_expanded_name
			ns = prefix
			return "#{ns}:#@name" if ns.size > 0 
			return @name
		end
	end
end
