=begin

= Sablot class

Sablotron XSLT processor class.

== SuperClass

Object

== Class Methods

  --- Sablot.createProcessor()
  --- Sablot.new()

        creates a new processor.

  --- Sablot.processStrings(xsl_string, xml_string)
  --- Sablot.process_strings(xsl_string, xml_string)

        translates xml_string with xsl_string, and return
        translated document(as String object).

  --- Sablot.processFiles(xsl_file, xml_file, output_file)
  --- Sablot.process_files(xsl_file, xml_file, output_file)

        translates xml_file with xsl_file, and return
        output_file as file.

== Methods

  --- aSablot.runProcessor(sheet, input, result, params, args)

        runs the existing instance on the given documents.
        
        arguments:
        : sheet
            URI of the XSLT stylesheet
        : input
            URI of the XML document
        : result
            URI of the output document
        : params
            a Hash of strings defining the top-level parameters
        : args
            a Hash of strings defining the named buffer


  --- aSablot.resultArg(resultURI)

        gets the result string from the last Sablot run.
        the string buffer is identified by an URI (to enable output to
        multiple documents) 

  --- aSablot.setLog(filename, logLevel)

        sets the logging options. Logging is off by default.
        (but logLevel is ignored so far)

  --- aSablot.setBase(base)

        overrides the default base URI for relative reference 
        resolution.

  --- aSablot.setBaseForScheme(scheme, base)

        a softer form of setBase: the hard base URI will only
        be in effect for relative references whose bases have
        the given scheme.

        Example: assume we call 
         processor.setBaseForScheme("arg", "http://server" )
        and then runs a stylesheet at "arg:/xxx" which contains
        "document('foo.xml')".
        The relative reference is resolved as "http://server/foo.xml"
        but if the stylesheet were at "file:/xxx" it would become
        "file:/foo.xml". 

== Handler Methods

Since 0.5.0, this module supports Message Handler.

Message Handler is implemented using template methods.
If you define Sablot#messageLog or Sablot#messageError,
Sablot object call these methods by necessity.

=== Methods for Message Handler

 --- aSablot.messageLog

       handler method for logging.

 --- aSablot.messageError

       handler method for reporting error.

=== Constant for Message Handler

You can use constant for handler methods.

 --- Sablot::MH_DEBUG
 --- Sablot::MH_INFO
 --- Sablot::MH_WARN
 --- Sablot::MH_ERROR
 --- Sablot::MH_CRITICAL

      These constant is used as logging levels for message handler.

=end