" unhtml.vim - by aurelio
"   converts HTML tags into txt2tags marks
"   part of the txt2tags <http://txt2tags.sf.net> software
"
" INSTRUCTIONS
"   1. open the HTML file on Vim and execute
"        :so unhtml.vim
"
"   2. a new <yourfile>.html.t2t will be saved.
"
"   3. check the new .t2t file and correct by hand what has left.
"

""" [ preparing ]
" ignore case
set ic
" join multiline tags
g/<a\s*$/join
g/<a\s[^>]*>[^<]*$/join


""" [ do it! ]
" link
%s,<a\s\+href="\(.\{-}\)">\(.\{-}\)<\/a>,[\2 \1],ge
" anchor
%s,^<a\s\+name=.\{-}>\(.*\)<\/a>,== \1 ==,ge
" comments
%s,\s*<!--\(.*\)-->,% \1,ge
/<!--/,/-->/s,^,% ,e
" paragraph
%s,<p[^>]*>,
,ge
" bar
%s,<hr[^>]*>,-------------------------------------------------,ge
" title
%s,</\=h1>,=,ge
%s,</\=h2>,==,ge
%s,</\=h3>,===,ge
%s,</\=h4>,====,ge
%s,</\=h5>,=====,ge
%s,</\=h6>,=====,ge
" beutifiers
%s,</\=code>,`,ge
%s,</\=b>,**,ge
%s,</\=i>,//,ge
%s,</\=u>,__,ge
" pre
%s,</\=pre>,
---
,ge
" bullet/numbered list
%s,<li>,- ,ge
%s,</li>,,ge
%s,<[uo]l>,,ge
%s,</[uo]l>,

,ge
" definition list
%s,<dl>,,ge
%s,</dl>,

,ge
%s,<dt>,= ,ge
%s,</dt>,:,ge
%s,</\=dd>,,ge
" BR is ignored
%s,<br>,
,ge
" trash
%s,</font[^>]*>,,ge
%s,</p>,,ge
%s,</a>,,ge
" mmmmm, dangerous!
%s,<[^>]*>,,ge
" special
%s,&amp;,\&,ge
%s,&gt;,>,ge
%s,&lt;,<,ge
" clear empty lines
%s,^\s*$,,

" save new .t2t file and turn on syntax
saveas! %.t2t | set ft=txt2tags
