.TH "TXT2TAGS SAMPLE" 1 20021220 "aurlio, aurelio@verde666.org"

.P



.P
.P
  Introduction
  Fonts and Beautifiers
    Beautifiers
    Pre\-Formatted Text
    More Cosmetics
  Lists
    Plain List
    Numbered List
    Definition List
  Tables
  Special Entities
    Images
    Other

.P



.P
.P
.SH Introduction

Welcome to the txt2tags sample file.

Here you have examples and a brief explanation of all tags.

The first 3 lines of the this file are used as headers, on the following format:
.nf
  line1: document title
  line2: author name, email
  line3: date, version
.fi


Lines with balanced equal signs = around are titles.

.SH Fonts and Beautifiers

We have two sets of fonts:


.nf
* \fBthe normal type\fP:
  can be improved with beautifiers to bold, italic, underline or combinations between them.
.P
* \fBthe typewriter type\fP:
  uses monospaced font for preformatted text.
.fi

We will now enter on a subtitle...

.SS Beautifiers

The text tags for beautifiers are simple, just as you type on a plain text email message.

We use double *, / and _ to represent \fBbold\fP, \fIitalic\fP and underline.

The 
.BI bold italic
\& style is also supported.

.SS Pre-Formatted Text

We can put a code sample or other preformatted text:
.nf
    here    is     preformatted
  //tags// are  **not**  `interpreted`
.fi


And also, it's easy to put a one line preformatted text:
.nf
  prompt$ ls /etc
.fi


Or use preformatted inside sentences.

.SS More Cosmetics

Special entities like an email (duh@somewhere.com) or an URL (http://www.duh.com) are recognized automagically, as long as the horizontal line:




^ thin or large v




You can also specify an explicit link (http://duh.org#anchor) with label.

And remember,


A TAB in front of the line does a quotation.


More TABs increase the quote depth (if allowed).




Nice.

.SH Lists

A list of items is natural, just putting a \fBdash\fP or a \fBplus\fP at the begining of the line.

.SS Plain List

The dash is the default list identifier. For sublists, just add \fBspaces\fP at the beginning of the line. More spaces, more sublists.


.nf
* earth
  * america
    * south america
      * brazil
        * how deep can i go?
  * europe
    * lots of countries
* mars
  * who knows?
.fi

The list ends with \fBtwo\fP consecutive blank lines.

.SS Numbered List

The same rules as the plain list, just a different identifier (plus).


.nf
1. one
2. two
3. three
  * mixed lists!
  * what a mess
    1. counting again
    2. ...
4. four
.fi

.SS Definition List

The list identifier is an equal sign, and the colon separate the definition
term to the definition definition.


.nf
* \fBorange\fP: a yellow fruit
* \fBapple\fP: a green or red fruit
* \fBother fruits\fP:
  * wee!
  * mixing lists
    1. again!
    2. and again!
.fi

.SH Tables

Tables are supported for the HTML, Sgml and Moin targets.
On the others they're treated as preformatted text.

Just use pipes to compose table rows and cells.
Double pipe at the line begining identify a table title row.

.nf
|| title   | other title | another  |
| cell 1.1 | cell 1.2    | cell 1.3 |
| cell 2.1 | cell 2.2    | cell 2.3 |
.fi


Without the last pipe, no border:

.nf
|| title   | other title | another
| cell 1.1 | cell 1.2    | cell 1.3
| cell 2.1 | cell 2.2    | cell 2.3
.fi


.SH Special Entities

Because things were too simple.

.SS Images

The image tag is as simple as it can be: [filename].
photo.jpg

.nf
* filename must end in PNG, JPG, GIF, or similar.
* no spaces on the brackets! (on the filename ok)
.fi

.SS Other

And as a gift, a special %%date handy tag that tell us the current date.

So today is 20021220 on the ISO yyyymmdd format.

You can also specify the date format with the %? flags,
as %%date(%m\-%d\-%Y) wich gives: 12\-20\-2002.

That's all.
pwrbytxt2tags\-2.png

.\" man code generated by txt2tags 1.3 (http://txt2tags.sf.net)
.\" cmdline: txt2tags --toc -t man sample.t2t

