/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.parsers;

import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.xml.sax.SAXException;

public abstract class SAXParserFactory {
    private boolean namespaces = false;
    private boolean validation = false;
    private static String property = "javax.xml.parsers.SAXParserFactory";
    private static String factory = "org.apache.xerces.jaxp.SAXParserFactoryImpl";

    protected SAXParserFactory() {
    }

    public boolean isNamespaceAware() {
        return this.namespaces;
    }

    public boolean isValidating() {
        return this.validation;
    }

    public static SAXParserFactory newInstance() {
        String string = factory;
        try {
            string = System.getProperty(property, factory);
        }
        catch (SecurityException securityException) {
            string = factory;
        }
        try {
            return (SAXParserFactory)Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new FactoryConfigurationError("Cannot load class SAXParserFactory class \"" + string + "\"");
        }
        catch (InstantiationException instantiationException) {
            throw new FactoryConfigurationError("Cannot instantiate the specified SAXParserFactory class \"" + string + "\"");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new FactoryConfigurationError("Cannot access the specified SAXParserFactory class \"" + string + "\"");
        }
        catch (ClassCastException classCastException) {
            throw new FactoryConfigurationError("The specified class \"" + string + "\" is not instance of \"javax.xml.parsers.SAXParserFactory\"");
        }
    }

    public abstract SAXParser newSAXParser() throws ParserConfigurationException, SAXException;

    public void setNamespaceAware(boolean bl) {
        this.namespaces = bl;
    }

    public void setValidating(boolean bl) {
        this.validation = bl;
    }
}

