#==========================================================
# Mainlib --
#
#    main procedures that build the main GUI
#
#==========================================================
#
namespace eval Mainlib {

    variable _base64
    variable Win
    variable boolean
	variable img

    array set boolean {t yes f no true yes false no T yes F no}
    
    set _base64(si_grid) {
    R0lGODlhDwAOAPcAAAAAAAAA/4QAAISEhKX/KcbGxv//////////////////////////////
    ////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////
    /////////////////////////////////yH5BAEAAAQALAAAAAAPAA4AAAhbAAkIHDgQAACC
    CAUaHDDgYEICCxk2TBiRoYECBhxCBBAggMUCAgRkVNjxowGRJ0cCMIlRQMuREA1clNlSJMaD
    K2nOnHlToU6eGTXmBGqQos6iD3MifahQY8KAAAA7
    }
    set _base64(si_drive4) {
    R0lGODlhDwAOAPcAAAAAAISEhMbGxv8pzv//AP//////////////////////////////////
    ////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////
    /////////////////////////////////yH5BAEAAAMALAAAAAAPAA4AAAhhAAcIHACgoEEA
    AwcWFECAIYGHBRU2nOjQIUIAFCc+3EhgYUaNGw0yHMkRYsGOGEuiXBnSZEqUKQXILCAz5MmT
    AgrQbHjzZUeXIQk+lJmzJkSFGHPuFBAx4YAAAAJAbSowIAA7
    }
    set _base64(si_drive3) {
    R0lGODlhEAAJAPcAAAAAAAAInACEAADOAHNzc5SUlJycnLW1tcbGxtbW1t7e3v//////////
    ////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////
    /////////////////////////////////yH5BAEAAAEALAAAAAAQAAkAAAhKAAMEIECwoMGC
    AgkcWMiw4UICAAgsmEix4kQDEAkkQMCxI4IDAwQcKJBRwQGPHxuSjKjg4MGRGRNYtAgzosub
    AAQC2MmzJ0+BAQEAOw==
    }
    
    set _base64(si_sql) {R0lGODlhEAAWAPcAAAAAAAgICBgYGDEhMTExMTk5OUJCQkoY/0pKSlJSUlpa
    WmNjY2tra3Nzc3t7e4SEhIyMjIyU3pSUlJycnKWlpa2trbW1tb29vcbGxs7O
    zt7e3ufn5+/v7/f39///////////////////////////////////////////
    ////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////
    /////////////////////yH5BAEAAAcALAAAAAAQABYAAAiMAA8IHEiwoMGD
    CAEoXAjgoEIMESBGmKiQIICIGCVKbHjgIsSPE0NS7AhSo8gIDR9mPIkyZUuW
    L12GvNiSJsqONDHo9KBzpkuFET3wjAhUJkWKQEd2nKgTA0+JNwcCdToUQ0WD
    DwA8yHoVodeBVq+KLTjAosCUBsd2XOtwLQAMbKU+FBgAg4ADAvLeDQgAOw==}
    
    
    set _base64(online:rx) {R0lGODlhEAAPAPcAAAAAAAD//yEA1oSEhMbGxv8ICP//////////////////
    ////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////
    /////////////////////yH5BAEAAAIALAAAAAAQAA8AAAhlAAUIHChggMGD
    AwgSHACgoUMCABQKZBjAwMOIExEatNgQ4kSHFy9+NBCgZACIIgsCIGkS4kGP
    Kk2WhEigJkyKMlGC/KiRpkECDAvaHApAY0SGIJM6LGhg6M+gCzUixEhQ6VKF
    AQEAOw==}

	set img(Tables) [image create photo -data $::Mainlib::_base64(si_grid)]
	set img(Queries) ::icon::misc-16
	set img(Views) ::icon::thumbnail-16
	set img(Sequences) ::icon::queue-16
	set img(Functions) ::icon::completion-16
	set img(Reports) ::icon::txt-16
	set img(Graphs) ::icon::editcut-16
	set img(Forms) ::icon::widget_doc-16
	set img(Scripts) ::icon::shellscript-16
	set img(Users) ::icon::people-16
	set img(Diagrams) ::icon::desktop_flat-16

}; # end namespace Mainlib

#----------------------------------------------------------
# ::Mainlib::tab_click --
#
#    This is used to invoke a tab. This was changed for the
#    the interface to instead select a node in the tree
#
# Arguments:
#    tabname_    The name of the tab
#
# Results:
#    none returned
#----------------------------------------------------------
#
proc ::Mainlib::tab_click {tabname_} {

    global PgAcVar CurrentDB
    variable Win

    set deslist [list Tables Diagrams Scripts Queries Functions]
    lappend deslist Views Reports Graphs Forms Users

    #set w .pgaw:Main.tab$tabname
    if {$CurrentDB==""} return;
    set curtab $tabname_
    #if {$PgAcVar(activetab)==$curtab} return;
    set PgAcVar(activetab) $curtab

    # Tabs where button Design is enabled
    if {[lsearch $deslist $PgAcVar(activetab)]!=-1} {
        if {[string match "" $PgAcVar(currentdb,host)]} {
            #set PgAcVar(currentdb,host) sockets
            set PgAcVar(currentdb,host) ""
        }

        set node ${PgAcVar(currentdb,host)}-${PgAcVar(currentdb,dbname)}-${curtab}
        if {[$Win(tree) exists $node]} {
            $Win(tree) selection set $node
                  #.pgaw:Main.btndesign configure -state normal
            set PgAcVar(activetab) $tabname_
        }
    }
           	#.pgaw:Main.lb delete 0 end
	          #cmd_$curtab

    return
}; # end proc ::Mainlib::tab_click


#----------------------------------------------------------
# ::Mainlib::cmd_Delete --
#
#    Handles the Delete button when clicked
#
# Arguments:
#    none
#
# Results:
#    none returned
#----------------------------------------------------------
#
proc ::Mainlib::cmd_Delete {} {
    global PgAcVar CurrentDB

    if {$CurrentDB==""} return;
    set objtodelete [get_dwlb_Selection]
    if {$objtodelete==""} return;

    if {[lsearch {Tables Diagrams Views Queries Scripts Forms Sequences Functions Reports Graphs Users} $PgAcVar(activetab)] == -1} {
        return
    }

    set delmsg [format [intlmsg "You are going to delete\n\n %s \n\nProceed?"] $objtodelete]

    if {[tk_messageBox \
             -title [intlmsg "FINAL WARNING"] \
             -parent . \
             -message $delmsg \
             -type yesno \
             -default no]=="no"} { return }

    switch $PgAcVar(activetab) {
	Tables {
		sql_exec noquiet "drop table \"$objtodelete\""
		sql_exec quiet "delete from pga_layout where tablename='$objtodelete'"
		cmd_Tables
	}
	Diagrams {
		sql_exec quiet "delete from pga_diagrams where diagramname='$objtodelete'"
		cmd_Diagrams
	}
	Views {
		sql_exec noquiet "drop view \"$objtodelete\""
		sql_exec quiet "delete from pga_layout where tablename='$objtodelete'"
		cmd_Views
	}
	Queries {
		sql_exec quiet "delete from pga_queries where queryname='$objtodelete'"
		sql_exec quiet "delete from pga_layout where tablename='$objtodelete'"
		cmd_Queries
	}
	Scripts {
		sql_exec quiet "delete from pga_scripts where scriptname='$objtodelete'"
		cmd_Scripts
	}
	Forms {
		sql_exec quiet "delete from pga_forms where formname='$objtodelete'"
		cmd_Forms
	}
	Sequences {
		sql_exec quiet "drop sequence \"$objtodelete\""
		cmd_Sequences
	}
	Functions {
		delete_function $objtodelete
		cmd_Functions
	}
	Reports {
		sql_exec noquiet "delete from pga_reports where reportname='$objtodelete'"
		cmd_Reports
	}
	Graphs {
		sql_exec noquiet "delete from pga_graphs where graphname='$objtodelete'"
		cmd_Graphs
	}
	Users {
		sql_exec noquiet "drop user \"$objtodelete\""
		cmd_Users
	}
}
}

#------------------------------------------------------------
# ::Mainlib::cmd_Design --
#
#    Handles the Design tab when click
#
# Arguments:
#    none
#
# Results:
#    none returned
#------------------------------------------------------------
#
proc ::Mainlib::cmd_Design {} {
    global PgAcVar CurrentDB
    variable Win

    #if {$CurrentDB==""} return;
    #if {[$Win(mclist) curselection]==""} return;
    set objname [get_dwlb_Selection]
    #set objname [$Win(mclist) get [$Win(mclist) curselection]]
    set tablename $objname

    if {$objname == ""} {return}

switch $PgAcVar(activetab) {
	Tables  {
		Tables::design $objname
	}
	Diagrams  {
		Diagrams::open $objname
	}
	Queries {
		Queries::design $objname
	}
	Views {
		Views::design $objname
	}
	Scripts {
		Scripts::design $objname
	}
	Forms {
		Forms::design $objname
	}
	Functions {
		Functions::design $objname
	}
	Reports {
		Reports::design $objname
	}
	Graphs {
		Graphs::design $objname
	}
	Users {
		Users::design $objname
	}
}
}

#----------------------------------------------------------
# ::Mainlib::cmd_Forms --
#
#     Handles when the Forms section is selected
#
# Arguments:
#  none
#
# Results:
#  none returned
#----------------------------------------------------------
#
proc ::Mainlib::cmd_Forms {} {

    global CurrentDB
    variable Win

    set sql "
        SELECT formname
          FROM Pga_forms
      ORDER BY formname"

    setCursor CLOCK

    $Win(mclist) delete 0 end

    $Win(mclist) configure \
        -columns [list 0 [intlmsg Name] left]

    catch {
	wpg_select $CurrentDB "$sql" rec {
		$Win(mclist) insert end [list $rec(formname)]
	}
    }

    setCursor DEFAULT
    
    return
}


#----------------------------------------------------------
# ::Mainlib::cmd_Functions --
#
#     Handles when the Functions section is selected
#
# Arguments:
#  none
#
# Results:
#  none returned
#----------------------------------------------------------
#
proc ::Mainlib::cmd_Functions {} {

    global PgAcVar CurrentDB
    variable Win

	set maxim 16384
	setCursor CLOCK
	set dbname $PgAcVar(opendb,dbname)

    set sql "
        SELECT datlastsysoid 
          FROM [::Database::qualifySysTable Pg_database]
         WHERE datname='$dbname'"

    set sql2 "
        SELECT oid 
          FROM [::Database::qualifySysTable Pg_database]
         WHERE datname='template1'"

    set sql3 "
        SELECT (proname || '(' || oidvectortypes(proargtypes) || ')') AS proname, u.usename, l.lanname
         FROM [::Database::qualifySysTable Pg_proc] P 
		   LEFT JOIN [::Database::qualifySysTable Pg_user] u 
		     ON p.proowner = u.usesysid, [::Database::qualifySysTable Pg_language] L
        WHERE P.oid>$maxim 
          AND P.prolang = L.oid
     ORDER BY proname"

    if [catch {wpg_select $CurrentDB "$sql" rec {
        set maxim $rec(datlastsysoid)
    }
    }] {
	catch {
		wpg_select $CurrentDB "$sql2" rec {
			set maxim $rec(oid)
		}
	}
    }

    set cols [list 0 [intlmsg Name] left 0 [intlmsg Owner] left]
    lappend cols 0 [intlmsg Language] left

    $Win(mclist) configure \
        -columns $cols
 
    $Win(mclist) delete 0 end

	catch {
		wpg_select $CurrentDB "$sql3" rec {
			$Win(mclist) insert end [list $rec(proname) $rec(usename) $rec(lanname)]
		}	
	}
	setCursor DEFAULT

    return

}; # end proc ::Mainlib::cmd_Functions



#	set PgAcVar(currentdb,host) $PgAcVar(opendb,host)
#	set PgAcVar(currentdb,pgport) $PgAcVar(opendb,pgport)
#	set PgAcVar(currentdb,dbname) $PgAcVar(opendb,dbname)
#	set PgAcVar(currentdb,username) $PgAcVar(opendb,username)
#	set PgAcVar(currentdb,password) $PgAcVar(opendb,password)
#	set PgAcVar(statusline,dbname) $PgAcVar(currentdb,dbname)


#----------------------------------------------------------
# ::Mainlib::cmd_Dump --
#
#     Handles the db dump function
#
# Arguments:
#  none
#
# Results:
#  none returned
#----------------------------------------------------------
#
proc ::Mainlib::cmd_Dump {type} {

    global PgAcVar CurrentDB
	set host $PgAcVar(currentdb,host)
	if {$host == ""} {
		showError [intlmsg {No database selected}]
		return
	}
	set dbname $PgAcVar(currentdb,dbname)
	if {$dbname == ""} {
		showError [intlmsg {No database selected}]
		return
	}
	set pgport $PgAcVar(currentdb,pgport)
	set username $PgAcVar(currentdb,username)
	set password $PgAcVar(currentdb,password)

	if {$host == "sockets"} {
		set host "localhost"
	}

	switch $type {
		"text" {
			set defaultextension ".sql"
			set initialdir "~"
			set initialfile "dump.sql"
			set title [intlmsg {Dump database (text)}]
		}
		"binary" {
			set defaultextension ".bsql"
			set initialdir "~"
			set initialfile "dump.bsql"
			set title [intlmsg {Dump database (binary)}]
		}
	}

	set FileName [tk_getSaveFile \
		-defaultextension $defaultextension \
		-initialdir $initialdir \
		-initialfile $initialfile \
		-title  $title \
		-parent ".pgaw:Main" \
	]
	if {$FileName != ""} {
		switch $type {
			"text" {
				exec /usr/local/bin/pg_dump -h $host -p $pgport -U $username -f $FileName -i $dbname
			}
			"binary" {
				exec /usr/local/bin/pg_dump -h $host -p $pgport -U $username -f $FileName -i -b -Fc $dbname
			}
		}
	}
    return
}; # end proc ::Mainlib::cmd_Dump

proc ::Mainlib::cmd_New {} {
global PgAcVar CurrentDB
if {$CurrentDB==""} return;

switch $PgAcVar(activetab) {
	Tables {
		Tables::new
	}
	Diagrams {
		Diagrams::new
	}
	Queries {
		Queries::new
	}
	Users {
		Users::new
	}
	Views {
		Views::new
	}
	Sequences {
		Sequences::new
	}
	Reports {
		Reports::new
	}
	Graphs {
		Graphs::new
	}
	Forms {
		Forms::new
	}
	Scripts {
		Scripts::new
	}
	Functions {
		Functions::new
	}
}
}


proc ::Mainlib::cmd_Open {} {
global PgAcVar CurrentDB

    variable Win

	if {$CurrentDB==""} return;

	set objname [get_dwlb_Selection]
	if {$objname==""} return;
	switch $PgAcVar(activetab) {
		Tables		{ Tables::open $objname }
		Diagrams	{ Diagrams::open $objname }
		Forms		{ Forms::open $objname }
		Scripts		{ Scripts::open $objname }
		Queries		{ Queries::open $objname }
		Views		{ Views::open $objname }
		Sequences	{ Sequences::open $objname }
		Functions	{ Functions::design $objname }
		Reports		{ Reports::open $objname }
		Graphs		{ Graphs::open $objname }
	}
}



#----------------------------------------------------------
# ::Mainlib::cmd_Queries --
#
#     Handles when the Queries section is selected
#
# Arguments:
#  none
#
# Results:
#  none returned
#----------------------------------------------------------
#
proc ::Mainlib::cmd_Queries {} {

    global CurrentDB
    variable Win

    set sql "
      SELECT queryname, querytype, querytables, querycomments
        FROM pga_queries
        ORDER BY queryname"

    set cols [list 0 [intlmsg Name] left 0 [intlmsg Type] left]
    lappend cols 0 [intlmsg Tables] left 0 [intlmsg Comments] left

    $Win(mclist) configure \
        -columns $cols

    $Win(mclist) delete 0 end

    wpg_select $CurrentDB "$sql" r {
        $Win(mclist) insert end \
        [list $r(queryname) $r(querytype) $r(querytables) $r(querycomments)]
    }

    return
}; # end proc ::Mainlib::cmd_Queries


#----------------------------------------------------------
# ::Mainlib::cmd_Rename --
#
#     Handles when the Rename section is selected
#
# Arguments:
#  none
#
# Results:
#  none returned
#----------------------------------------------------------
#
proc ::Mainlib::cmd_Rename {} {

    global PgAcVar CurrentDB

	if {$CurrentDB==""} return;

	if {[lsearch {Tables Queries Reports Graphs Forms Scripts Diagrams} $PgAcVar(activetab)]==-1} {
            return
        }

	set temp [get_dwlb_Selection]
	if {$temp==""} {
		tk_messageBox \
                    -title [intlmsg Warning] \
                    -parent . \
                    -message [intlmsg "Please select an object first!"]
		return;
	}
	set PgAcVar(Old_Object_Name) $temp
	Window show .pgaw:RenameObject
	wm transient .pgaw:RenameObject

    return

}; # end proc ::Mainlib::cmd_Rename


# allows for copying certain items
proc ::Mainlib::cmd_Copy {} {
global PgAcVar CurrentDB
	if {$CurrentDB==""} return;
	if {[lsearch {Queries Reports Graphs Forms Scripts Diagrams} $PgAcVar(activetab)]==-1} {
		showError [intlmsg "You can't copy $PgAcVar(activetab) yet."]
		return;
	}
	set temp [get_dwlb_Selection]
	if {$temp==""} {
		showError [intlmsg "Please select an object first!"]
		return;
	}
	set PgAcVar(Old_Object_Name) $temp
	Window show .pgaw:CopyObject
	wm transient .pgaw:CopyObject .pgaw:Main
}


#----------------------------------------------------------
# ::Mainlib::cmd_Reports --
#
#     Handles when the Reports section is selected
#
# Arguments:
#  none
#
# Results:
#  none returned
#----------------------------------------------------------
#
proc ::Mainlib::cmd_Reports {} {

    global CurrentDB
    variable Win

    set sql "
        SELECT reportname,reportsource
          FROM Pga_reports
      ORDER BY reportname"

    setCursor CLOCK

    set cols [list 0 [intlmsg Name] left 0 [intlmsg Source] left]

    $Win(mclist) configure \
        -columns $cols

    $Win(mclist) delete 0 end

    catch {
	wpg_select $CurrentDB "$sql" rec {
	    $Win(mclist) insert end [list $rec(reportname) $rec(reportsource)]
	}
    }

    setCursor DEFAULT

    return

}; # end proc ::Mainlib::cmd_Reports


#----------------------------------------------------------
# ::Mainlib::cmd_Graphs --
#
#     Handles when the Graphs section is selected
#
# Arguments:
#  none
#
# Results:
#  none returned
#----------------------------------------------------------
#
proc ::Mainlib::cmd_Graphs {} {

    global CurrentDB
    variable Win

    set sql "
        SELECT graphname,graphsource
          FROM Pga_graphs
      ORDER BY graphname"

    setCursor CLOCK

    set cols [list 0 [intlmsg Name] left 0 [intlmsg Source] left]

    $Win(mclist) configure \
        -columns $cols

    $Win(mclist) delete 0 end

    catch {
	wpg_select $CurrentDB "$sql" rec {
	    $Win(mclist) insert end [list $rec(graphname) $rec(graphsource)]
	}
    }

    setCursor DEFAULT

    return

}; # end proc ::Mainlib::cmd_Graphs


#----------------------------------------------------------
# ::Mainlib::cmd_Users --
#
#     Handles when the Users section is selected
#
# Arguments:
#  none
#
# Results:
#  none returned
#----------------------------------------------------------
#
proc ::Mainlib::cmd_Users {} {

    global CurrentDB
    variable Win
    variable boolean

    set cols [list 0 [intlmsg Name] left 0 [intlmsg Id] left]
    set cols 0 [intlmsg "Create DB?"] left 0 [intlmsg Super?] left

    set sql "
        SELECT * 
          FROM [::Database::qualifySysTable Pg_user]
      ORDER BY usename"

    setCursor CLOCK

    $Win(mclist) configure \
        -columns $cols

    $Win(mclist) delete 0 end

    catch {
	wpg_select $CurrentDB "$sql" r {
		$Win(mclist) insert end [list $r(usename) $r(usesysid) $boolean($r(usecreatedb)) $boolean($r(usesuper))]
	}
    }

    setCursor DEFAULT

    return

}; # end proc ::Mainlib::cmd_Users


#----------------------------------------------------------
# ::Mainlib::cmd_Scripts --
#
#     Handles when the Scripts section is selected
#
# Arguments:
#  none
#
# Results:
#  none returned
#----------------------------------------------------------
#
proc ::Mainlib::cmd_Scripts {} {

    global CurrentDB
    variable Win

    set sql "
        SELECT scriptname 
          FROM Pga_scripts 
      ORDER BY scriptname"

    setCursor CLOCK

    $Win(mclist) delete 0 end

    $Win(mclist) configure \
        -columns [list 0 [intlmsg Name] left]


    catch {
	wpg_select $CurrentDB "$sql" rec {
            $Win(mclist) insert end [list $rec(scriptname)]
	}
    }

    setCursor DEFAULT

    return

}; # end proc ::Mainlib::cmd_Scripts


#----------------------------------------------------------
# ::Mainlib::cmd_Sequences --
#
#     Handles when the Sequences section is selected
#
# Arguments:
#  none
#
# Results:
#  none returned
#----------------------------------------------------------
#
proc ::Mainlib::cmd_Sequences {} {

    global CurrentDB
    variable Win

    set sql "
        SELECT c.relname, u.usename, c.relfilenode
          FROM [::Database::qualifySysTable Pg_class] C LEFT JOIN pg_user u ON c.relowner = u.usesysid
         WHERE (relname NOT LIKE 'pg_%') 
           AND (relkind ='S') 
      ORDER BY relname"

    setCursor CLOCK

    set cols [list 0 [intlmsg Name] left 0 [intlmsg Owner] left 0 [intlmsg OID] left]

    $Win(mclist) configure \
        -columns $cols

	$Win(mclist) columnconfigure 2 -sortmode integer

    $Win(mclist) delete 0 end

    wpg_select $CurrentDB "$sql" r {

        $Win(mclist) insert end \
        [list $r(relname) $r(usename) $r(relfilenode)]
    }

    setCursor DEFAULT

    return
}; # end proc ::Mainlib::cmd_Sequences

#----------------------------------------------------------
# ::Mainlib::cmd_Tables --
#
#     Handles when the Tables section is selected
#
# Arguments:
#  none
#
# Results:
#  none returned
#----------------------------------------------------------
#
proc ::Mainlib::cmd_Tables {} {

    global CurrentDB PgAcVar
    variable Win
    variable boolean

    set cols [list 0 [intlmsg Name] left 0 [intlmsg Owner] left 0 [intlmsg OID] left]
    lappend cols 0 [intlmsg Tuples] left 0 [intlmsg Attributes] left

	
	#set VER [::Database::getPgVersion $CurrentDB]
    set id [::Connections::getIdFromHandle $CurrentDB]
    set VER $::Connections::Conn(pgversion,$id)

    if {[string match "" $VER]} {return}

    if {![info exists ::Connections::Conn(viewsystem,$id)]} {
        set ::Connections::Conn(viewsystem,$id) $PgAcVar(pref,systemtables)
    }

    if {![info exists ::Connections::Conn(viewpgaccess,$id)]} {
        set ::Connections::Conn(viewpgaccess,$id) $PgAcVar(pref,pgaccesstables)
    }

    if {$VER < 7.3} {
    
	    set sql "
          SELECT c.relname, u.usename, c.relfilenode, c.reltuples, c.relnatts
            FROM Pg_class c 
	         LEFT JOIN Pg_user u ON c.relowner = u.usesysid
           WHERE c.relkind = 'r'"


        set cols [list]
	set int [list 2 3 4]
        set order_by "ORDER BY 1"

        if {! $::Connections::Conn(viewsystem,$id)} {
           append sql " AND c.relname !~ '^pg_'"
        }

        if {! $::Connections::Conn(viewpgaccess,$id)} {
           append sql " AND c.relname !~ '^pga_'"
        }

    } else {

        set sql "
	      SELECT n.nspname, c.relname, u.usename, c.relfilenode, c.reltuples, c.relnatts
                FROM Pg_catalog.Pg_class c 
	             LEFT JOIN Pg_catalog.Pg_user u ON c.relowner = u.usesysid
	             LEFT JOIN Pg_catalog.Pg_namespace n ON n.oid = c.relnamespace
               WHERE c.relkind = 'r'"

        set cols [list 0 [intlmsg Schema] left]
	set int [list 3 4 5]
	set order_by "ORDER BY 1,2"

        if {! $::Connections::Conn(viewsystem,$id)} {
           append sql " AND n.nspname !~ '^pg_'"
        }

        if {! $::Connections::Conn(viewpgaccess,$id)} {
           append sql " AND c.relname !~ '^pga_'"
        }
    }

    append sql "  $order_by"

    lappend cols 0 [intlmsg Name] left 0 [intlmsg Owner] left 0 [intlmsg OID] left
    lappend cols 0 [intlmsg Tuples] left 0 [intlmsg Attributes] left

    $Win(mclist) configure \
        -columns $cols

    foreach C $int {
	    $Win(mclist) columnconfigure $C -sortmode integer
	}

    $Win(mclist) delete 0 end

    setCursor CLOCK
    wpg_select $CurrentDB "$sql" r {
		if {$VER >= 7.3} {
		    set L [list $r(nspname) $r(relname) $r(usename) $r(relfilenode) $r(reltuples) $r(relnatts)]
		} else {
		    set L [list $r(relname) $r(usename) $r(relfilenode) $r(reltuples) $r(relnatts)]
		}
        $Win(mclist) insert end $L
	     
    }

    setCursor DEFAULT

    return

}; # end proc ::Mainlib::cmd_Tables

#----------------------------------------------------------
# ::Mainlib::cmd_Diagrams --
#
#     Handles when the Diagrams section is selected
#
# Arguments:
#  none
#
# Results:
#  none returned
#----------------------------------------------------------
#
proc ::Mainlib::cmd_Diagrams {} {
    global CurrentDB
    variable Win

    set sql "
        SELECT diagramname 
          FROM Pga_diagrams 
      ORDER BY diagramname"

    $Win(mclist) configure \
        -columns [list 0 [intlmsg Name] left]

    $Win(mclist) delete 0 end

    setCursor CLOCK
    catch {
	wpg_select $CurrentDB "$sql" rec {
		$Win(mclist) insert end [list $rec(diagramname)]
	}
    }
    setCursor DEFAULT

    return

}; # end proc ::Mainlib::cmd_Diagrams

#----------------------------------------------------------
# ::Mainlib::cmd_Views --
#
#     Handles when the Views section is selected
#
# Arguments:
#  none
#
# Results:
#  none returned
#----------------------------------------------------------
#
proc ::Mainlib::cmd_Views {} {

    global CurrentDB
    variable Win

    set sql "
        SELECT c.relname, u.usename, c.relfilenode, c.relnatts
          FROM [::Database::qualifySysTable Pg_class] C LEFT JOIN [::Database::qualifySysTable Pg_user] u ON c.relowner = u.usesysid , [::Database::qualifySysTable Pg_rewrite] R
         WHERE (relname !~ '^pg_') 
           AND (r.ev_class = C.oid) 
           AND (r.ev_type = '1')"

    setCursor CLOCK

    set cols [list 0 [intlmsg Name] left 0 [intlmsg Owner] left]
    lappend cols 0 [intlmsg OID] left 0 [intlmsg Attributes] left

    $Win(mclist) configure \
        -columns $cols

    foreach C {2 3} {
	    $Win(mclist) columnconfigure $C -sortmode integer
	}

    $Win(mclist) delete 0 end

    wpg_select $CurrentDB "$sql" r {

        $Win(mclist) insert end \
        [list $r(relname) $r(usename) $r(relfilenode) $r(relnatts)]
    }

    setCursor DEFAULT

    return

}; # end proc ::Mainlib::cmd_Views

proc ::Mainlib::delete_function {objname} {
	sql_exec noquiet "drop function $objname"
}


#------------------------------------------------------------
# ::Mainlib::get_dwlb_Selection --
#
#    This just returns the selection in the mclistbox.
#    If There is a "Schema" column, then we return
#    "Schema.Table" if "Tables" is selected.
#
# Arguments:
#    none
#
# Results:
#    returns the first item in the mclistbox that is
#    selected.
#------------------------------------------------------------
#
proc ::Mainlib::get_dwlb_Selection {} {

    global PgAcVar
    variable Win

	set temp [$Win(tree) selection get]
	if {$temp==""} return "";
    set PgAcVar(activetab) [lindex [split $temp -] 2]

    set temp [$Win(mclist) curselection]

    if {$temp == ""} {return ""}

    if {[string match "Tables" $PgAcVar(activetab)]} {

	    set first [lindex [$Win(mclist) cget -columns] 1]

		if {[string match "Schema" $first]} {
            return [join [lrange [$Win(mclist) get $temp] 0 1] .]
		}
	}

    return [lindex [$Win(mclist) get $temp] 0]


}; # end proc ::Mainlib::get_dwlb_Selection




proc ::Mainlib::sqlw_display {msg} {
	if {![winfo exists .pgaw:SQLWindow]} {return}
	.pgaw:SQLWindow.f.t insert end "$msg\n\n"
	.pgaw:SQLWindow.f.t see end
	set nrlines [lindex [split [.pgaw:SQLWindow.f.t index end] .] 0]
	if {$nrlines>50} {
		.pgaw:SQLWindow.f.t delete 1.0 3.0
	}
}


#----------------------------------------------------------
# ::Mainlib::open_database --
#
#    Opens current database
#
# Arguments:
#    none
#
# Results:
#    none returned
#----------------------------------------------------------
#
proc ::Mainlib::open_database {} {

    global PgAcVar CurrentDB
    variable Win

    setCursor CLOCK

    set pga_tabs(pga_queries) [list]
    append pga_tabs(pga_queries) "queryname VARCHAR(64) PRIMARY KEY,"
    append pga_tabs(pga_queries) "querytype CHAR(1),"
    append pga_tabs(pga_queries) "querycommand TEXT,"
    append pga_tabs(pga_queries) "querytables TEXT,"
    append pga_tabs(pga_queries) "querylinks TEXT,"
    append pga_tabs(pga_queries) "queryresults TEXT,"
    append pga_tabs(pga_queries) "querycomments TEXT"

    set pga_tabs(pga_forms) [list]
    append pga_tabs(pga_forms) "formname VARCHAR(64) PRIMARY KEY,"
    append pga_tabs(pga_forms) "formsource TEXT"

    set pga_tabs(pga_scripts) [list]
    append pga_tabs(pga_scripts) "scriptname VARCHAR(64) PRIMARY KEY,"
    append pga_tabs(pga_scripts) "scriptsource TEXT"

    set pga_tabs(pga_reports) [list]
    append pga_tabs(pga_reports) "reportname VARCHAR(64) PRIMARY KEY,"
    append pga_tabs(pga_reports) "reportsource TEXT,"
    append pga_tabs(pga_reports) "reportbody TEXT,"
    append pga_tabs(pga_reports) "reportprocs TEXT,"
    append pga_tabs(pga_reports) "reportoptions TEXT"

    set pga_tabs(pga_diagrams) [list]
    append pga_tabs(pga_diagrams) "diagramname VARCHAR(64) PRIMARY KEY,"
    append pga_tabs(pga_diagrams) "diagramtables TEXT,"
    append pga_tabs(pga_diagrams) "diagramlinks TEXT"

    set pga_tabs(pga_graphs) [list]
    append pga_tabs(pga_graphs) "graphname VARCHAR(64) PRIMARY KEY,"
    append pga_tabs(pga_graphs) "graphsource TEXT,"
    append pga_tabs(pga_graphs) "graphcode TEXT"

    set connstr "dbname=$PgAcVar(opendb,dbname) \
                 user=$PgAcVar(opendb,username) \
                 password=$PgAcVar(opendb,password)"


    if {$PgAcVar(opendb,username)!=""} {
	    if {$PgAcVar(opendb,host)!=""} {
    	    set connres [catch {set newdbc [pg_connect \
            -conninfo "host=$PgAcVar(opendb,host) port=$PgAcVar(opendb,pgport) $connstr"]} msg]
	    } else {
      	    set connres [catch {set newdbc [pg_connect \
            -conninfo "$connstr"]} msg]
	    }
    } else {
	    set connres [catch {set newdbc [pg_connect $PgAcVar(opendb,dbname) \
             -host $PgAcVar(opendb,host) \
             -port $PgAcVar(opendb,pgport)]} msg]
    }

    if {$connres} {
	    setCursor DEFAULT
	    showError [format [intlmsg "Error trying to connect to database '%s' on host %s \n\nPostgreSQL error message:%s"] $PgAcVar(opendb,dbname) $PgAcVar(opendb,host) $msg"] "open_database"
        return $msg
    } else {
		$Win(statuslabel) configure \
		    -text "Loading $PgAcVar(opendb,dbname) ..."

	    #catch {pg_disconnect $CurrentDB}
	    set CurrentDB $newdbc
	    Preferences::load
	    set PgAcVar(currentdb,host) $PgAcVar(opendb,host)
	    set PgAcVar(currentdb,pgport) $PgAcVar(opendb,pgport)
	    set PgAcVar(currentdb,dbname) $PgAcVar(opendb,dbname)
	    set PgAcVar(currentdb,username) $PgAcVar(opendb,username)
	    set PgAcVar(currentdb,password) $PgAcVar(opendb,password)
	    set PgAcVar(statusline,dbname) $PgAcVar(currentdb,dbname)
	    #set PgAcVar(pref,lastdb) $PgAcVar(currentdb,dbname)
	    #set PgAcVar(pref,lasthost) $PgAcVar(currentdb,host)
		#if {[string match "sockets" $PgAcVar(pref,lasthost)]} {
		#    set PgAcVar(pref,lasthost) ""
		#}
	    # set PgAcVar(pref,lastport) $PgAcVar(currentdb,pgport)
	    # set PgAcVar(pref,lastusername) $PgAcVar(currentdb,username)

	    # check if we are saving passwords
	    #if {[info exists PgAcVar(pref,savepasswords)] && $PgAcVar(pref,savepasswords)==1} {
		#    set PgAcVar(pref,lastpassword) $PgAcVar(currentdb,password)
	    #} else {
		#    set PgAcVar(pref,lastpassword) {}
	    #}
		
        # dont save prefs here anymore with multiple connections
        # Preferences::save
	    #catch {setCursor DEFAULT ; Window hide .pgaw:OpenDB}
        setCursor DEFAULT
        catch {Window destroy .pgaw:OpenDB}

	    # Check for pga_ tables
	    foreach {table structure} [array get pga_tabs] {

            set pgres [wpg_exec $CurrentDB "
                SELECT relname 
                  FROM [::Database::qualifySysTable Pg_class]
                 WHERE relname='$table'"]

	    	if {$PgAcVar(pgsql,status)!="PGRES_TUPLES_OK"} {
	    		showError "[intlmsg {FATAL ERROR searching for PgAccess system tables}] : $PgAcVar(pgsql,errmsg)\nStatus:$PgAcVar(pgsql,status)"
	    		catch {pg_disconnect $CurrentDB}
		        $Win(statuslabel) configure \
		            -text ""
	    		exit
            } elseif {[pg_result $pgres -numTuples]==0} {
                pg_result $pgres -clear
                sql_exec quiet "
                    CREATE TABLE $table ($structure) WITH OIDS"
                sql_exec quiet "
                    GRANT ALL ON $table
                       TO PUBLIC"
                #
                # backwards compatibility with pga_schema
                # now its pga_diagrams
                # should rip this out in the distant future
                #
                if {$table=="pga_diagrams"} {
                    set pgres [wpg_exec $CurrentDB "
                        SELECT relname
                          FROM [::Database::qualifySysTable Pg_class]
                         WHERE relname='pga_schema'"]
                    if {[pg_result $pgres -numTuples]!=0} {
                        sql_exec quiet "
                            INSERT INTO pga_diagrams
                                 SELECT *
                                   FROM pga_schema"
                        sql_exec quiet "
                            DROP TABLE pga_schema"
                    }
                    pg_result $pgres -clear
                }; # end backwards schema/diagram compatibility

		    } else {
		     	foreach fieldspec [split $structure ,] {
			     	set field [lindex [split $fieldspec] 0]
                    pg_result $pgres -clear
                    set sql "
                        SELECT \"$field\"
                          FROM [::Database::quoteObject $table]"
                    set pgres [wpg_exec $CurrentDB $sql]
				    if {$PgAcVar(pgsql,status)!="PGRES_TUPLES_OK"} {
					    if {![regexp "attribute '$field' not found" $PgAcVar(pgsql,errmsg)]} {
						     showError "[intlmsg {FATAL ERROR upgrading PgAccess table}] $table: $PgAcVar(pgsql,errmsg)\nStatus:$PgAcVar(pgsql,status)"
						     catch {pg_disconnect $CurrentDB}
	                         $Win(statuslabel) configure \
	                             -text ""
						     exit
					    } else {
						     pg_result $pgres -clear
						     sql_exec quiet "
                                ALTER TABLE [::Database::quoteObject $table]
                                 ADD COLUMN $fieldspec"
					    }
				    }
			    }; # end foreach fieldspec
		    }
		    catch {pg_result $pgres -clear}
	    }; # end foreach table structure 
	
	    # searching for autoexec script
        set pgres [wpg_exec $CurrentDB "
            SELECT relname
              FROM [::Database::qualifySysTable Pg_class]
             WHERE relname='pga_scripts'"]
        if {[pg_result $pgres -numTuples]!=0} {
            wpg_select $CurrentDB "
                SELECT *
                  FROM Pga_scripts
                 WHERE scriptname ~* '^autoexec$'" rec {
                    eval $rec(scriptsource)
            }
        }
        catch {pg_result $pgres -clear}

    }

	#::Connections::check
    #if {![$Win(tree) visible root]} {
            #$Win(tree) delete [$Win(tree) nodes root]
            #fillTree

	    
    #}

	#if {[lsearch [getHosts] $PgAcVar(currentdb,host)] < 0} {

        #addHost

        #$::Mainlib::Win(tree) insert end root __host__-$M \
            #-text "$M" \
         	#-image [image create photo -data $::Mainlib::_base64(online:rx)]
	#}

	addDbNode $PgAcVar(currentdb,host) $PgAcVar(currentdb,dbname)

	::Connections::save

	$Win(statuslabel) configure \
	  -text ""
    
	return

}; # end proc ::Mainlib::open_datase



#----------------------------------------------------------
# ::Mainlib::fillTree --
#
#    Fills the tree widget with the DB information
#
# Arguments:
#    none
#
# Results:
#    none returned
#----------------------------------------------------------
#
proc ::Mainlib::fillTree {} {

    global PgAcVar Win CurrentDB
    variable Win

    ##
    ##  Once we go to multiple connections, this will
    ##  a real list of computers. Now it defaults to 
    ##  the currentdb host
    ##
    #set complist [list $PgAcVar(currentdb,host)]
    set complist [::Connections::getHosts]
    foreach M $complist {
        #if {[string match "" $M]} {set M localhost}

        #$::Mainlib::Win(tree) insert end root __host__-$M \
            #-text "$M" \
      	#-image [image create photo -data $::Mainlib::_base64(online:rx)]

	    addHostNode $M
    
        ##
        ##  Right now we just handle the currentdb
        ##
        #set dblist($M) [list $PgAcVar(currentdb,dbname)]
        set dblist($M) [::Connections::getDbs $M]
        foreach N $dblist($M) {
        
            addDbNode $M $N

###          $::Mainlib::Win(tree) insert end __host__-$M db-${M}-${N} \
###                -text "$N" \
###        		-image [image create photo -data $::Mainlib::_base64(si_drive4)]
###        
###            foreach I $PgAcVar(tablist) {
###               $::Mainlib::Win(tree) insert end db-${M}-${N} ${M}-${N}-${I} \
###                   -text "[string totitle $I]" \
###                   -image [image create photo -data $::Mainlib::_base64(si_grid)]
###            }   

        }

    }

    ##
    ##  This just opens up the tree to the "current DB"
    ##  assuming that the user wants to start there
    ##
    if {[string match "" $PgAcVar(currentdb,host)]} {
        $Win(tree) opentree __host__-sockets 0
        $Win(tree) opentree __db__-sockets-$PgAcVar(currentdb,dbname)
    } else {
        $Win(tree) opentree __host__-$PgAcVar(currentdb,host) 0
        $Win(tree) opentree __db__-${PgAcVar(currentdb,host)}-$PgAcVar(currentdb,dbname)
    }

    ##
    ## This is if there is an autoexec script in the scripts db
    ##
    if {([info exists PgAcVar(activetab)]) && (![string match "" $PgAcVar(activetab)])} {
        set node ${PgAcVar(currentdb,host)}-${PgAcVar(currentdb,dbname)}-$PgAcVar(activetab)
        #$Win(tree) selection set $node
        #$Win(tree) selection see $node
        select 1 $node
    }

    return
    
}; # end proc ::Mainlib::fillTree 

#------------------------------------------------------------
# ::Mainlib::addHostNode --
#
#    This adds a host node to the tree list
#
# Arguments:
#    host_    then hostname to use for the tree node
#
# Results:
#    none returned
#------------------------------------------------------------
#
proc ::Mainlib::addHostNode {host_} {

    variable Win

	set txt $host_
	set img ::icon::network_local-16

    if {[string match "" $host_]} {
	    set host_ sockets
		set txt "local (sockets)"
	    set img ::icon::system-16
	}

	if {[$Win(tree) exists __host__-$host_]} {return}

    $::Mainlib::Win(tree) insert end root __host__-$host_ \
        -text "$txt" \
      	-image $img
      	#-image [image create photo -data $::Mainlib::_base64(online:rx)]

    return

}; # end proc ::Mainlib::addHostNode

#------------------------------------------------------------
# ::Mainlib::addDbNode --
#
#    This adds a database node to the tree list
#
# Arguments:
#    host_    then hostname for this db
#    db_      the db name to use for the db node
#
# Results:
#    none returned
#------------------------------------------------------------
#
proc ::Mainlib::addDbNode {host_ db_} {

    variable Win
    variable img

	set i [image create photo -data $::Mainlib::_base64(si_grid)]

    if {[string match "" $host_]} {set host_ sockets}

    if {[$Win(tree) exists __db__-${host_}-${db_}]} {return}

    if {![$Win(tree) exists __host__-$host_]} {
	if {[string match "sockets" $host_]} {
	    addHostNode ""
        } else {

            addHostNode $host_
        }
    }

    $::Mainlib::Win(tree) insert end __host__-$host_ __db__-${host_}-${db_} \
        -text "$db_" \
        -image [image create photo -data $::Mainlib::_base64(si_sql)]
        
    foreach I $::PgAcVar(tablist) {
        $::Mainlib::Win(tree) insert end __db__-${host_}-${db_} ${host_}-${db_}-${I} \
	    -text [intlmsg $I] \
           -image $img($I)
           #-image [image create photo -data $::Mainlib::_base64(si_grid)]
    }   

    return

}; # end proc ::Mailib::addDbNode

#----------------------------------------------------------
# ::Mainlib::nodeOpen --
#
#
# Arguments:
#    node    This gets passed from the bind on the node
#            in the tree. It is the node that was selected
#
# Results:
#    none returned
#----------------------------------------------------------
#
proc ::Mainlib::nodeOpen {node} {

    variable Win

    foreach {junk host db} [split $node -] break

    if {(![string match "__db__" $junk]) && (![string match "__host__" $junk])} {
		set db $host
        set host $junk
    }

	if {[string match "sockets" "$host"]} {
        $Win(hostlabel) configure \
            -text "local (sockets)"
	} else {
        $Win(hostlabel) configure \
            -text "${host}"
    }

    $Win(dblabel) configure \
        -text "${db}"

    regsub {sockets} $host {} nhost

	set id [::Connections::getIds $nhost $db]
    if {[string match "" $id]} {
	   set v ""
	} else {
	   if {![info exists ::Connections::Conn(pgversion,$id)]} {
		   set dbh [::Connections::getHandles $host $db]
	       set Connections::Conn(pgversion,$id) [::Database::getPgVersion $dbh]
	   }
	   set v $::Connections::Conn(pgversion,$id)
	}
    
    $Win(verlabel) configure \
        -text "PG: $v"
            #-text "PG: [::Database::getPgVersion]"

    return

} ; # end proc ::Mainlib::nodeOpen

#----------------------------------------------------------
# ::Mainlib::select --
#
#
# Arguments:
#    num_    Which button was pressed (1 or 2)
#    node_   This is passed in by the Tree widget. It is
#            the node that is selected.
#
# Results:
#    none returned
#----------------------------------------------------------
#
proc ::Mainlib::select {num_ node_} {

    global PgAcVar CurrentDB
    variable Win
    variable boolean

    $Win(tree) selection set $node_

    foreach {comp db entry} [split $node_ -] {break}

	switch -glob -- $node_ {
	   __host__-* {
	       set host $db
		   set db ""
		   set entry ""

	       set cols [list 0 [intlmsg Name] left 0 [intlmsg DBs] left]
        
                $Win(mclist) configure \
                    -columns $cols
        
                $Win(mclist) delete 0 end
        
                setCursor CLOCK

                $Win(mclist) insert end \
                [list $host [llength [$Win(tree) nodes $node_]]]

                setCursor DEFAULT
	   }
	   __db__-*   {
	           set host $db
		   set db $entry
		   set entry ""

	           set id [::Connections::getIds $host $db]
		   if {[info exists ::Connections::Conn(handle,$id)]} {
		       set CurrentDB $::Connections::Conn(handle,$id)
                   }

                set sql "
		   SELECT U.usename,D.*
		     FROM [::Database::qualifySysTable Pg_database] D, 
                            [::Database::qualifySysTable Pg_user] U
                    WHERE datname = '$db'
		      AND U.usesysid = D.datdba"


	       set id [::Connections::getIds $host $db]
	       if {[info exists ::Connections::Conn(handle,$id)]} {
	           set CurrentDB $::Connections::Conn(handle,$id)
                    set ::PgAcVar(currentdb,pgport) $::Connections::Conn(pgport,$id)
                    set ::PgAcVar(currentdb,username) $::Connections::Conn(username,$id)
                    set ::PgAcVar(currentdb,password) $::Connections::Conn(password,$id)
               }

               set cols [list 0 [intlmsg Owner] left 0 [intlmsg Encoding] left]
               lappend cols 0 [intlmsg Template?] left 0 [intlmsg Connection?] left
               lappend cols 0 [intlmsg Sysoid] left
        
                $Win(mclist) configure \
                 -columns $cols
        
                $Win(mclist) delete 0 end
        
                setCursor CLOCK
                
                if {[catch {wpg_select $CurrentDB "$sql" r {
                    $Win(mclist) insert end \
                        [list $r(usename) $r(encoding) $boolean($r(datistemplate)) $boolean($r(datallowconn)) $r(datlastsysoid)]
                }}]} {
                    ::Mainlib::Database:Close
                }
                
                setCursor DEFAULT

                
	   }
	   default {
	         set host $comp

	           set id [::Connections::getIds $host $db]
		   if {[info exists ::Connections::Conn(handle,$id)]} {
		       set CurrentDB $::Connections::Conn(handle,$id)
                       set ::PgAcVar(currentdb,pgport) $::Connections::Conn(pgport,$id)
                       set ::PgAcVar(currentdb,username) $::Connections::Conn(username,$id)
                   }

                if {[lsearch $PgAcVar(tablist) $entry] >= 0} {
                     catch {cmd_$entry}
                }
	   }
	}; # end switch

    set ::PgAcVar(currentdb,host) $host
    set ::PgAcVar(currentdb,dbname) $db
    set ::PgAcVar(pref,lasthost) $host
    set ::PgAcVar(pref,lastdb) $db

    set PgAcVar(activetab) $entry

    nodeOpen $node_

    return

}; # end proc select

#----------------------------------------------------------
# ::Mainlib::DatabaseCmd --
#
#    Selects the command for the correct menu item
#
# Arguments:
#    none
#
# Results:
#    none returned
#----------------------------------------------------------
#
proc ::Mainlib::DatabaseCmd {item_} {

    switch -- $item_ {
        Vacuum       {::Database::vacuum}
        Import_table {::ImportExport::setup Import}
        Export_table {::ImportExport::setup Export}
        Preferences  {::Preferences::configure}
        Exit         {::Mainlib::Exit}
        Open         {::Connections::openConn 0 1}
        default      {::Mainlib::Database:$item_}
    }; # end switch

    return

}; # end proc ::Mainlib::DatabaseCmd

#----------------------------------------------------------
# ::Mainlib::Database:New --
#
#    Opens the new db dialog window
#
# Arguments:
#    none
#
# Results:
#    none returned
#----------------------------------------------------------
#
proc ::Mainlib::Database:New {} {

    Window show .pgaw:NewDatabase
    wm transient .pgaw:NewDatabase

    return

}; # end proc ::Mainlib::Database:New

#----------------------------------------------------------
# ::Mainlib::Database:Manage --
#
#    Window to manages the connections info
#
# Arguments:
#    none
#
# Results:
#    none returned
#----------------------------------------------------------
#
proc ::Mainlib::Database:Manage {} {

    global PgAcVar
  
    if {[winfo exists .manage]} {
        deiconify .manage
    } else {
        toplevel .manage
    }

    wm title .manage "Manage Connections"

    set fm [frame .manage.fm \
        -relief raised \
        -bd 1]

    set c 0
    foreach t [list host dbname autoload "show system tables" "show pgaccess tables" "save passwords"] {
        label $fm.lab$c \
            -text "$t" \
            -font $PgAcVar(pref,font_bold) \
            -relief groove \
            -foreground navy \
            -background #EEEEEE

        grid $fm.lab$c \
            -row 0 \
            -column $c \
            -sticky we

        incr c
    }

    foreach H [::Connections::getHosts] {
        if {[string match "" $H]} {set H sockets}

        foreach D [::Connections::getDbs $H] {
            set i [::Connections::getIds $H $D]
            label $fm.h$i \
                -text "$H"
            label $fm.d$i \
                -text "$D"

            checkbutton $fm.al$i \
                -variable ::Connections::Conn(autoload,$i)

            checkbutton $fm.vs$i \
                -variable ::Connections::Conn(viewsystem,$i)

            checkbutton $fm.va$i \
                -variable ::Connections::Conn(viewpgaccess,$i)

            checkbutton $fm.sp$i \
                -variable ::Connections::Conn(savepasswords,$i)

            grid $fm.h$i $fm.d$i $fm.al$i $fm.vs$i $fm.va$i $fm.sp$i\
                -sticky w \
                -padx 4
        }
    }

    grid $fm \
        -sticky news

###    button .manage.btnsave \
###        -command ::Connections::initSave \
###        -padx 9 \
###        -pady 3 \
###        -text [intlmsg Save]

    button .manage.btncancel \
        -command {::Connections::save; Window destroy .manage} \
        -padx 9 \
        -pady 3 \
        -text [intlmsg Close]
    

    grid .manage.btncancel \
        -sticky ew

    return

}; # end proc ::Mainlib::Database:Manage

#----------------------------------------------------------
# ::Mainlib::Database:Close --
#
#    Closes the database connection to the current DB
#
# Arguments:
#    none
#
# Results:
#    none returned
#----------------------------------------------------------
#
proc ::Mainlib::Database:Close {} {

    variable Win

    set node [$Win(tree) selection get]
    if {([string match "" $node]) || ([string match "__host__-*" $node])} {return}


    foreach {H D E} [split $node -] break

	if {[string match "__db__-*" $node]} {
		set H $D
	    set D $E
	}

    #catch {pg_disconnect $::CurrentDB}

    catch {pg_disconnect [::Connections::getHandles $H $D]}
    $Win(tree) delete [$Win(tree) nodes __db__-${H}-${D}]
    $Win(tree) delete __db__-${H}-${D}

    $Win(mclist) delete 0 end
	$Win(mclist) configure \
	    -columns [list 0 "" left]

    if {[llength [$Win(tree) nodes __host__-${H}]] == 0} {
	   $Win(tree) delete __host__-${H}
	   set h [$Win(tree) nodes root]
	   if {[llength $h] != 0} {
	       select 1 [lindex $h 0]
		   select 1 [lindex [$Win(tree) nodes $h] 0]
	   }
	} else {
	    select 1 [lindex [$Win(tree) nodes __host__-${H}] 0]
	}

	set i [::Connections::getIds $H $D]
    ::Connections::deleteInfo $i

    set ::CurrentDB {}
    set ::PgAcVar(currentdb,dbname) {}
    #set ::PgAcVar(statusline,dbname) {}

    foreach L {host db ver} {
	    $Win(${L}label) configure \
		    -text ""
	}


    ::Connections::save

    return
}; # end proc ::Mainlib::Database:Close

#----------------------------------------------------------
# ::Mainlib::Database:SQL_window --
#
#
# Arguments:
#    none
#
# Results:
#    none returned
#----------------------------------------------------------
#
proc ::Mainlib::Database:SQL_window {} {

    Window show .pgaw:SQLWindow

    return

}; # end proc ::Mainlib::Database:SQL_window

#----------------------------------------------------------
# ::Mainlib::Exit --
#
#    Exits PGAccess
#
# Arguments:
#    none
#
# Results:
#    none returned
#----------------------------------------------------------
#
proc ::Mainlib::Exit {} {

    global PgAcVar CurrentDB

    # if theres no current db vars, just quit
    #if {![info exists PgAcVar(currentdb,dbname)]
    #    || ![info exists PgAcVar(currentdb,username)]
    #    || ![info exists PgAcVar(currentdb,pgport)]} {
    #    catch {pg_disconnect $CurrentDB}
    #    exit
    #}

	#set PgAcVar(pref,lastdb) $::PgAcVar(currentdb,dbname)
	#set PgAcVar(pref,lasthost) $::PgAcVar(currentdb,host)

	#if {[string match "sockets" $PgAcVar(pref,lasthost)]} {
	#    set PgAcVar(pref,lasthost) ""
	#}

	#set PgAcVar(pref,lastport) $PgAcVar(currentdb,pgport)
	#set PgAcVar(pref,lastusername) $PgAcVar(currentdb,username)

	# check if we are saving passwords
	#if {[info exists PgAcVar(pref,savepasswords)] && $PgAcVar(pref,savepasswords)==1} {
	#    set PgAcVar(pref,lastpassword) $PgAcVar(currentdb,password)
    #    foreach {k v} [array get ::Connections::Conn password,*] {
    #        set ::Connections::Conn($k) ""
    #    }
	#} else {
	#    set PgAcVar(pref,lastpassword) {}
	#}
    set PgAcVar(activetab) {}
    set PgAcVar(pref,geometry) [winfo geometry .]
    Preferences::save
    Connections::save

    foreach C [::Connections::getHandles] {
        catch {pg_disconnect $C}
    }

    exit
}; # end proc ::Mainlib::Exit


#----------------------------------------------------------
# ::Mainlib::ObjectCmd --
#
#    Selects the command for the correct menu item
#
# Arguments:
#    none
#
# Results:
#    none returned
#----------------------------------------------------------
#
proc ::Mainlib::ObjectCmd {item_} {

    cmd_$item_

    return

}; # end proc ::Mainlib::ObjectCmd

#----------------------------------------------------------
# ::Mainlib::ServerCmd --
#
#    Selects the command for the correct menu item
#
# Arguments:
#    none
#
# Results:
#    none returned
#----------------------------------------------------------
#
proc ::Mainlib::ServerCmd {item_} {

    switch -- $item_ {
        Dump_database {::Mainlib::cmd_Dump text}
        PgMonitor     {::::Pgmonitor::openWin}
        default       {::Mainlib::cmd_Dump binary}
    }; # end switch

    return

}; # end proc ::Mainlib::ServerCmd

#----------------------------------------------------------
# ::Mainlib::HelpCmd --
#
#    Selects the command for the correct menu item
#
# Arguments:
#    none
#
# Results:
#    none returned
#----------------------------------------------------------
#
proc ::Mainlib::HelpCmd {item_} {

    switch -- $item_ {
        Contents   {::Help::load index}
        PostgreSQL {::Help::load postgresql}
        About      {Window show .pgaw:About}
    }; # end switch

    return

}; # end proc ::Mainlib::HelpCmd

#----------------------------------------------------------
# ::Mainlib::handleToolBar --
#
#    Checks to see if the toolbar needs to be hidden or
#    shown
#
# Arguments:
#    none
#
# Results:
#    none returned
#----------------------------------------------------------
#
proc ::Mainlib::handleToolBar {} {

	global PgAcVar
    variable Win

    if {![info exists PgAcVar(pref,showtoolbar)]} {set PgAcVar(pref,showtoolbar) 1}

	if {$PgAcVar(pref,showtoolbar)} {

	    pack $Win(toolframe) \
	    	-before $Win(csmframe) \
	        -fill x

	} else {

	    pack forget $Win(toolframe)
	}

    return

}; # end proc ::Mainlib::HelpCmd


#------------------------------------------------------------
#------------------------------------------------------------
#
proc ::Mainlib::notEmpty {var_} {

    upvar $var_ V

    if {([info exists V]) && (![string match "" $V])} {
        return 1
    }

    return 0
}; # end proc ::Mainlib::notEmpty



#----------------------------------------------------------
# vTclWindow.pgaw:Main --
#
#    Builds the main GUI
#
# Arguments:
#    base    this is the base window
#
# Results:
#    none returned
#----------------------------------------------------------
#
proc vTclWindow.pgaw:Main {base} {

    global PgAcVar Win CurrentDB

    if {$base == ""} {
	set base .pgaw:Main
    }
    if {[winfo exists $base]} {
	#wm deiconify $base; return
    }
	#toplevel $base -class Toplevel \
	    #-background #efefef -cursor left_ptr

    ##
    ##  This is a total hack!
    ##  This is to get around the fact that
    ##  alot of other procs reference this window
    ##  which was replaced with the new interface
    ##  Will tear this out when we take care of the
    ##  references from other procs
    ##
    frame .pgaw:Main


    wm geometry . 600x400
	if {([info exists PgAcVar(pref,geometry)]) && (![string match "" $PgAcVar(pref,geometry)])} {
	    wm geometry . $PgAcVar(pref,geometry)
	}
    wm title . "PostgreSQL Access"
	#wm maxsize $base 1280 1024
	#wm minsize $base 1 1
	#wm overrideredirect $base 0
	#wm resizable $base 0 0
	#wm deiconify $base

    set base ""
    set ::Mainlib::Win(menuframe) $base.mf
    set ::Mainlib::Win(toolframe) [frame $base.tbf]
    set ::Mainlib::Win(csmframe) [frame $base.mainf]
    set ::Mainlib::Win(labelframe) [frame $base.labf]

    option add *Menu.borderWidth 1                   widgetDefault
    option add *Menu.font $PgAcVar(pref,font_normal) widgetDefault
    option add *Menu.tearOff 0                       widgetDefault
    option add *ButtonBox.borderWidth  1             widgetDefault
    option add *ButtonBox.takeFocus  0               widgetDefault
    option add *ButtonBox.highLightThickness  0      widgetDefault



    ##
    ##  This is the new style of creating menus
    ##
    menu $::Mainlib::Win(menuframe)
    . configure -menu $::Mainlib::Win(menuframe)

    set mn(Database) [list New Open Manage Close Vacuum sep Import_table Export_table]
    lappend mn(Database) sep Preferences SQL_window sep Exit
    set mn(Object) [list New Open Design Copy Rename Delete]
    set mn(Server) [list Dump_database Dump_database_(binary) sep PgMonitor]
    set mn(Help) [list Contents PostgreSQL sep About]

    ##
    ##  This is just a convenience...we loop through
    ##  the different meny items for each main menu
    ##  we assume there is a proc with the same name
    ##  as the label
    ##
    foreach MM {Database Object Server Help} {

        set x [string tolower $MM]

        $::Mainlib::Win(menuframe) add cascade \
            -label [intlmsg $MM] \
            -menu $::Mainlib::Win(menuframe).$x
  
        menu $::Mainlib::Win(menuframe).$x

        foreach M $mn($MM) {

            regsub -all {_} $M { } txt

            if {[string match sep $M]} {
                $::Mainlib::Win(menuframe).$x add separator
            } else {
               $::Mainlib::Win(menuframe).$x add command \
                    -label [intlmsg $txt] \
                    -command "::Mainlib::${MM}Cmd $M"
           }
        }; # end foreach sub menu

    }; # end foreach main menu


    ##
    ##  TOOL BAR
    ##
    set ::Mainlib::Win(bbox1) [ButtonBox $::Mainlib::Win(toolframe).bbox -spacing 2]

    DynamicHelp::configure -font {Helvetica 10}

        $::Mainlib::Win(bbox1) add -image ::icon::connect_creating-22 \
            -padx 1 \
            -pady 1 \
            -relief link \
            -command [list ::Mainlib::DatabaseCmd Open] \
            -helptext [intlmsg "Connect to DB"]

        $::Mainlib::Win(bbox1) add -image ::icon::connect_no-22 \
            -padx 1 \
            -pady 1 \
            -relief link \
            -command [list ::Mainlib::DatabaseCmd Close] \
            -helptext [intlmsg "Close current connection"]

        $::Mainlib::Win(bbox1) add -image ::icon::filter1-22 \
            -padx 1 \
            -pady 1 \
            -relief link \
            -command [list ::Mainlib::DatabaseCmd Vacuum] \
            -helptext [intlmsg "Vacuum current DB"]
        
        $::Mainlib::Win(bbox1) add -image ::icon::down-22 \
            -padx 1 \
            -pady 1 \
            -relief link \
            -command [list ::Mainlib::DatabaseCmd Import_table] \
            -helptext [intlmsg "Import Table"]

        $::Mainlib::Win(bbox1) add -image ::icon::up-22 \
            -padx 1 \
            -pady 1 \
            -relief link \
            -command [list ::Mainlib::DatabaseCmd Export_table] \
            -helptext [intlmsg "Export Table"]

        $::Mainlib::Win(bbox1) add -image ::icon::configure-22 \
            -padx 1 \
            -pady 1 \
            -relief link \
            -command [list ::Mainlib::DatabaseCmd Preferences] \
            -helptext [intlmsg "Preferences"]

    Separator $::Mainlib::Win(toolframe).sep  -orient vertical

    set ::Mainlib::Win(bbox2) [ButtonBox $::Mainlib::Win(toolframe).bbox2 -spacing 2]


        $::Mainlib::Win(bbox2) add -image ::icon::filenew-22 \
            -padx 1 \
            -pady 1 \
            -relief link \
            -command ::Mainlib::cmd_New \
            -helptext [intlmsg "New Object"]

        $::Mainlib::Win(bbox2) add -image ::icon::fileopen-22 \
            -relief link \
            -padx 1 \
            -pady 1 \
            -command ::Mainlib::cmd_Open \
            -helptext [intlmsg "Open Selected Object"]

        $::Mainlib::Win(bbox2) add -image ::icon::edit-22 \
            -relief link \
            -padx 1 \
            -pady 1 \
            -command ::Mainlib::cmd_Design \
            -helptext [intlmsg "Design Selected Object"]

        $::Mainlib::Win(bbox2) add -image ::icon::editcopy-22 \
            -relief link \
            -padx 1 \
            -pady 1 \
            -command ::Mainlib::cmd_Copy \
            -helptext [intlmsg "Copy Selected Object"]

        $::Mainlib::Win(bbox2) add -image ::icon::move-22 \
            -relief link \
            -padx 1 \
            -pady 1 \
            -command ::Mainlib::cmd_Rename \
            -helptext [intlmsg "Rename Selected Object"]

        $::Mainlib::Win(bbox2) add -image ::icon::edittrash-22 \
            -relief link \
            -padx 1 \
            -pady 1 \
            -command ::Mainlib::cmd_Delete \
            -helptext [intlmsg "Delete Selected Object"]

    ##
    ##   PANED WINDOW
    ##
    set ::Mainlib::Win(panew) [PanedWindow $::Mainlib::Win(csmframe).pane \
        -side bottom \
        -weights available]

    set ::Mainlib::Win(pane1) [$::Mainlib::Win(panew) add -weight 1]
    set ::Mainlib::Win(pane2) [$::Mainlib::Win(panew) add -weight 3]
    
    #set ::Mainlib::Win(bbox2) [ButtonBox $::Mainlib::Win(csmframe).bbox2 \
        #-spacing 0 \
    	#-padx 1 \
    	#-pady 1\
        #-orient vertical \
    	#-background #336699 \
    	#-homogeneous 1]
    
    ##
    ##  TREE WINDOW
    ##
	frame $::Mainlib::Win(pane1).tfm
	pack $::Mainlib::Win(pane1).tfm \
	    -expand 1 \
		-fill both

    scrollbar $::Mainlib::Win(pane1).tfm.xscroll \
        -width 12 \
        -command [list $::Mainlib::Win(pane1).tfm.tree xview] \
        -highlightthickness 0 \
		-orient horizontal \
		-background #DDDDDD \
        -takefocus 0

    scrollbar $::Mainlib::Win(pane1).tfm.yscroll \
        -width 12 \
        -command [list $::Mainlib::Win(pane1).tfm.tree yview] \
        -highlightthickness 0 \
		-background #DDDDDD \
		-takefocus 0

    

    set ::Mainlib::Win(tree) [Tree $::Mainlib::Win(pane1).tfm.tree \
		-width 500 \
		-deltay 22 \
        -dropenabled 1 \
    	-dragenabled 1 \
    	-dragevent 3 \
    	-opencmd   "::Mainlib::nodeOpen" \
    	-droptypes {
    	    TREE_NODE    {copy {} move {} link {}}
    	     LISTBOX_ITEM {copy {} move {} link {}}
    	} \
        -yscrollcommand [list $::Mainlib::Win(pane1).tfm.yscroll set] \
        -xscrollcommand [list $::Mainlib::Win(pane1).tfm.xscroll set] \
    	-background #fefefe]
    
    $::Mainlib::Win(tree) bindText  <ButtonPress-1>        "::Mainlib::select 1"
    $::Mainlib::Win(tree) bindImage  <ButtonPress-1>        "::Mainlib::select 1"
    $::Mainlib::Win(tree) bindText  <Double-ButtonPress-1> "::Mainlib::select 2"
    $::Mainlib::Win(tree) bindImage  <Double-ButtonPress-1> "::Mainlib::select 2"
    
    set ::Mainlib::Win(lbframe) [frame $::Mainlib::Win(pane2).lbframe]
    pack $::Mainlib::Win(lbframe) \
        -fill both \
        -expand 1

    scrollbar $::Mainlib::Win(pane2).xscroll \
        -width 12 \
        -command [list $::Mainlib::Win(lbframe).list xview] \
        -highlightthickness 0 \
		-orient horizontal \
		-background #DDDDDD \
        -takefocus 0

    scrollbar $::Mainlib::Win(lbframe).yscroll \
        -width 12 \
        -command [list $::Mainlib::Win(lbframe).list yview] \
        -highlightthickness 0 \
		-background #DDDDDD \
		-takefocus 0

    set ::Mainlib::Win(mclist) [tablelist::tablelist $::Mainlib::Win(lbframe).list \
        -yscrollcommand [list $::Mainlib::Win(lbframe).yscroll set] \
        -xscrollcommand [list $::Mainlib::Win(pane2).xscroll set] \
        -labelcommand tablelist::sortByColumn \
        -background #fefefe \
        -stripebg #e0e8f0 \
        -selectbackground #DDDDDD \
        -font $::PgAcVar(pref,font_normal) \
        -labelfont {Helvetica 11 bold} \
        -stretch all \
        -columns [list 0 "" left] \
        -selectforeground #708090 \
        -labelbackground #DDDDDD \
        -labelforeground navy
        ]

    set body [$::Mainlib::Win(mclist) bodypath]
    bind $body <Double-Button-1> [bind TablelistBody <Double-Button-1>]
    bind $body <Double-Button-1> +[list ::Mainlib::cmd_Open]


    set ::Mainlib::Win(hostlabel) [label $::Mainlib::Win(labelframe).lshost \
        -background #EEEEEE \
	    -anchor w \
        -relief groove \
        -text localhost \
        -foreground navy \
        -font $PgAcVar(pref,font_bold) \
        -width 20]

    set ::Mainlib::Win(dblabel) [label $::Mainlib::Win(labelframe).lsdbname \
        -background #EEEEEE \
	    -anchor w \
        -foreground navy \
        -font $PgAcVar(pref,font_bold) \
	    -relief groove \
        -width 20]

    set ::Mainlib::Win(verlabel) [label $::Mainlib::Win(labelframe).lsversion \
        -background #EEEEEE \
	-anchor w \
        -foreground navy \
        -font $PgAcVar(pref,font_bold) \
	-relief groove \
        -width 15]

    set ::Mainlib::Win(statuslabel) [label $::Mainlib::Win(labelframe).lsstatus \
	-anchor w \
        -foreground navy \
        -font $PgAcVar(pref,font_bold) \
        -width 20]

    set ::Mainlib::Win(secure) [label $::Mainlib::Win(labelframe).secure \
	    -image ::icon::decrypted-22 \
	    -anchor w]


    pack $::Mainlib::Win(pane1).tfm.xscroll \
        -side bottom \
        -fill x

    pack $::Mainlib::Win(pane1).tfm.yscroll \
        -side right \
        -fill y

    pack $::Mainlib::Win(pane2).xscroll \
        -side bottom \
        -fill x

    pack $::Mainlib::Win(lbframe).yscroll \
        -side right \
        -fill y
    
    pack $::Mainlib::Win(tree) $::Mainlib::Win(mclist) \
        -side left \
    	-anchor n \
        -expand 1 \
    	-fill both

	pack configure $::Mainlib::Win(tree) \
	    -expand 0
    
    pack $::Mainlib::Win(csmframe).pane \
        -expand 1 \
        -fill both

    pack $::Mainlib::Win(bbox1) $::Mainlib::Win(toolframe).sep \
	    -fill y \
		-side left \
		-padx 4 \
		-pady 2 \
        -anchor c

    pack $::Mainlib::Win(bbox2) \
		-padx 4 \
		-pady 2 \
	    -side right

    pack $::Mainlib::Win(hostlabel) $::Mainlib::Win(dblabel) $::Mainlib::Win(verlabel) $::Mainlib::Win(statuslabel)\
        -side left \
        -padx 2
        
    pack $::Mainlib::Win(secure) \
        -side right \
        -padx 2

    pack $::Mainlib::Win(toolframe) \
        -fill x

    pack $::Mainlib::Win(csmframe) \
        -fill both \
    	-expand 1

    pack $::Mainlib::Win(labelframe) \
        -pady 2 \
        -side top \
        -fill x

    ::Mainlib::handleToolBar

    return $base

}; # end proc vTclWindow.pgaw:Main




proc vTclWindow.pgaw:CopyObject {base} {
	if {$base == ""} {
		set base .pgaw:CopyObject
	}
	if {[winfo exists $base]} {
		wm deiconify $base; return
	}
	toplevel $base -class Toplevel
	wm focusmodel $base passive
	wm geometry $base 272x105+294+262
	wm maxsize $base 1280 1024
	wm minsize $base 1 1
	wm overrideredirect $base 0
	wm resizable $base 0 0
	wm title $base [intlmsg "Copy"]
	label $base.l1  -borderwidth 0 -text [intlmsg {Copy to}]
	entry $base.e1  -background #fefefe -borderwidth 1 -textvariable PgAcVar(New_Object_Name) 
	button $base.b1  -borderwidth 1  -command {
			if {$PgAcVar(New_Object_Name)==""} {
				showError [intlmsg "You must give object a new name!"]
			} elseif {$PgAcVar(activetab)=="Queries"} {
				set pgres [wpg_exec $CurrentDB "SELECT * FROM pga_queries WHERE queryname='$PgAcVar(New_Object_Name)'"]
				if {$PgAcVar(pgsql,status)!="PGRES_TUPLES_OK"} {
					showError "[intlmsg {Error retrieving from}] pga_queries\n$PgAcVar(pgsql,errmsg)\n$PgAcVar(pgsql,status)"
				} elseif {[pg_result $pgres -numTuples]>0} {
					showError [format [intlmsg "Query '%s' already exists!"] $PgAcVar(New_Object_Name)]
				} else {
					sql_exec noquiet "INSERT INTO pga_queries SELECT '$PgAcVar(New_Object_Name)' AS queryname, querytype, querycommand, querytables, querylinks, queryresults, querycomments FROM pga_queries WHERE queryname='$PgAcVar(Old_Object_Name)'"
					Mainlib::cmd_Queries
					Window destroy .pgaw:CopyObject
				}
				catch {pg_result $pgres -clear}
			} elseif {$PgAcVar(activetab)=="Reports"} {
				set pgres [wpg_exec $CurrentDB "SELECT * FROM pga_reports WHERE reportname='$PgAcVar(New_Object_Name)'"]
				if {$PgAcVar(pgsql,status)!="PGRES_TUPLES_OK"} {
					showError "[intlmsg {Error retrieving from}] pga_reports\n$PgAcVar(pgsql,errmsg)\n$PgAcVar(pgsql,status)"
				} elseif {[pg_result $pgres -numTuples]>0} {
					showError [format [intlmsg "Report '%s' already exists!"] $PgAcVar(New_Object_Name)]
				} else {
					sql_exec noquiet "INSERT INTO pga_reports SELECT '$PgAcVar(New_Object_Name)' AS reportname, reportsource, reportbody, reportprocs, reportoptions FROM pga_reports WHERE reportname='$PgAcVar(Old_Object_Name)'"
					Mainlib::cmd_Reports
					Window destroy .pgaw:CopyObject
				}
				catch {pg_result $pgres -clear}
			} elseif {$PgAcVar(activetab)=="Graphs"} {
				set pgres [wpg_exec $CurrentDB "SELECT * FROM pga_graphs WHERE graphname='$PgAcVar(New_Object_Name)'"]
				if {$PgAcVar(pgsql,status)!="PGRES_TUPLES_OK"} {
					showError "[intlmsg {Error retrieving from}] pga_graphs\n$PgAcVar(pgsql,errmsg)\n$PgAcVar(pgsql,status)"
				} elseif {[pg_result $pgres -numTuples]>0} {
					showError [format [intlmsg "Graph '%s' already exists!"] $PgAcVar(New_Object_Name)]
				} else {
					sql_exec noquiet "INSERT INTO pga_graphs SELECT '$PgAcVar(New_Object_Name)' AS graphname, graphsource, graphcode FROM pga_graphs WHERE graphname='$PgAcVar(Old_Object_Name)'"
					Mainlib::cmd_Graphs
					Window destroy .pgaw:CopyObject
				}
				catch {pg_result $pgres -clear}
			} elseif {$PgAcVar(activetab)=="Forms"} {
				set pgres [wpg_exec $CurrentDB "SELECT * FROM pga_forms WHERE formname='$PgAcVar(New_Object_Name)'"]
				if {$PgAcVar(pgsql,status)!="PGRES_TUPLES_OK"} {
					showError "[intlmsg {Error retrieving from}] pga_forms\n$PgAcVar(pgsql,errmsg)\n$PgAcVar(pgsql,status)"
				} elseif {[pg_result $pgres -numTuples]>0} {
					showError [format [intlmsg "Form '%s' already exists!"] $PgAcVar(New_Object_Name)]
				} else {
					sql_exec noquiet "INSERT INTO pga_forms SELECT '$PgAcVar(New_Object_Name)' AS formname, formsource FROM pga_forms WHERE formname='$PgAcVar(Old_Object_Name)'"
					Mainlib::cmd_Forms
					Window destroy .pgaw:CopyObject
				}
				catch {pg_result $pgres -clear}
			} elseif {$PgAcVar(activetab)=="Scripts"} {
				set pgres [wpg_exec $CurrentDB "SELECT * FROM pga_scripts WHERE scriptname='$PgAcVar(New_Object_Name)'"]
				if {$PgAcVar(pgsql,status)!="PGRES_TUPLES_OK"} {
					showError "[intlmsg {Error retrieving from}] pga_scripts\n$PgAcVar(pgsql,errmsg)\n$PgAcVar(pgsql,status)"
				} elseif {[pg_result $pgres -numTuples]>0} {
					showError [format [intlmsg "Script '%s' already exists!"] $PgAcVar(New_Object_Name)]
				} else {
					sql_exec noquiet "INSERT INTO pga_scripts SELECT '$PgAcVar(New_Object_Name)' AS scriptname, scriptsource FROM pga_scripts WHERE scriptname='$PgAcVar(Old_Object_Name)'"
					Mainlib::cmd_Scripts
					Window destroy .pgaw:CopyObject
				}
				catch {pg_result $pgres -clear}
			} elseif {$PgAcVar(activetab)=="Diagrams"} {
				set pgres [wpg_exec $CurrentDB "SELECT * FROM pga_diagrams WHERE diagramname='$PgAcVar(New_Object_Name)'"]
				if {$PgAcVar(pgsql,status)!="PGRES_TUPLES_OK"} {
					showError "[intlmsg {Error retrieving from}] pga_diagrams\n$PgAcVar(pgsql,errmsg)\n$PgAcVar(pgsql,status)"
				} elseif {[pg_result $pgres -numTuples]>0} {
					showError [format [intlmsg "Diagram '%s' already exists!"] $PgAcVar(New_Object_Name)]
				} else {
					sql_exec noquiet "INSERT INTO pga_diagrams SELECT '$PgAcVar(New_Object_Name)' AS diagramname, diagramtables, diagramlinks FROM pga_diagrams WHERE diagramname='$PgAcVar(Old_Object_Name)'"
					Mainlib::cmd_Diagrams
					Window destroy .pgaw:CopyObject
				}
				catch {pg_result $pgres -clear}
			}
	   } -text [intlmsg Copy]
	button $base.b2  -borderwidth 1 -command {Window destroy .pgaw:CopyObject} -text [intlmsg Cancel]
	place $base.l1  -x 15 -y 28 -anchor nw -bordermode ignore 
	place $base.e1  -x 100 -y 25 -anchor nw -bordermode ignore 
	place $base.b1  -x 55 -y 65 -width 80 -anchor nw -bordermode ignore 
	place $base.b2  -x 155 -y 65 -width 80 -anchor nw -bordermode ignore
}

proc vTclWindow.pgaw:RenameObject {base} {
	if {$base == ""} {
		set base .pgaw:RenameObject
	}
	if {[winfo exists $base]} {
		wm deiconify $base; return
	}
	toplevel $base -class Toplevel
	wm focusmodel $base passive
	wm geometry $base 272x105+294+262
	wm maxsize $base 1280 1024
	wm minsize $base 1 1
	wm overrideredirect $base 0
	wm resizable $base 0 0
	wm title $base [intlmsg "Rename"]
	label $base.l1  -borderwidth 0 -text [intlmsg {New name}]
	entry $base.e1  -background #fefefe -borderwidth 1 -textvariable PgAcVar(New_Object_Name) 
	button $base.b1  -borderwidth 1  -command {
			if {$PgAcVar(New_Object_Name)==""} {
				showError [intlmsg "You must give object a new name!"]
			} elseif {$PgAcVar(activetab)=="Tables"} {
				set retval [sql_exec noquiet "alter table \"$PgAcVar(Old_Object_Name)\" rename to \"$PgAcVar(New_Object_Name)\""]
				Diagrams::tbl_rename $PgAcVar(Old_Object_Name) $PgAcVar(New_Object_Name)
				if {$retval} {
					sql_exec quiet "update pga_layout set tablename='$PgAcVar(New_Object_Name)' where tablename='$PgAcVar(Old_Object_Name)'"
					Mainlib::cmd_Tables
					Window destroy .pgaw:RenameObject
				}
			} elseif {$PgAcVar(activetab)=="Queries"} {
				set pgres [wpg_exec $CurrentDB "select * from pga_queries where queryname='$PgAcVar(New_Object_Name)'"]
				if {$PgAcVar(pgsql,status)!="PGRES_TUPLES_OK"} {
					showError "[intlmsg {Error retrieving from}] pga_queries\n$PgAcVar(pgsql,errmsg)\n$PgAcVar(pgsql,status)"
				} elseif {[pg_result $pgres -numTuples]>0} {
					showError [format [intlmsg "Query '%s' already exists!"] $PgAcVar(New_Object_Name)]
				} else {
					sql_exec noquiet "update pga_queries set queryname='$PgAcVar(New_Object_Name)' where queryname='$PgAcVar(Old_Object_Name)'"
					sql_exec noquiet "update pga_layout set tablename='$PgAcVar(New_Object_Name)' where tablename='$PgAcVar(Old_Object_Name)'"
					Mainlib::cmd_Queries
					Window destroy .pgaw:RenameObject
				}
				catch {pg_result $pgres -clear}
			} elseif {$PgAcVar(activetab)=="Reports"} {
				set pgres [wpg_exec $CurrentDB "SELECT * FROM pga_reports WHERE reportname='$PgAcVar(New_Object_Name)'"]
				if {$PgAcVar(pgsql,status)!="PGRES_TUPLES_OK"} {
					showError "[intlmsg {Error retrieving from}] pga_reports\n$PgAcVar(pgsql,errmsg)\n$PgAcVar(pgsql,status)"
				} elseif {[pg_result $pgres -numTuples]>0} {
					showError [format [intlmsg "Report '%s' already exists!"] $PgAcVar(New_Object_Name)]
				} else {
					sql_exec noquiet "update pga_reports set reportname='$PgAcVar(New_Object_Name)' where reportname='$PgAcVar(Old_Object_Name)'"
					Mainlib::cmd_Reports
					Window destroy .pgaw:CopyObject
				}
				catch {pg_result $pgres -clear}
			} elseif {$PgAcVar(activetab)=="Graphs"} {
				set pgres [wpg_exec $CurrentDB "SELECT * FROM pga_graphs WHERE graphname='$PgAcVar(New_Object_Name)'"]
				if {$PgAcVar(pgsql,status)!="PGRES_TUPLES_OK"} {
					showError "[intlmsg {Error retrieving from}] pga_graphs\n$PgAcVar(pgsql,errmsg)\n$PgAcVar(pgsql,status)"
				} elseif {[pg_result $pgres -numTuples]>0} {
					showError [format [intlmsg "Graph '%s' already exists!"] $PgAcVar(New_Object_Name)]
				} else {
					sql_exec noquiet "update pga_graphs set graphname='$PgAcVar(New_Object_Name)' where graphname='$PgAcVar(Old_Object_Name)'"
					Mainlib::cmd_Graphs
					Window destroy .pgaw:CopyObject
				}
				catch {pg_result $pgres -clear}
			} elseif {$PgAcVar(activetab)=="Forms"} {
				set pgres [wpg_exec $CurrentDB "select * from pga_forms where formname='$PgAcVar(New_Object_Name)'"]
				if {$PgAcVar(pgsql,status)!="PGRES_TUPLES_OK"} {
					showError "[intlmsg {Error retrieving from}] pga_forms\n$PgAcVar(pgsql,errmsg)\n$PgAcVar(pgsql,status)"
				} elseif {[pg_result $pgres -numTuples]>0} {
					showError [format [intlmsg "Form '%s' already exists!"] $PgAcVar(New_Object_Name)]
				} else {
					sql_exec noquiet "update pga_forms set formname='$PgAcVar(New_Object_Name)' where formname='$PgAcVar(Old_Object_Name)'"
					Mainlib::cmd_Forms
					Window destroy .pgaw:RenameObject
				}
				catch {pg_result $pgres -clear}
			} elseif {$PgAcVar(activetab)=="Scripts"} {
				set pgres [wpg_exec $CurrentDB "select * from pga_scripts where scriptname='$PgAcVar(New_Object_Name)'"]
				if {$PgAcVar(pgsql,status)!="PGRES_TUPLES_OK"} {
					showError "[intlmsg {Error retrieving from}] pga_scripts\n$PgAcVar(pgsql,errmsg)\n$PgAcVar(pgsql,status)"
				} elseif {[pg_result $pgres -numTuples]>0} {
					showError [format [intlmsg "Script '%s' already exists!"] $PgAcVar(New_Object_Name)]
				} else {
					sql_exec noquiet "update pga_scripts set scriptname='$PgAcVar(New_Object_Name)' where scriptname='$PgAcVar(Old_Object_Name)'"
					Mainlib::cmd_Scripts
					Window destroy .pgaw:RenameObject
				}
				catch {pg_result $pgres -clear}
			} elseif {$PgAcVar(activetab)=="Diagrams"} {
				set pgres [wpg_exec $CurrentDB "select * from pga_diagrams where diagramname='$PgAcVar(New_Object_Name)'"]
				if {$PgAcVar(pgsql,status)!="PGRES_TUPLES_OK"} {
					showError "[intlmsg {Error retrieving from}] pga_diagrams\n$PgAcVar(pgsql,errmsg)\n$PgAcVar(pgsql,status)"
				} elseif {[pg_result $pgres -numTuples]>0} {
					showError [format [intlmsg "Diagram '%s' already exists!"] $PgAcVar(New_Object_Name)]
				} else {
					sql_exec noquiet "update pga_diagrams set diagramname='$PgAcVar(New_Object_Name)' where diagramname='$PgAcVar(Old_Object_Name)'"
					Mainlib::cmd_Diagrams
					Window destroy .pgaw:RenameObject
				}
				catch {pg_result $pgres -clear}
			}
	   } -text [intlmsg Rename]
	button $base.b2  -borderwidth 1 -command {Window destroy .pgaw:RenameObject} -text [intlmsg Cancel]
	place $base.l1  -x 15 -y 28 -anchor nw -bordermode ignore 
	place $base.e1  -x 100 -y 25 -anchor nw -bordermode ignore 
	place $base.b1  -x 55 -y 65 -width 80 -anchor nw -bordermode ignore 
	place $base.b2  -x 155 -y 65 -width 80 -anchor nw -bordermode ignore
}

proc vTclWindow.pgaw:NewDatabase {base} {
	if {$base == ""} {
		set base .pgaw:NewDatabase
	}
	if {[winfo exists $base]} {
		wm deiconify $base; return
	}
	toplevel $base -class Toplevel
	wm focusmodel $base passive
	wm geometry $base 272x105+294+262
	wm maxsize $base 1280 1024
	wm minsize $base 1 1
	wm overrideredirect $base 0
	wm resizable $base 0 0
	wm title $base [intlmsg "New"]
	label $base.l1  -borderwidth 0 -text [intlmsg {Name}]
	entry $base.e1  -background #fefefe -borderwidth 1 -textvariable PgAcVar(New_Database_Name) 
	button $base.b1  -borderwidth 1  -command {
		set retval [sql_exec noquiet "create database $PgAcVar(New_Database_Name)"]
		if {$retval} {
			Window destroy .pgaw:NewDatabase
		}
	} -text [intlmsg Create]
	button $base.b2  -borderwidth 1 -command {Window destroy .pgaw:NewDatabase} -text [intlmsg Cancel]
	place $base.l1  -x 15 -y 28 -anchor nw -bordermode ignore 
	place $base.e1  -x 100 -y 25 -anchor nw -bordermode ignore 
	place $base.b1  -x 55 -y 65 -width 80 -anchor nw -bordermode ignore 
	place $base.b2  -x 155 -y 65 -width 80 -anchor nw -bordermode ignore
}


proc vTclWindow.pgaw:GetParameter {base} {
	if {$base == ""} {
		set base .pgaw:GetParameter
	}
	if {[winfo exists $base]} {
		wm deiconify $base; return
	}
	toplevel $base -class Toplevel
	wm focusmodel $base passive
	set sw [winfo screenwidth .]
	set sh [winfo screenheight .]
	set x [expr ($sw - 297)/2]
	set y [expr ($sh - 98)/2]
	wm geometry $base 297x98+$x+$y
	wm maxsize $base 1280 1024
	wm minsize $base 1 1
	wm overrideredirect $base 0
	wm resizable $base 0 0
	wm deiconify $base
	wm title $base [intlmsg "Input parameter"]
	label $base.l1 \
		-anchor nw -borderwidth 1 \
		-justify left -relief sunken -textvariable PgAcVar(getqueryparam,msg) -wraplength 200 
	entry $base.e1 \
		-background #fefefe -borderwidth 1 -highlightthickness 0 \
		-textvariable PgAcVar(getqueryparam,var) 
	bind $base.e1 <Key-KP_Enter> {
		set PgAcVar(getqueryparam,result) 1
destroy .pgaw:GetParameter
	}
	bind $base.e1 <Key-Return> {
		set PgAcVar(getqueryparam,result) 1
destroy .pgaw:GetParameter
	}
	button $base.bok \
		-borderwidth 1 -command {set PgAcVar(getqueryparam,result) 1
destroy .pgaw:GetParameter} -text Ok 
	button $base.bcanc \
		-borderwidth 1 -command {set PgAcVar(getqueryparam,result) 0
destroy .pgaw:GetParameter} -text [intlmsg Cancel]
	place $base.l1 \
		-x 10 -y 5 -width 201 -height 53 -anchor nw -bordermode ignore 
	place $base.e1 \
		-x 10 -y 65 -width 200 -height 24 -anchor nw -bordermode ignore 
	place $base.bok \
		-x 225 -y 5 -width 61 -height 26 -anchor nw -bordermode ignore 
	place $base.bcanc \
		-x 225 -y 35 -width 61 -height 26 -anchor nw -bordermode ignore 
}


proc vTclWindow.pgaw:SQLWindow {base} {
	if {$base == ""} {
		set base .pgaw:SQLWindow
	}
	if {[winfo exists $base]} {
		wm deiconify $base; return
	}
	toplevel $base -class Toplevel
	wm focusmodel $base passive
	wm geometry $base 551x408+192+169
	wm maxsize $base 1280 1024
	wm minsize $base 1 1
	wm overrideredirect $base 0
	wm resizable $base 1 1
	wm deiconify $base
	wm title $base [intlmsg "SQL window"]
	frame $base.f \
		-borderwidth 1 -height 392 -relief raised -width 396 
	scrollbar $base.f.01 \
		-borderwidth 1 -command {.pgaw:SQLWindow.f.t xview} -orient horiz \
		-width 10 
	scrollbar $base.f.02 \
		-borderwidth 1 -command {.pgaw:SQLWindow.f.t yview} -orient vert -width 10 
	text $base.f.t \
		-borderwidth 1 \
		-height 200 -width 200 -wrap word \
		-xscrollcommand {.pgaw:SQLWindow.f.01 set} \
		-yscrollcommand {.pgaw:SQLWindow.f.02 set} 
	button $base.b1 \
		-borderwidth 1 -command {.pgaw:SQLWindow.f.t delete 1.0 end} -text [intlmsg Clean]
	button $base.b2 \
		-borderwidth 1 -command {destroy .pgaw:SQLWindow} -text [intlmsg Close] 
	grid columnconf $base 0 -weight 1
	grid columnconf $base 1 -weight 1
	grid rowconf $base 0 -weight 1
	grid $base.f \
		-in .pgaw:SQLWindow -column 0 -row 0 -columnspan 2 -rowspan 1 
	grid columnconf $base.f 0 -weight 1
	grid rowconf $base.f 0 -weight 1
	grid $base.f.01 \
		-in .pgaw:SQLWindow.f -column 0 -row 1 -columnspan 1 -rowspan 1 -sticky ew 
	grid $base.f.02 \
		-in .pgaw:SQLWindow.f -column 1 -row 0 -columnspan 1 -rowspan 1 -sticky ns 
	grid $base.f.t \
		-in .pgaw:SQLWindow.f -column 0 -row 0 -columnspan 1 -rowspan 1 \
		-sticky nesw 
	grid $base.b1 \
		-in .pgaw:SQLWindow -column 0 -row 1 -columnspan 1 -rowspan 1 
	grid $base.b2 \
		-in .pgaw:SQLWindow -column 1 -row 1 -columnspan 1 -rowspan 1 
}

proc vTclWindow.pgaw:About {base} {
	if {$base == ""} {
		set base .pgaw:About
	}
	if {[winfo exists $base]} {
		wm deiconify $base; return
	}
	toplevel $base -class Toplevel
	wm focusmodel $base passive
	wm geometry $base 471x177+168+243
	wm maxsize $base 1280 1024
	wm minsize $base 1 1
	wm overrideredirect $base 0
	wm resizable $base 1 1
	wm title $base [intlmsg "About"]
	label $base.l1  -borderwidth 3 -font -Adobe-Helvetica-Bold-R-Normal-*-*-180-*-*-*-*-*  -relief ridge -text PgAccess 
	label $base.l2  -relief groove  -text [intlmsg "A Tcl/Tk interface to
PostgreSQL
by Constantin Teodorescu"]
	label $base.l3  -borderwidth 0 -relief sunken -text {v 0.98.8}
	label $base.l4  -relief groove  -text "[intlmsg {You will always get the
latest version at:}]
http://www.pgaccess.org/
[intlmsg {Suggestions at}]:
developers@pgaccess.org"
	button $base.b1  -borderwidth 1 -command {Window destroy .pgaw:About} -text Ok 
	place $base.l1  -x 10 -y 10 -width 196 -height 103 -anchor nw -bordermode ignore 
	place $base.l2  -x 10 -y 115 -width 198 -height 55 -anchor nw -bordermode ignore 
	place $base.l3  -x 70 -y 80 -anchor nw -bordermode ignore 
	place $base.l4  -x 215 -y 10 -width 246 -height 103 -anchor nw -bordermode ignore 
	place $base.b1  -x 295 -y 130 -width 105 -height 28 -anchor nw -bordermode ignore
}




