# filter.tcl --
#
# This file contains code for handling message selection filters, and their
# actions upon the message list.
#
#  Postilion software and its included text and images
#  Copyright (C) 1998, 1999, 2000 Nic Bernstein
#
#  The full text of the legal notices is contained in the files called
#  COPYING and COPYRIGHT.TkRat, included with this distribution.
#
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2
#  of the License, or (at your option) any later version.
# 
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

# FilterApply
#
# Apply a filter to a message list
#
# Arguments:
# id		- The array index of the selected expression
# handler	- The handler which identifies the folder window that
#		  the selection should be done in.
# vf            - The vfolder we should move the message to

proc FilterApply {id handler action args } {
    upvar #0 $handler fh
    global expExp expName

    set vfolder {test1 file {} /home/nic/gnustep/Mailboxes/test2/test2}
    set advance 1
    set expId [RatParseExp $expExp($id)]
    set msgs {}
    foreach i [$fh(folder_handler) match $expId] {
	lappend msgs [$fh(folder_handler) get $i]
    }
    case $action {
	shade {
	}
	move { VFolderInsert $handler $advance $msgs $vfolder }
	copy { 
	}
	forward {
	}
	delete {
	}
	default {}
    }
    RatFreeExp $expId
}
