# info.tcl --
#
# This file contains rotines which provied the user with some information
# about this program.
#
#
#  TkRat software and its included text is Copyright 1996,1997,1998
#  by Martin Forssn
#
#  Postilion software and its included text and images
#  Copyright (C) 1998, 1999, 2000 Nic Bernstein
#
#  The full text of the legal notices is contained in the files called
#  COPYING and COPYRIGHT.TkRat, included with this distribution.
#
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2
#  of the License, or (at your option) any later version.
# 
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

# Version --
#
# Opens a window and prints the version information in it.
#
# Arguments:

proc Version {} {
    global t postilion_version postilion_version_date

    set w .about

    if [winfo exists $w] {
	wm deiconify $w
	raise $w
	return
    }
    toplevel $w -relief raised -class Postilion
    wm title $w $t(about)
    wm minsize $w 1 1

    label $w.postilion -text "Postilion v$postilion_version" \
	-font "-Adobe-Helvetica-Bold-R-Normal--24-*"
    label $w.date -text $postilion_version_date \
	-font "-Adobe-Helvetica-Bold-R-Normal--12-*"
    label $w.version -text "TkRat is copyright 1995,1996,1997 by" \
	-font "-Adobe-Helvetica-Bold-R-Normal--12-*"
    label $w.author -text "Martin Forssn (maf@math.chalmers.se)" \
	-font "-Adobe-Helvetica-Bold-R-Normal--12-*"
    label $w.postver -text "Postilion is copyright 1997 by" \
	-font "-Adobe-Helvetica-Bold-R-Normal--12-*"
    label $w.postauth -text "Nic Bernstein (nic@postilion.org)" \
	-font "-Adobe-Helvetica-Bold-R-Normal--12-*"
    message $w.more -text $t(send_bugs_etc) -aspect 700
    text $w.text -relief flat -width 40 -height 8 \
	-font "-Adobe-Helvetica-Bold-R-Normal--12-*"
    $w.text insert 1.0 $t(send_postcards)

    button $w.ok \
	-text $t(ok) \
	-command "RecordPos $w about; destroy $w" \
	-width 20

    pack $w.postilion \
	$w.date \
	$w.version \
	$w.author \
	$w.postver \
	$w.postauth \
	$w.more \
	$w.text \
	$w.ok -side top -padx 5 -pady 5
    Place $w about
}

# Ratatosk --
#
# Opens a window an displays a short text about ratatosk in it
#
# Arguments:

proc Ratatosk {} {
    global t

    set w .ratatosk

    if [winfo exists $w] {
	wm deiconify $w
	raise $w
	return
    }
    toplevel $w -relief raised -class Postilion
    wm title $w Ratatosk
    wm minsize $w 1 1

    button $w.ok \
            -text $t(ok) \
            -command "RecordPos $w ratatosk; destroy $w" \
            -width 20

    message $w.message -aspect 400 -text $t(ratatosk)
    pack $w.message $w.ok -side top -padx 5 -pady 5
    Place $w ratatosk
}

# Postilion --
#
# Opens a window an displays a short text about postilion and the 
# postal horn  in it
#
# Arguments:

proc Postilion {} {
    global t

    set w .posthorn

    if [winfo exists $w] {
	wm deiconify $w
	raise $w
	return
    }
    toplevel $w -relief raised -class Postilion
    wm title $w "Postilion and the Postal Horn"

    button $w.ok \
            -text $t(ok) \
            -command "destroy $w" \
            -width 20

    message $w.message -aspect 400 -text $t(posthorn)
    pack $w.message $w.ok -side top -padx 5 -pady 5
}

# InfoWelcome --
#
# This is called when the user invokes postilion for the first time and
# shows a welcome message to the user. In this window the user may chose
# user interface language and whether changes info should be displayed.
#
# Arguments:

proc InfoWelcome {} {
    global b option changes welcomeLanguage

    # Init messages
    InitMessages $option(language) changes

    # Create window
    toplevel .welcome -class Postilion
    wm title .welcome $changes(welcome_title)

    # Populate window
    frame .welcome.message
    text .welcome.message.text -relief sunken -bd 1 \
	    -yscrollcommand ".welcome.message.scroll set" -setgrid 1 \
	    -height 30 -width 80 -highlightthickness 0
    scrollbar .welcome.message.scroll -relief sunken -bd 1 \
	    -command ".welcome.message.text yview" -highlightthickness 0
    # Scroll mouse support added by Stephen Ryan 14 Oct 1999
    bind .welcome.message.text <5> \
	    [list .welcome.message.text yview scroll 5 units]
    bind .welcome.message.text <4> \
	    [list .welcome.message.text yview scroll -5 units]
    bind .welcome.message.text <Shift-5> \
	    [list .welcome.message.text yview scroll 1 units]
    bind .welcome.message.text <Shift-4> \
	    [list .welcome.message.text yview scroll -1 units]
    bind .welcome.message.text <Control-5> \
	    [list .welcome.message.text yview scroll 1 pages]
    bind .welcome.message.text <Control-4> \
	    [list .welcome.message.text yview scroll -1 pages]
    pack .welcome.message.scroll -side left -fill y
    pack .welcome.message.text -expand 1 -fill both
    .welcome.message.text insert 0.0 $changes(welcome)
    .welcome.message.text configure -state disabled

    frame .welcome.b
    frame .welcome.b.lang
    label .welcome.b.lang.label -textvariable changes(language)
    menubutton .welcome.b.lang.menu -textvariable welcomeLanguage \
	    -indicatoron 1 -menu .welcome.b.lang.menu.m -relief raised -bd 1 \
	    -width 20 -anchor c
    menu .welcome.b.lang.menu.m -tearoff 0
    pack .welcome.b.lang.menu \
	 .welcome.b.lang.label -side right
    set b(.welcome.b.lang.menu) welcome_lang

    frame .welcome.b.shutup
    label .welcome.b.shutup.label -textvariable changes(show_changes)
    menubutton .welcome.b.shutup.menu -textvariable welcomeChanges \
	    -indicatoron 1 -menu .welcome.b.shutup.menu.m -relief raised -bd 1 \
	    -width 20 -anchor c
    menu .welcome.b.shutup.menu.m -tearoff 0
    pack .welcome.b.shutup.menu \
	 .welcome.b.shutup.label -side right
    set b(.welcome.b.shutup.menu) welcome_shutup

    button .welcome.b.cont -textvariable changes(continue) -bd 1 \
	    -command {destroy .welcome} -default active
    pack .welcome.b.lang \
	 .welcome.b.shutup -side top -fill x -pady 4
    pack .welcome.b.cont -side top -pady 10
    set b(.welcome.b.cont) welcome_cont

    bind .welcome <Return> {destroy .welcome}
    pack .welcome.message -side top -expand 1 -fill both -padx 5 -pady 5
    pack .welcome.b

    set i 0
    foreach l [GetLanguages] {
	if ![string length [GetFont [lindex $l 2] 0 {}]] {
	    continue
	}
	.welcome.b.lang.menu.m add command -label [lindex $l 1] \
		-command [list WelcomeLanguage $l]
	if [RatEncodingCompat [lindex $l 2] $option(charset)] {
	    set font [.welcome.b.lang.label cget -font]
	} else {
	    set font [GetFont [lindex $l 2] 0 bold]
	}
	.welcome.b.lang.menu.m entryconfigure $i -font $font
	incr i
	if ![string compare [lindex $l 0] $option(language)] {
	    WelcomeLanguage $l
	}
    }

    Place .welcome welcome
    tkwait window .welcome

    foreach bn [array names b .welcome.*] {unset b($bn)}
}


# WelcomeShowMenu --
#
# Build the menu which asks the user if they want to see changes messages.
#
# Arguments:
# font - which font to use (if not the default one)

proc WelcomeShowMenu {{font {}}} {
    global option changes welcomeChanges

    set m .welcome.b.shutup.menu.m
    $m delete 0 end
    if $option(info_changes) {
	set welcomeChanges $changes(show)
    } else {
	set welcomeChanges $changes(dont_show)
    }

    $m add command -label $changes(show) \
	    -command "set welcomeChanges [list $changes(show)] ; \
		      set option(info_changes) 1"
    $m add command -label $changes(dont_show) \
	    -command "set welcomeChanges [list $changes(dont_show)] ; \
		      set option(info_changes) 0"
    if [string length $font] {
	$m entryconfigure 0 -font $font
	$m entryconfigure 1 -font $font
    }
}


# WelcomeLanguage --
#
# Is called when the user changes the language in the welcome window.
#
# Arguments:
# lang -	The language information

proc WelcomeLanguage {lang} {
    global welcomeLanguage option changes defaultFont

    set font [GetFont [lindex $lang 2] 0 bold]
    set welcomeLanguage [lindex $lang 1]
    set option(language) [lindex $lang 0]
    InitMessages $option(language) changes
    wm title .welcome $changes(welcome_title)
    .welcome.message.text configure -state normal \
	    -font [GetFont [lindex $lang 2] 0 {}]
    .welcome.message.text delete 0.0 end
    .welcome.message.text insert 0.0 $changes(welcome)
    .welcome.message.text configure -state disabled
    if [RatEncodingCompat [lindex $lang 2] $option(charset)] {
	foreach w {.welcome.b.lang.label .welcome.b.lang.menu 
		   .welcome.b.shutup.label .welcome.b.shutup.menu
		   .welcome.b.cont} {
	    $w configure -font [$w cget -font]
	}
	WelcomeShowMenu
    } else {
	foreach w {.welcome.b.lang.label .welcome.b.lang.menu 
		   .welcome.b.shutup.label .welcome.b.shutup.menu
		   .welcome.b.cont} {
	    $w configure -font $font
	}
	WelcomeShowMenu $font
    }
}


# InfoChanges --
#
# Inform the user of the changes to the program since the last time it
# was run.
#
# Arguments:

proc InfoChanges {} {
    global option changes changesDone changesChanges \
	   postilion_version postilionHistory b

    # Init messages
    InitMessages $option(language) changes
    set handler .changes
    # Create window
    toplevel $handler -class Postilion
    wm title $handler $changes(changes_title)
    upvar #0 $handler fh
    set fh(w) $handler

    # Message part
    frame $handler.message
    text $handler.message.text -relief sunken -bd 1 \
	    -yscrollcommand ".changes.message.scroll set" -setgrid 1 \
	    -height 30 -width 80 -highlightthickness 0
    set fh(text) $handler.message.text
    scrollbar $handler.message.scroll -relief sunken -bd 1 \
	    -command ".changes.message.text yview" -highlightthickness 0
    pack $handler.message.scroll -side left -fill y
    pack $handler.message.text -expand 1 -fill both
    # Scroll mouse support added by Stephen Ryan 14 Oct 1999
    bind $handler.message.text <5> \
	    [list $handler.message.text yview scroll 5 units]
    bind $handler.message.text <4> \
	    [list $handler.message.text yview scroll -5 units]
    bind $handler.message.text <Shift-5> \
	    [list $handler.message.text yview scroll 1 units]
    bind $handler.message.text <Shift-4> \
	    [list $handler.message.text yview scroll -1 units]
    bind $handler.message.text <Control-5> \
	    [list $handler.message.text yview scroll 1 pages]
    bind $handler.message.text <Control-4> \
	    [list $handler.message.text yview scroll -1 pages]

    # Populate textwindow
    set starts "********************"
    set i [expr [lsearch -exact $postilionHistory $option(last_version)]+1]
    foreach ver [lrange $postilionHistory $i end] {
	$handler.message.text insert end "$starts $changes(changes_in) $ver $starts\n"
	$handler.message.text insert end $changes($ver)
	$handler.message.text insert end "\n\n\n"
    }
    $handler.message.text configure -state disabled

    # Buttons
    frame $handler.b
    frame $handler.b.shutup
    label $handler.b.shutup.label -textvariable changes(show_changes)
    menubutton $handler.b.shutup.menu -textvariable changesChanges \
	    -indicatoron 1 -menu $handler.b.shutup.menu.m -relief raised -bd 1 \
	    -width 20 -anchor c
    menu $handler.b.shutup.menu.m -tearoff 0
    pack $handler.b.shutup.menu \
	 $handler.b.shutup.label -side right
    if $option(info_changes) {
	set changesChanges $changes(show)
    } else {
	set changesChanges $changes(dont_show)
    }
    $handler.b.shutup.menu.m add command -label $changes(show) \
	    -command "set changesChanges [list $changes(show)] ; \
		      set option(info_changes) 1"
    $handler.b.shutup.menu.m add command -label $changes(dont_show) \
	    -command "set changesChanges [list $changes(dont_show)] ; \
		      set option(info_changes) 0"
    set b($handler.b.shutup.menu) welcome_shutup

    RatBind $fh(w) folder_key_pagedown  "ShowPageDown $fh(text)"
    RatBind $fh(w) folder_key_pageup    "ShowPageUp $fh(text)"

    button $handler.b.cont -textvariable changes(continue) -bd 1 \
	    -command {RecordPos .changes infoChanges; destroy .changes}
    pack $handler.b.shutup -side top -pady 4
    pack $handler.b.cont -side top -pady 10
    set b($handler.b.cont) welcome_cont
    
    pack $handler.message -side top -expand 1 -fill both -padx 5 -pady 5
    pack $handler.b

    Place $handler infoChanges
    tkwait window $handler

    foreach bn [array names b .welcome.*] {unset b($bn)}
}

# SeeLog --
#
# Shows the remebered old log messages
#
# Arguments:
# parent  - the parent of this window

proc SeeLog {parent} {
    global idCnt t

    # Create identifier
    set id messageLog[incr idCnt]
    set w .$id

    # Create toplevel
    toplevel $w -class Postilion
    wm title $w $t(seelog_title)
    wm transient $w [winfo toplevel $parent]

    # Message part
    button $w.button -text $t(close) -command "RecordPos $w seeLog; \
	    RecordSize $w.list seeLog; destroy $w"
    listbox $w.list -yscroll "$w.scroll set" -relief sunken -bd 1 \
	    -selectmode extended
    Size $w.list seeLog
    scrollbar $w.scroll -relief raised -bd 1 \
	    -command "$w.list yview"
    # Scroll mouse support added by Stephen Ryan 14 Oct 1999
    bind $w.list <5> [list $w.list yview scroll 5 units]
    bind $w.list <4> [list $w.list yview scroll -5 units]
    bind $w.list <Shift-5> [list $w.list yview scroll 1 units]
    bind $w.list <Shift-4> [list $w.list yview scroll -1 units]
    bind $w.list <Control-5> [list $w.list yview scroll 1 pages]
    bind $w.list <Control-4> [list $w.list yview scroll -1 pages]
    pack $w.button -side bottom -padx 5 -pady 5
    pack $w.scroll -side left -fill y
    pack $w.list -expand 1 -fill both

    foreach m [GetRatLog] {
	$w.list insert end $m
    }

    Place $w seeLog
}

# SendBugReport --
#
# Construct a skeleton bug report
#
# Arguments:
# attachments - List of extra attachments. The argument is a list of lists
#               which looks like {name data}

proc SendBugReport {{attachments {}}} {
    global idCnt option t  postilion_version postilion_version_date \
	   tcl_version tk_version tcl_patchLevel tk_patchLevel

    set mhandler composeM[incr idCnt]
    set ahandler composeB[incr idCnt]
    upvar #0 $mhandler mh

    set mh(to) nic@postilion.org
    set mh(subject) "Postilion $postilion_version bug: \[$t(short_description)\]"
    set mh(description) "Bug report"
    set mh(data) $t(bug_report_template)
    set mh(whence) "bug"

    foreach a $attachments {
	set ahandler composeB[incr idCnt]
	upvar #0 $ahandler ah
 
	lappend mh(attachmentList) $ahandler
	set ah(type) text
	set ah(subtype) plain
	set ah(description) [lindex $a 0]
	set ah(filename) [RatTildeSubst $option(send_cache)/rat.[RatGenId]]
	set ah(removeFile) 1
	set fh [open $ah(filename) w 0600]
	puts $fh [lindex $a 1]
	close $fh
    }
    
    set ahandler composeB[incr idCnt]
    upvar #0 $ahandler ah
    lappend mh(attachmentList) $ahandler

    set ah(type) text
    set ah(subtype) plain
    set ah(description) $t(configuration_information)
    set ah(filename) [RatTildeSubst $option(send_cache)/rat.[RatGenId]]
    set ah(removeFile) 1
    set fh [open $ah(filename) w 0600]
    catch {exec uname -a} uname
    puts $fh "uname -a: '$uname'"
    puts $fh "Version: $postilion_version ($postilion_version_date)"
    puts $fh "Tcl/Tk: $tcl_version/$tk_version ($tcl_patchLevel/$tk_patchLevel)"
    foreach n [lsort [array names tcl_platform]] {
	puts $fh "tcl_platform($n): '$tcl_platform($n)'"
    }
    foreach n [lsort [array names option]] {
	puts $fh "option($n): '$option($n)'"
}

# RatWarn --
#
# Warn user about something
#
# Arguments:
# tag - Tag describing the warning

proc RatWarn {tag} {
    global idCnt t option

    # Create identifier
    set id warning[incr idCnt]
    set w .$id
    set option($tag) 0

    # Create toplevel
    toplevel $w -class Postilion
    wm title $w $t(warning)

    # Message part
    message $w.msg -justify left -text $t($tag) -aspect 600 \
	    -relief raised -bd 1 -padx 5 -pady 5
    checkbutton $w.but -text $t(do_not_show_again) -variable option($tag) \
	    -onvalue 0 -offvalue 1
    button $w.dismiss -text $t(dismiss) -command \
	    "RecordPos $w warning; destroy $w"
    pack $w.msg -side top
    pack $w.but -side top -anchor w -pady 5 -padx 5
    pack $w.dismiss -pady 5

    Place $w warning

    tkwait window $w
    }
    close $fh

    DoCompose $mhandler dummy 0 1
}
