# clock.tcl --
#
# This file contains the code which handles the clock display of message time/date
#
#  Postilion software and its included text and images
#  Copyright (C) 1998 Nic Bernstein
#
#  And modified by Jun Wakaya on 21st. Apr.1999.
#
#  The full text of the legal notices is contained in the file called
#  COPYING, included with this distribution.
#
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2
#  of the License, or (at your option) any later version.
# 
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

proc ClkInitFrame {frame type tile year} {
	set xOs 0;set yOs 0
	set pX 57;set pY 58

	if {$tile=="true"} {
		$canvas create image 0 0 -image tile -anchor nw
		set xOs 4;set yOs 3

		set pX 64;set pY 64
	}

	if {$year=="true"} {
		incr pY 16
	}

	set canvas [canvas $frame.clock -width $pX -height $pY -takefocus no]
	upvar #0 $canvas clkprt

	set clkprt(clock) [$canvas create image $xOs $yOs -image mask -anchor nw]

	if ![string compare $type 12] {
		# This is for 12 hour mode, with am/pm indicator
		set clkprt(led1) [$canvas create image [expr 1+$xOs] [expr 3+$yOs] -anchor nw]
		set clkprt(led2) [$canvas create image [expr 10+$xOs] [expr 3+$yOs] -anchor nw]
		set clkprt(ledcol) [$canvas create image [expr 19+$xOs] [expr 3+$yOs] -anchor nw]
		set clkprt(led3) [$canvas create image [expr 22+$xOs] [expr 3+$yOs] -anchor nw]
		set clkprt(led4) [$canvas create image [expr 31+$xOs] [expr 3+$yOs] -anchor nw]
		set clkprt(ampm) [$canvas create image [expr 54+$xOs] [expr 3+$yOs] -anchor ne]
	} else {
		# This is for 24 hour mode
		set clkprt(led1) [$canvas create image [expr 6+$xOs] [expr 3+$yOs] -anchor nw]
		set clkprt(led2) [$canvas create image [expr 15+$xOs] [expr 3+$yOs] -anchor nw]
		set clkprt(ledcol) [$canvas create image [expr 24+$xOs] [expr 3+$yOs] -anchor nw]
		set clkprt(led3) [$canvas create image [expr 29+$xOs] [expr 3+$yOs] -anchor nw]
		set clkprt(led4) [$canvas create image [expr 38+$xOs] [expr 3+$yOs] -anchor nw]
	}

	set clkprt(day) [$canvas create image [expr 16+$xOs] [expr 21+$yOs] -anchor nw]
	set clkprt(date1) [$canvas create image [expr 18+$xOs] [expr 30+$yOs] -anchor nw]
	set clkprt(date2) [$canvas create image [expr 27+$xOs] [expr 30+$yOs] -anchor nw]
	set clkprt(mon) [$canvas create image [expr 16+$xOs] [expr 45+$yOs] -anchor nw]
	set clkprt(type) $type

	if {$year=="true"} {
		set clkprt(year) [$canvas create text [expr 16+$xOs] [expr 56+$yOs] -anchor nw]
	}

	pack $canvas -side bottom

	return $canvas
}

proc ClkSetTime {shtime canvas} {
	upvar #0 $canvas clkprt

	if {$shtime >= 1} {
		set ftime [clock format $shtime -format {%b %a %p %I %H %M %d %Y}]
	} else {
		set ftime [list jan mon am 00 00 00 00 1971]
	}
	set mon [string tolower [lindex $ftime 0]]
	set day [string tolower [lindex $ftime 1]]
	if ![string compare $clkprt(type) 12] {
		set ampm [string tolower [lindex $ftime 2]]
	        set led1 [string index [lindex $ftime 3] 0]
	        set led2 [string index [lindex $ftime 3] 1]
	} else {
	        set led1 [string index [lindex $ftime 4] 0]
	        set led2 [string index [lindex $ftime 4] 1]
	}
	set led3 [string index [lindex $ftime 5] 0]
	set led4 [string index [lindex $ftime 5] 1]
	set date1 [string index [lindex $ftime 6] 0]
	set date2 [string index [lindex $ftime 6] 1]
	set year [lindex $ftime 7]

	$canvas itemconfigure $clkprt(mon) -image $mon
	$canvas itemconfigure $clkprt(day) -image $day
	$canvas itemconfigure $clkprt(led1) -image led$led1
	$canvas itemconfigure $clkprt(led2) -image led$led2
	$canvas itemconfigure $clkprt(led3) -image led$led3
	$canvas itemconfigure $clkprt(led4) -image led$led4
	if ![string compare $clkprt(type) 12] {
		$canvas itemconfigure $clkprt(ampm) -image led$ampm
	}
	$canvas itemconfigure $clkprt(date1) -image date$date1
	$canvas itemconfigure $clkprt(date2) -image date$date2
	$canvas itemconfigure $clkprt(ledcol) -image ledcol

	$canvas itemconfigure $clkprt(year) -text $year
}

#source ./NeXTClockIcons.tcl

#frame .test
#pack .test
#set mine [ClkInitFrame .test 24 true false]
#ClkSetTime [clock seconds] $mine 
