/*
 *	%W%	(TriChlor) %G% %U%
 */

#ifndef _VNTYPE_H_
#define _VNTYPE_H_

#ifndef _MSDOS
#ifndef _WINDOWS
/* Undo the effect of ctype.h to silence compiler warnings */
#undef	_U
#undef	_L
#undef	_N
#undef	_S
#undef	_P
#undef	_C
#undef	_X
#undef	_B

/* Types enumerated in Viet-Std locale */
#undef	isupper
#undef	islower
#undef	isdigit
#undef	isspace
#undef	ispunct
#undef	iscntrl
#undef	isxdigit
#undef	isblank

#undef	toupper
#undef	tolower

/* Types not enumerated in Viet-Std locale */
#undef	isascii
#undef	isalpha
#undef	isalnum
#undef	isprint
#undef	isgraph

#undef toascii
#endif /* _WINDOWS */
#endif /* _MSDOS */


/* Definitions overriding ctype.h */
#ifndef _uchar
#define	_uchar	unsigned char
#endif

#define	_U	0x01	/* Upper case */
#define	_L	0x02	/* Lower case */
#define	_N	0x04	/* Numeral (digit) */
#define	_S	0x08	/* Spacing character */
#define _P	0x10	/* Punctuation */
#define _C	0x20	/* Control character */
#define _X	0x40	/* Hexadecimal */
#define _B	0x80	/* Blank */

/* Special types */
#define	_V	0x100	/* Vowel */
#define	_M	0x200	/* Modifier (breve,circumflex,horn) */
#define	_A	0x400	/* Accent (acute,grave,hook above,tilde,dot below) */
#define	_Med	0x800	/* Modified vowel */
#define	_Aed	0x1000	/* Accented vowel */

extern	unsigned int	_pvntype[];
extern	unsigned char	_vntoupper[];
extern	unsigned char	_vntolower[];

/* Types enumerated in Viet-Std locale */
#define	isupper(c)	(_pvntype[(_uchar)(c)]&_U)
#define	islower(c)	(_pvntype[(_uchar)(c)]&_L)
#define	isdigit(c)	(_pvntype[(_uchar)(c)]&_N)
#define	isspace(c)	(_pvntype[(_uchar)(c)]&_S)
#define ispunct(c)	(_pvntype[(_uchar)(c)]&_P)
#define iscntrl(c)	(_pvntype[(_uchar)(c)]&_C)
#define	isxdigit(c)	(_pvntype[(_uchar)(c)]&_X)
#define	isblank(c)	(_pvntype[(_uchar)(c)]&_B)

#define	toupper(c)	(_vntoupper[(_uchar)(c)])
#define	tolower(c)	(_vntolower[(_uchar)(c)])

/* Types not enumerated in Viet-Std locale */
#define isascii(c)	((unsigned)(c)<=0177)
#define	isalpha(c)	(_pvntype[(_uchar)(c)]&(_U|_L))
#define isalnum(c)	(_pvntype[(_uchar)(c)]&(_U|_L|_N))
#define isprint(c)	(_pvntype[(_uchar)(c)]&(_P|_U|_L|_N|_B))
#define isgraph(c)	(_pvntype[(_uchar)(c)]&(_P|_U|_L|_N))

#define toascii(c)	((c)&0177)

/* Special types */
#define	isvowel(c)	(_pvntype[(_uchar)(c)]&_V)
#define	isconsonant(c)	(isalpha(c) && !(_pvntype[(_uchar)(c)]&_V))
#define	ismodifier(c)	(_pvntype[(_uchar)(c)]&_M)
#define	isaccent(c)	(_pvntype[(_uchar)(c)]&_A)
#define	isdiacritic(c)	(ismodifier(c) || isaccent(c))
#define	ismodified(c)	(_pvntype[(_uchar)(c)]&_Med)
#define	isaccented(c)	(_pvntype[(_uchar)(c)]&_Aed)
/* We need a Presidential Pardon for "diacriticized" */
#define	isdiacriticized(c)	(ismodified(c) || isaccented(c))

#endif /* _VNTYPE_H_ */
