proc binder_folderList {dir} {
	global panelColor stageColor stageWidth stageHeight
	global frameWidth frameHeight itemWidth itemHeight binder_title
	global binder_fStat

	set dir [file nativename $dir]

	set c .binder_container.folderS

	$c delete all

	set pList [file split $dir]

	for {set j 0} {$j<[llength $pList]} {incr j} {

		set absPath {}

		for {set k 0} {$k<=$j} {incr k} {
			set absPath [concat $absPath [lindex $pList $k]]
		}

		set binder_fStat(folderS$j,path) /[join $absPath /]
		set binder_fStat(folderS$j,fName) [file dirname $absPath]
		set binder_fStat(folderS$j,stat) dir

		if {[lindex $absPath $j]==[exec whoami]} {
			set binder_fStat(folderS$j,icn) Home
		} elseif {[lindex $absPath $j]=="home"} {
			set binder_fStat(folderS$j,icn) Homes
		} else {
			set binder_fStat(folderS$j,icn) Folder
		}

		set u $binder_fStat(folderS$j,path)
		if {[file exists $u/.dir.gif]} {
			if {![winfo exists dir$u]} {
				image create photo dir$u -file $u/.dir.gif
			}

			set binder_fStat(folderS$j,icn) dir$u
		}

		if {$j==0} {
			if {$j==[expr [llength $pList]-1]} {
				set tag [binder_showItems $c folderS 0 $j $j \
				[exec uname -n] ComputerOpen.black arrowDisable]
			} else {
				set tag [binder_showItems $c folderS 0 $j $j \
				[exec uname -n] Computer.black arrowDisable]
			}
		} elseif {$j==[expr [llength $pList]-1]} {
			if {[lindex $absPath $j]==[exec whoami]} {
				set tag [binder_showItems $c folderS 0 $j $j \
				[lindex $pList $j] HomeOpen arrowEnable]
			} elseif {[lindex $absPath $j]=="home"} {
				set tag [binder_showItems $c folderS 0 $j $j \
				[lindex $pList $j] Homes arrowEnable]
			} else {
				if {[file exists $u/.opendir.gif]} {
					if {![winfo exists opendir$u]} {
						image create photo opendir$u \
						-file $u/.opendir.gif
					}

					set tag [binder_showItems $c folderS \
					0 $j $j [lindex $pList $j] opendir$u \
					arrowEnable]
				} else {
					set tag [binder_showItems $c folderS \
					0 $j $j [lindex $pList $j] FolderOpen \
					arrowEnable]
				}
			}
		} else {
			set tag [binder_showItems $c folderS 0 $j $j \
				[lindex $pList $j] $binder_fStat(folderS$j,icn) arrowEnable]
		}

		$c bind img$tag <Double-ButtonRelease-1> \
			"binder_common_chDir $binder_fStat($tag,path)"
	}

	$c configure -scrollregion \
		"0 0 [expr ([llength $pList]-1)*$itemWidth+$itemWidth*1.5] 0"

	$c xview moveto 1.0
}

proc binder_makeSkelton {} {
	global env
	global panelColor stageColor panelText stageText
	global stageWidth stageHeight
	global frameWidth frameHeight itemWidth itemHeight binder_title
	global applicon

	wm geometry . [format %dx%d $frameWidth $frameHeight]

	if {$applicon=="true"} {
		wm group . .
	}

	wm command . "Binder.app"

	wm iconname . "Binder v1.0"
	wm protocol . WM_DELETE_WINDOW {binder_exit}


	bind . <Configure> "binder_Configure"
	bind . <ButtonRelease-3> "binder_showPopup %W %X %Y %x %y"

	frame .binder_spacerTop -height 8 -width 100 -relief flat -bd 0 -bg $panelColor
	frame .binder_spacerLeft -width 8 -height 300 -relief flat -bd 0 -bg $panelColor

	frame .binder_container -relief flat -bd 0 -bg $panelColor -width $stageWidth -height [expr $frameHeight-8]

	canvas .binder_container.shortcuts -bg $panelColor -relief flat -bd 0 \
		-width 640 -height 84

	canvas .binder_container.folderS \
		-xscrollcommand ".binder_container.folderScroll set" \
		-bd 2 -relief sunken -height 76 -width 640 -bg $stageColor

	scrollbar .binder_container.folderScroll -command ".binder_container.folderS xview" -orient horizontal

	frame .binder_spacerMiddle -width 50 -height 8 -relief flat -bd 0 -bg $panelColor
	frame .binder_spacerRight -width 8 -height 300 -relief flat -bd 0 -bg $panelColor

	pack .binder_spacerTop   -side top -fill x
	pack .binder_spacerLeft -side left -fill both
	pack .binder_spacerRight -side right -fill both
	pack .binder_container -side right -fill both -expand 1

	pack propagate .binder_container false
	pack .binder_container.shortcuts -in .binder_container -fill both
	pack .binder_container.folderS -in .binder_container -fill both
	pack .binder_container.folderScroll -in .binder_container -fill x
	pack .binder_spacerMiddle -in .binder_container -fill y

	return .binder_container.folderS
}

