#!/bin/sh
# the next line restarts using wish \
exec wishstep8.0jp "$0" "$@"


set ttblibPath "/usr/X11R6/JDE/Binder"
set panelColor #c0c0c0;set stageColor #c0c0c0
set frameWidth 640;set frameHeight 480
set itemWidth 128;set itemHeight 64
set binder_title FileViewer
set binder_browseMode iconMode
set binder_startupDir $env(HOME)
set binder_currentDir $binder_startupDir
set LANG en
set binder_upDateInterval 30000
set autoUpdateFlagDefault true
set autoUpdateFlag $autoUpdateFlagDefault
set applicon true

set ttbdefPath "~/GNUstep/Defaults"
set GLPath "~/GNUstep/Library/Binder"

if {![file exists "$ttbdefPath/Binder"]} {
	file mkdir $ttbdefPath
	file copy -force -- $ttblibPath/defaults/Binder $ttbdefPath

	file mkdir "$GLPath"
	file copy -force -- $ttblibPath/lib/appInfo $GLPath
	file copy -force -- $ttblibPath/lib/shortcut $GLPath
	file copy -force -- $ttblibPath/lib/suffix.if2 $GLPath
	file mkdir "$GLPath/Icons"
}

source $ttbdefPath/Binder

set stageWidth [expr $frameWidth-32]
set stageHeight [expr $frameHeight-200]

set binder_JBm $ttblibPath/modules
source $binder_JBm/prefBinder$LANG.m
source $binder_JBm/system.m
source $binder_JBm/title.$LANG
source $binder_JBm/readIcons.m
source $binder_JBm/versionCheck.m
source $binder_JBm/dLister.m
source $binder_JBm/fileMan.m
source $binder_JBm/if2.m
source $binder_JBm/listMode.m
source $binder_JBm/appIconInfo.m
source $binder_JBm/iconMode.m
source $binder_JBm/iconCommon.m
source $binder_JBm/itemSelect.m
source $binder_JBm/listboxEx.m
source $binder_JBm/shortCut.m
source $binder_JBm/skelton.m
source $binder_JBm/menu.m
source $binder_JBm/inspector$LANG.m
source $binder_JBm/filter$LANG.m
source $binder_JBm/clock.m
source $binder_JBm/clockIcon.m

TkStep_check

binder_readIconSet
binder_makeSkelton
binder_shortCut
binder_folderList $binder_startupDir
binder_$binder_browseMode $binder_startupDir {}
after $binder_upDateInterval binder_SequencialUpDate

