set binder_dLister_list {}
set binder_dLister_dlist {}
set binder_dLister_flist {}
set binder_dlist_Length 0

proc binder_dLister_makedLists {wd mode} {
	global binder_dLister_dlist

	set nwd [pwd]
	cd $wd

	set binder_dLister_list {}
	catch [set binder_dLister_list "[glob .*] [glob *]"]
	set binder_dLister_dlist {}

	foreach i $binder_dLister_list {
		if {[file isdirectory $i]} {
			if {$mode == 1} {if {$i !=".."} {if {$i !="."} {
				set binder_dLister_dlist \
					"$binder_dLister_dlist $i"
			}}} else {
				set binder_dLister_dlist \
					"$binder_dLister_dlist $i"
			}
		}
	}

	set binder_dLister_dlist [lsort $binder_dLister_dlist]

	cd $nwd
}

proc binder_dLister_makefLists {wd} {
	global binder_dLister_flist

	set nwd [pwd]
	cd $wd

	set binder_dLister_list {}
	catch [set binder_dLister_list "[glob .*] [glob *]"]
	set binder_dLister_flist {}

	foreach i $binder_dLister_list {
		if {![file isdirectory $i]} {
			set binder_dLister_flist "$binder_dLister_flist $i"
		}
	}

	set binder_dLister_flist [lsort $binder_dLister_flist]

	cd $nwd
}

#
# filtering and sorting
#

proc binder_dLister_filtering {list binder_dLister_filtMode} {
        global binder_dLister_list binder_dLister_dlist binder_dLister_flist

	set tmp $list
	set list {}

	switch $binder_dLister_filtMode {

		"0" {
			set list $tmp
		}

		"1" {
			foreach i $tmp {
				if {[string index $i 0]!="."} {
					set list [concat $list $i]
				} elseif {$i==".."} {
					set list [concat $list $i]
				}
			}
		}

		"2" {
			foreach i $tmp {
				if {[string index $i 0]!="."} {
					if {[string range $i end end]!="~"} {
						set list "$list $i"
					}
				} elseif {$i==".."} {
					set list [concat $list $i]
				}

			}
		}

		"3" {
			foreach i $tmp { if {[string range $i end end]=="~"} {
				set list "$list $i"
				} elseif {$i==".."} {
					set list [concat $list $i]
				}
			}
		}
	}

	return $list
}

#
# exports
#

proc binder_dLister_getList {wd mode sort filt} {
	global binder_dLister_dlist binder_dLister_flist
	global binder_dlist_Length

	set binder_dlist_Length 0

	switch $sort {
		"0" {
			binder_dLister_makedLists $wd $mode
			binder_dLister_makefLists $wd
			return [binder_dLister_filtering \
				"$binder_dLister_dlist $binder_dLister_flist" $filt]
		}

		"1" {
			binder_dLister_makefLists $wd
			binder_dLister_makedLists $wd $mode
			return [binder_dLister_filtering \
				"$binder_dLister_flist $binder_dLister_dlist" $filt]
		}
	}
}

