global binder_insMode binder_insFName

set binder_insMode {°}
set binder_insFName {}
trace variable binder_insMode w binder_insDisp

proc binder_compUID {uid} {
	set fp [open /etc/passwd r]
	set passwd [split [read -nonewline $fp] \n]
	close $fp

	foreach i $passwd {
		set temp [split $i :]
		if {[lindex $temp 2]=="$uid"} {
			return [lindex $temp 0]
		}
	}
}

proc binder_compGID {gid} {
	set fp [open /etc/group r]
	set group [split [read -nonewline $fp] \n]
	close $fp

	foreach i $group {
		set temp [split $i :]
		if {[lindex $temp 2]=="$gid"} {
			return [lindex $temp 0]
		}
	}
}

proc binder_inspectorMain {} {
	global binder_insFName panelColor

	wm title .perm "°󥹥ڥ"

	file lstat $binder_insFName fstat

	if {[winfo exists .perm.bottom]} {
		destroy .perm.bottom
	}

	set width [winfo width .perm]

	pack [frame .perm.bottom -bg $panelColor -relief flat -bd 0 \
		-width $width] -fill both -padx 10 -expand 1

	frame .perm.bottom.l -bg $panelColor -relief flat -height 48 \
		-bd 10 -bg $panelColor -width $width


	pack .perm.bottom.l -side bottom -fill both
	button .perm.bottom.l.ok -bg $panelColor -default active \
		-text ϣ -width 14 -command "binder_inspector_exit .perm"
	button .perm.bottom.l.resume -bg $panelColor -default normal \
		-state disabled -text ᤹ -width 16

	pack .perm.bottom.l.ok .perm.bottom.l.resume \
		-side right -anchor n -padx 5 -fill both

	pack [frame .perm.bottom.f -relief flat -bg $panelColor -height 160] \
		-fill both -side bottom

	pack [frame .perm.bottom.f.f0 -height 96 -width 200 \
		-relief groove -bd 2 -text "ѡߥå" -bg $panelColor] -side left

	pack [frame .perm.bottom.f.f1 -height 96 -width 72 \
		-relief groove -bd 2 -text "ѹ" \
		-bg $panelColor] \
		-expand 1 -side right

	pack propagate .perm.bottom.f.f1 false

	set mine [ClkInitFrame .perm.bottom.f.f1 24 false true]
	ClkSetTime $fstat(mtime) $mine

	pack [text .perm.bottom.t -height 14 -width 24 -relief flat -bg $panelColor] \
		-side left

	pack [button .perm.bottom.b -image FolderRulerE -bg $panelColor] \
		-side right

	.perm.bottom.t insert end "\n\nLink:\n\n\n\n"
	.perm.bottom.t insert end "\t"

	if {[file isfile $binder_insFName]} {
		.perm.bottom.t insert end "$fstat(size) Х"
		.perm.bottom.b configure -state disabled
	}

	.perm.bottom.t insert end "\n\n"
	.perm.bottom.t insert end "ʡ\t[binder_compUID $fstat(uid)]\n\n"
	.perm.bottom.t insert end "롼ס\t[binder_compGID $fstat(gid)]"

	.perm.bottom.t configure -state disabled
}

proc binder_inspectorIF2_sub {id text} {
	.perm.bottom.f1.lb$id configure -text $text
}

proc binder_inspector_IF2ok {sufG} {
	set icnName [.perm.bottom.f1.f0.lb1 cget -image]
	set appName [.perm.bottom.f1.lb1 cget -text]
	set edtName [.perm.bottom.f1.lb3 cget -text]
	set optName [.perm.bottom.f2.e0 get]
	set cmtName [.perm.bottom.f3.e0 get]

	if {$edtName!=""} {
		set separator :
	} else {
		set separator {}
	}

	set if2List "$sufG,00,$icnName,$appName$separator$edtName,$optName,$cmtName"

	if2_exchangeIF2 $sufG $if2List
	binder_reDraw
}

proc binder_inspector_IF2_selIcon_sub icnName {
	if {![winfo exists .perm.bottom.f1.f0.lb1]} {
		destroy .insIconL
		return
	}

	.perm.bottom.f1.f0.lb1 configure -image $icnName
	destroy .insIconL
	return
}

proc binder_inspector_IF2_selIcon {} {
	global if2Ext if2Mod if2Icn if2Com if2Opt if2Inf
	global panelColor panelText stageColor stageText

	set tl .insIconL

	if {[winfo exists $tl]} {
		raise $tl
		return
	}

	toplevel $tl
	wm title $tl ""

	grid [scrollbar $tl.sb0 -orient vertical -command "$tl.c0 yview"] \
		-column 0 -row 0 -sticky news

	grid [canvas $tl.c0 -yscrollcommand "$tl.sb0 set"] \
		-column 1 -row 0 -sticky news

	for {set i 0} {$i<[llength [image names]]} {incr i} {
		set temp [lindex [lsort [image names]] $i]

		$tl.c0 create text 16 [expr 80+$i*80] \
			-text $i -tags if$i
		$tl.c0 create image 80 [expr 80+$i*80] \
			-image $temp -tags if$i
		$tl.c0 create text 180 [expr 80+$i*80] \
			-text $temp -tags if$i
		$tl.c0 configure -scrollregion "0 0 0 [expr 128+$i*80]"

		$tl.c0 bind if$i <Double-ButtonRelease-1> "binder_inspector_IF2_selIcon_sub $temp"
	}
}

proc binder_inspectorIF2 {} {
	global binder_insFName panelColor GLPath

	if {[if2_getAppName $binder_insFName]=="None"} {
		destroy .perm
		binder_if2Conf new .[file extension $binder_insFName]
		return
	}

	wm title .perm "ġ륤󥹥ڥ"

	file lstat $binder_insFName fstat

	if {[winfo exists .perm.bottom]} {
		destroy .perm.bottom
	}

	set permICN [if2_getIcon $binder_insFName]
	set permOPT [if2_getOptions $binder_insFName]
	set permCMT [if2_getInfomation $binder_insFName]
	set width [winfo width .perm]

	pack [frame .perm.bottom -bg $panelColor -relief flat -bd 0 \
		-width $width] -fill both -padx 10 -expand 1

	set sufG [if2_getSufNames $binder_insFName]

	pack [label .perm.bottom.l00 -bg $panelColor -fg #777777 \
		-text "Suffix group:\t$sufG"] -fill x

	set appName [lindex [split [if2_getAppName $binder_insFName] :] 0]
	set edtName [lindex [split [if2_getAppName $binder_insFName] :] 1]

	pack [message .perm.bottom.m1 -text \
		"֥륯å\nɥȤ򥪡ץ󤷤ޤ" \
		-width 240 -fg #777777 -bg $panelColor]

	pack [frame .perm.bottom.f0 -width 196 -relief sunken -bd 2]
	pack [canvas .perm.bottom.f0.c0 -height 64 -width 192 \
		-xscrollcommand ".perm.bottom.f0.sb0 set" \
		-bg $panelColor] \
		[scrollbar .perm.bottom.f0.sb0 -command \
		".perm.bottom.f0.c0 xview" -orient horizontal] \
		-fill both

	set appsBuf {};set appNames {};set icnNames {}

	if [file exists $GLPath/appInfo] {
		set fp [open $GLPath/appInfo r]
		set appsBuf [read $fp]
		close $fp

		foreach i [split $appsBuf \n] {
			if {$i!={}} {
				set tmp [split $i \;]
				set appNames [concat $appNames [lindex $tmp 0]]
				set icnNames [concat $icnNames [lindex $tmp 1]]
			}
		}
	}

	set select 0

	for {set i 0} {$i<[llength $appsBuf]} {incr i} {
		.perm.bottom.f0.c0 create rectangle \
			[expr $i*64] 0 [expr 64+$i*64] 64 \
			-fill $panelColor -width 2
		.perm.bottom.f0.c0 create line \
			[expr $i*64] 64 [expr $i*64] 0 [expr 64+$i*64] 0 \
			-fill white
		.perm.bottom.f0.c0 create image \
			[expr 8+$i*64] 8 -anchor nw \
			-image [lindex $icnNames $i] -tags itm$i

		if {$appName==[lindex $appNames $i]} {
			.perm.bottom.f0.c0 create rectangle \
				[expr $i*64] 0 [expr 64+$i*64] 64 -width 0 \
				-fill white -stipple gray50 -tags itm$i

			set select $i
		}

		if {$edtName==[lindex $appNames $i]} {
			.perm.bottom.f0.c0 create rectangle \
				[expr $i*64] 0 [expr 64+$i*64] 64 \
				-fill black -width 0 \
				-stipple gray50 -tags itm$i

			set select $i
		}

		.perm.bottom.f0.c0 configure \
			-scrollregion "0 0 [expr 64+$i*64] 64"

		.perm.bottom.f0.c0 bind itm$i <Double-ButtonPress-1> \
			"exec [lindex $appNames $i]\ $binder_insFName"  

		.perm.bottom.f0.c0 bind itm$i <Double-ButtonPress-2> \
			"exec [lindex $appNames $i]\ $binder_insFName"  

		.perm.bottom.f0.c0 bind itm$i <ButtonRelease-1> \
			"binder_inspectorIF2_sub 1 [lindex $appNames $i]"

		.perm.bottom.f0.c0 bind itm$i <ButtonRelease-2> \
			"binder_inspectorIF2_sub 3 [lindex $appNames $i]"
	}


	pack [frame .perm.bottom.f1 -bd 0 -bg $panelColor] -fill both

	grid [label .perm.bottom.f1.lb0 -text "ץꡧ\t\t" \
		-fg #777777 -bg $panelColor] -column 0 -row 0
	grid [label .perm.bottom.f1.lb1 -text $appName \
		-bg $panelColor] -column 1 -row 0

	grid [label .perm.bottom.f1.lb2 -text "ǥ\t\t\t" \
		-fg #777777 -bg $panelColor] -column 0 -row 1
	grid [label .perm.bottom.f1.lb3 -text $edtName \
		-bg $panelColor] -column 1 -row 1

	grid [label .perm.bottom.f1.lb4 -text "ɸॢץꡧ\t\t" \
		-fg #777777 -bg $panelColor] -column 0 -row 2
	grid [label .perm.bottom.f1.lb5 -text $appName \
		-bg $panelColor] -column 1 -row 2

	grid [label .perm.bottom.f1.lb6 -text "ɸ२ǥ\t\t" \
		-fg #777777 -bg $panelColor] -column 0 -row 3
	grid [label .perm.bottom.f1.lb7 -text $edtName \
		-bg $panelColor] -column 1 -row 3

	grid [frame .perm.bottom.f1.f0 -bd 0 -bg $panelColor \
		-bd 10 -width 96 -height 96] -column 2 -row 0 -sticky news \
		-rowspan 4
	pack [label .perm.bottom.f1.f0.lb0 -bg $panelColor -fg #777777 \
		-text "Icon:"] -fill both -expand 1
	pack [label .perm.bottom.f1.f0.lb1 -bg $panelColor -image $permICN] \
		-side bottom -fill both -padx 20

	bind .perm.bottom.f1.f0.lb1 <Double-ButtonRelease-1> \
		binder_inspector_IF2_selIcon

	pack [frame .perm.bottom.f2 -bd 0 -bg $panelColor] -fill both
	pack [label .perm.bottom.f2.lb0 -text "쥯ȡ\t\t" \
		-fg #777777 -bg $panelColor] -side left -fill both
	pack [entry .perm.bottom.f2.e0 -bg $panelColor \
		-width 16] -side top -fill both

	pack [frame .perm.bottom.f3 -bd 0 -bg $panelColor] -fill both
	pack [label .perm.bottom.f3.lb0 -text "ȡ\t\t" \
		-fg #777777 -bg $panelColor] -side left -fill both
	pack [entry .perm.bottom.f3.e0 -bg $panelColor \
		-width 16] -side top -fill both

	.perm.bottom.f2.e0 insert end $permOPT
	.perm.bottom.f3.e0 insert end $permCMT

	frame .perm.bottom.l -bg $panelColor -relief flat -height 48 \
		-bd 10 -bg $panelColor -width $width

	pack .perm.bottom.l -side bottom -fill both
	button .perm.bottom.l.ok -bg $panelColor -default active \
		-text "ɸ" -width 14 \
		-command "binder_inspector_IF2ok $sufG"
	button .perm.bottom.l.resume -bg $panelColor -default normal \
		-state disabled -text ᤹ -width 16

	pack .perm.bottom.l.ok .perm.bottom.l.resume \
		-side right -anchor n -padx 5 -fill both
}

proc binder_getunixPermission {fileName} {
	set perm [string range [lindex [exec ls -ld $fileName] 0] 1 end]

	for {set j 0} {$j<3} {incr j} {
		for {set i 0} {$i<3} {incr i} {
			global permcheck$i$j

			if {[lindex [split $perm {}] [expr $j*3+$i]] != "-"} {
				.perm.bottom.u.r.u.$i$j.c select
			} else {
				.perm.bottom.u.r.u.$i$j.c deselect
			}
		}
	}
}

proc binder_setunixPermission_sub {fileName} {

	set flag {}

	for {set j 0} {$j<3} {incr j} {
		set permList {}
		for {set i 0} {$i<3} {incr i} {
			global permcheck$i$j
			eval set temp \$permcheck$i$j

			catch [set permList [concat $permList $temp]]
		}

			catch [set flag [concat $flag [expr ([lindex $permList 2]*1)\
				+([lindex $permList 1]*2)+([lindex $permList 0]*4)]]]
	}

	exec chmod [join $flag {}] $fileName

	destroy .perm
}

proc binder_unixPermission {} {

	global binder_insFName panelColor

	if {[winfo exists .perm.bottom]} {
		destroy .perm.bottom
	}

	wm title .perm "գΣɣإѡߥå"

	set width [winfo width .perm]

	frame .perm.bottom -bg $panelColor -relief flat -bd 0 -bg $panelColor -width $width
	frame .perm.bottom.u -bg $panelColor -relief flat -bd 24 -bg $panelColor -width $width
	frame .perm.bottom.u.l -bg $panelColor -bd 4 -relief flat
	label .perm.bottom.u.l.r -bg $panelColor -text ꡼
	label .perm.bottom.u.l.w -bg $panelColor -text 饤
	label .perm.bottom.u.l.x -bg $panelColor -text ¹
	frame .perm.bottom.u.r -bg $panelColor
	frame .perm.bottom.u.r.u -bg $panelColor
	frame .perm.bottom.u.r.l -bg $panelColor
	label .perm.bottom.u.r.l.ow -bg $panelColor -text ʡ
	label .perm.bottom.u.r.l.gr -bg $panelColor -text u롼
	label .perm.bottom.u.r.l.ot -bg $panelColor -text ¾
	frame .perm.bottom.l -bg $panelColor -relief flat -height 48 -bd 10 -bg $panelColor -width $width
	button .perm.bottom.l.ok -bg $panelColor -default active -text ϣ -width 14 \
		-command "binder_setunixPermission_sub $binder_insFName"
	button .perm.bottom.l.resume -bg $panelColor -default normal -text ᤹ -width 16 \
		-command "binder_getunixPermission $binder_insFName"

	pack .perm.bottom -expand 1 -side bottom -fill both
	pack .perm.bottom.u -expand 1 -side top -fill both

	pack .perm.bottom.u.l -side left -fill both
	pack .perm.bottom.u.l.r .perm.bottom.u.l.w .perm.bottom.u.l.x -anchor ne -side top
	pack .perm.bottom.u.r -side left -fill both -expand 1
	pack .perm.bottom.u.r.u .perm.bottom.u.r.l -side top -fill y

	for {set j 0} {$j<3} {incr j} {
		for {set i 0} {$i<3} {incr i} {
			frame .perm.bottom.u.r.u.$i$j -width 48 -height 24 -highlightthickness 0 -relief groove -bd 2 
			grid configure .perm.bottom.u.r.u.$i$j -column $j -row $i -sticky e
			checkbutton .perm.bottom.u.r.u.$i$j.c -relief flat -bd 0 -variable permcheck$i$j
			pack propagate .perm.bottom.u.r.u.$i$j false
			pack .perm.bottom.u.r.u.$i$j.c -in .perm.bottom.u.r.u.$i$j
		}
	}

	pack .perm.bottom.u.r.l.ow .perm.bottom.u.r.l.gr .perm.bottom.u.r.l.ot -anchor ne -side left

	pack .perm.bottom.l -side bottom -fill both

	pack .perm.bottom.l.ok .perm.bottom.l.resume \
		-side right -anchor n -padx 5 -fill both

	binder_getunixPermission $binder_insFName
}

proc binder_insDisp {a b c} {
	global binder_insMode binder_insFName

	if {![winfo exists .perm]} return

	switch $binder_insMode {
		"°" {
			binder_inspectorMain
		}

		"" {
			binder_unixPermission
		}

		"ġ" {
			binder_inspectorIF2
		}
	}
}

proc binder_inspector_exit {tl} {
	global autoUpdateFlag autoUpdateFlagDefault

	set autoUpdateFlag $autoUpdateFlagDefault
	destroy $tl
}

proc binder_showInspector {fileName} {
	global panelColor ttblibPath binder_insMode binder_insFName
	global binder_currentDir
	global autoUpdateFlag

	set autoUpdateFlag false

	if {![winfo exists .perm]} {
		toplevel .perm -bg $panelColor
	} else {
		raise .perm
		return
	}

	wm geometry .perm 320x480
	wm protocol .perm WM_DELETE_WINDOW "binder_inspector_exit .perm"

	set width [winfo width .perm]

	pack \
	[frame .perm.top -bd 5 -relief flat -bg $panelColor -width $width] \
	[frame .perm.line1 -bd 1 -relief sunken -height 2 -width $width] \
	[frame .perm.mid -relief flat -bd 10 -bg $panelColor -width $width \
		-height 96] \
	[frame .perm.line2 -bg $panelColor -bd 1 -relief sunken -height 2 \
		-width $width] -fill both

	if {[file executable $fileName]} {
		tk_optionMenu .perm.top.menu binder_insMode \
			"°" ""
	} elseif {[file isfile $fileName]} {
		tk_optionMenu .perm.top.menu binder_insMode \
			"°" "" "ġ"
	} else {
		tk_optionMenu .perm.top.menu binder_insMode \
			"°" ""
	}

	pack .perm.top.menu -anchor center

	pack [frame .perm.mid.u -bg $panelColor] \
		[frame .perm.mid.l -bg $panelColor] -fill both

	if {[file isdirectory $fileName]} {
		set permICN Folder
	} else {
		if {[file executable $fileName]} {
			set permICN [binder_appIconInfo $fileName]
		} else {
			set permICN [if2_getIcon $fileName]
		}
	}

	pack \
	[label .perm.mid.u.img -bg $panelColor -image $permICN \
		-bd 4 -relief flat] \
	[label .perm.mid.u.fname -bg $panelColor -text [file tail $fileName] \
		-font {Helvetica 18}] -side left -anchor center

	if {[string length $fileName] > 30} {
		set pathList [file split $binder_currentDir]
		set len [llength $pathList]
		set prev ""
		for {set i $len} {1} {incr i -1} {
			set elem [lindex $pathList [expr $i -1]]
			set cur "$elem/$prev"
			if {[string length $cur] > 16} {
				if {$i == $len} { set prev $elem}
				set pathTitle "/.../$prev"
				break;
			}
			set prev $cur
		}
		set pathTitle $pathTitle[file tail $fileName]
	} else {
		set pathTitle  $fileName
	}

	pack [label .perm.mid.l.label -bg $panelColor -text "ѥ"] \
	[label .perm.mid.l.path -bg $panelColor -text $pathTitle] \
	-side left -anchor e

	set binder_insFName $fileName
	binder_insDisp a b c
}








