#!/usr/local/bin/python
#
# adzapper
# Copyright 1999, 2000 Adam Feuer
# Adam Feuer <adamf@pobox.com>
#
# This file is part of adzapper.
#
# adzapper is free software; you can redistribute it and/or modify
# it under the terms of the Python License, as published by the
# Python Software Foundation.
#
# adzapper is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# Python License for more details.
#
# You should have received a copy of the Python License along
# with adzapper; see the file COPYING.
#
#
# this fixes win95/98 problems with the DNS resolver
#
RCS_ID =  '$Id: resolver_fixes.py,v 1.2 2001/09/02 04:47:16 adamf Exp $'

#
# this is the number of seconds until this DNS cache entry expires
#
DEFAULT_TTL = 300

from socket import gethostbyname
import debug

#
# use the regular socket.gethostbyname() resolver for win95/98
#

def my_resolve (self, host, callback):
    self.forward_requests.increment()
    if self.cache.has_key (host):
            when, ttl, answer = self.cache[host]
            # ignore TTL for now
            callback (host, ttl, answer)
            self.cache_hits.increment()
    else:
        answer = gethostbyname(host)
        ttl = DEFAULT_TTL
        self.callback_hook(host, ttl, answer)
        callback(host, ttl, answer)


def my_resolve_ptr (self, host, callback):
    self.reverse_requests.increment()
    if self.cache.has_key (host):
        when, ttl, answer = self.cache[host]
        # ignore TTL for now
        callback (host, ttl, answer)
        self.cache_hits.increment()
    else:
        answer = gethostbyname(host)
        ttl = DEFAULT_TTL
        self.callback_hook(host, ttl, answer)
        callback(host, ttl, answer)
