#
# This file is part of Zaplet
# Copyright 1999 - 2001 Adam Feuer <adamf@pobox.com>
#
# Zaplet is free software; you can redistribute it and/or modify
# it under the terms of the Python License as published by the
# Python Software Foundation, or GNU General Public License as published
# by the Free Software Foundation (either version 2 of the License, or
# (at your option) any later version).
#
# Zaplet is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Zaplet; see the file COPYING-Zaplet. If not, write to the
# Free Software Foundation, Inc.,
# 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
#
# You should have received a copy of the Python License along
# with Zaplet; see the file COPYING.
#
#
# ui/actions.py
# adzapper User Interface - methods
#
# for use with adzapper filtering proxy

# standard modules
import re
import string
import StringIO
import sys
import os

# adzapper modules
from debug import debug

RCS_ID =  '$Id: __init__.py,v 1.4 2001/09/02 04:47:16 adamf Exp $'

program=sys.argv[0]
here=os.path.join(os.getcwd(),os.path.split(program)[0])
DTMLDIR = os.path.join(here,'dtml')

STDHEADER = 'standard-header.dtml'
STDFOOTER = 'standard-footer.dtml'

vars = {}

try:
    file = open(os.path.join(DTMLDIR,STDHEADER))
    vars['std_header'] = file.read()
    file.close
except:
    vars['std_header'] = """
    <html>
      <head>
         <title><dtml-var title></title>
      </head>
      <body BGCOLOR="#FFFFFF"  text="#000000" link="#990000" alink="#660000" vlink="#3333CC">
         <font size=4 face="Arial, sans-serif" color="#000000">
      """
try:
    file = open(os.path.join(DTMLDIR,STDFOOTER))
    vars['std_footer'] = file.read()
    file.close
except:
    vars['std_footer'] = """
       </body>
    </html>
    """
    



