/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jsp;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Hashtable;
import org.gjt.jsp.JspConfig;
import org.gjt.jsp.JspMsg;
import org.gjt.jsp.JspNode;
import org.gjt.jsp.ParseException;

public abstract class Emitter
implements JspMsg {
    private static Hashtable concreteEmitters = new Hashtable();

    public static void setEmitter(String string, Emitter emitter) {
        concreteEmitters.put(string.toLowerCase(), emitter);
    }

    public static Emitter getEmitter(String string) {
        return (Emitter)concreteEmitters.get(string.toLowerCase());
    }

    public static void emit(BufferedWriter bufferedWriter, JspNode jspNode) throws IOException {
        Emitter emitter;
        String string = jspNode.getAttribute("language");
        if (string == null) {
            string = "java";
        }
        if ((emitter = Emitter.getEmitter(string)) == null) {
            throw new ParseException(String.valueOf(JspConfig.getLocalizedMsg(209)) + ": " + string);
        }
        Emitter.emit(emitter, bufferedWriter, jspNode);
    }

    public static void emit(BufferedWriter bufferedWriter, JspNode jspNode, String string) throws IOException {
        Emitter emitter = Emitter.getEmitter(string);
        if (emitter == null) {
            throw new ParseException(String.valueOf(JspConfig.getLocalizedMsg(209)) + ": " + string);
        }
        Emitter.emit(emitter, bufferedWriter, jspNode);
    }

    private static void emit(Emitter emitter, BufferedWriter bufferedWriter, JspNode jspNode) throws IOException {
        if (jspNode == null) {
            return;
        }
        JspNode jspNode2 = null;
        switch (jspNode.getType()) {
            case 1: {
                emitter.emitBeginPage(bufferedWriter, jspNode);
                jspNode2 = jspNode.getFirstChild();
                while (jspNode2 != null) {
                    Emitter.emit(emitter, bufferedWriter, jspNode2);
                    jspNode2 = jspNode2.getNextSibling();
                }
                emitter.emitEndPage(bufferedWriter, jspNode);
                return;
            }
            case 11: {
                emitter.emitIncludeDirective(bufferedWriter, jspNode, jspNode.getAttribute("file"));
                return;
            }
            case 0: {
                emitter.emitTemplateText(bufferedWriter, jspNode, jspNode.getAttribute("text"));
                return;
            }
            case 2: {
                emitter.emitBeginPrintExprCall(bufferedWriter, jspNode);
                emitter.emitPrintExprCall(bufferedWriter, jspNode, jspNode.getFirstChild().getAttribute("text"));
                emitter.emitEndPrintExprCall(bufferedWriter);
                return;
            }
            case 3: {
                emitter.emitBeginScriptlet(bufferedWriter, jspNode);
                emitter.emitScriptlet(bufferedWriter, jspNode, jspNode.getFirstChild().getAttribute("text"));
                emitter.emitEndScriptlet(bufferedWriter);
                return;
            }
            case 4: {
                emitter.emitInclude(bufferedWriter, jspNode, jspNode.getAttribute("page"), jspNode.getAttribute("flush"));
                return;
            }
            case 5: {
                emitter.emitForward(bufferedWriter, jspNode, jspNode.getAttribute("page"));
                return;
            }
            case 6: {
                emitter.emitBeginUseBean(bufferedWriter, jspNode, jspNode.getAttribute("id"), jspNode.getAttribute("scope"), jspNode.getAttribute("type"), jspNode.getAttribute("class"), jspNode.getAttribute("beanName"));
                jspNode2 = jspNode.getFirstChild();
                while (jspNode2 != null) {
                    Emitter.emit(emitter, bufferedWriter, jspNode2);
                    jspNode2 = jspNode2.getNextSibling();
                }
                emitter.emitEndUseBean(bufferedWriter);
                return;
            }
            case 7: {
                emitter.emitGetProperty(bufferedWriter, jspNode, jspNode.getAttribute("name"), jspNode.getAttribute("property"));
                return;
            }
            case 8: {
                emitter.emitSetProperty(bufferedWriter, jspNode, jspNode.getAttribute("name"), jspNode.getAttribute("property"), jspNode.getAttribute("param"), jspNode.getAttribute("value"));
                return;
            }
        }
    }

    protected abstract void emitBeginPage(BufferedWriter var1, JspNode var2) throws IOException;

    protected abstract void emitEndPage(BufferedWriter var1, JspNode var2) throws IOException;

    protected abstract void emitIncludeDirective(BufferedWriter var1, JspNode var2, String var3) throws IOException;

    protected abstract void emitBeginScriptlet(BufferedWriter var1, JspNode var2) throws IOException;

    protected abstract void emitScriptlet(BufferedWriter var1, JspNode var2, String var3) throws IOException;

    protected abstract void emitEndScriptlet(BufferedWriter var1) throws IOException;

    protected abstract void emitBeginPrintExprCall(BufferedWriter var1, JspNode var2) throws IOException;

    protected abstract void emitPrintExprCall(BufferedWriter var1, JspNode var2, String var3) throws IOException;

    protected abstract void emitEndPrintExprCall(BufferedWriter var1) throws IOException;

    protected abstract void emitTemplateText(BufferedWriter var1, JspNode var2, String var3) throws IOException;

    protected abstract void emitInclude(BufferedWriter var1, JspNode var2, String var3, String var4) throws IOException;

    protected abstract void emitForward(BufferedWriter var1, JspNode var2, String var3) throws IOException;

    protected abstract void emitBeginUseBean(BufferedWriter var1, JspNode var2, String var3, String var4, String var5, String var6, String var7) throws IOException;

    protected abstract void emitEndUseBean(BufferedWriter var1) throws IOException;

    protected abstract void emitGetProperty(BufferedWriter var1, JspNode var2, String var3, String var4) throws IOException;

    protected abstract void emitSetProperty(BufferedWriter var1, JspNode var2, String var3, String var4, String var5, String var6) throws IOException;
}

