/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jsp;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.net.URL;
import java.util.Stack;
import java.util.Vector;
import org.gjt.jsp.Pos;

class StackedReader
extends Reader {
    private Stack readers = new Stack();
    private Stack includes = new Stack();
    private Vector visitedIncludes = new Vector();
    private Vector visitedResources = new Vector();
    private LineNumberReader currentReader;
    private String currentInclude;
    private Object contextInfo;

    StackedReader(Reader reader, String string, URL uRL) {
        this.pushReader(reader, string, uRL);
    }

    void setContextInfo(Object object) {
        this.contextInfo = object;
    }

    Object getContextInfo() {
        return this.contextInfo;
    }

    int getLineNumber() {
        return this.currentReader.getLineNumber();
    }

    Pos getPos() {
        return new Pos(this.getCurrentInclude().toString(), this.currentReader.getLineNumber() + 1);
    }

    public void pushReader(Reader reader, String string, URL uRL) {
        if (this.currentReader != null) {
            this.readers.push(this.currentReader);
            this.includes.push(this.currentInclude);
        }
        LineNumberReader lineNumberReader = this.currentReader = reader instanceof LineNumberReader ? (LineNumberReader)reader : new LineNumberReader(reader);
        if (string != null) {
            this.visitedIncludes.addElement(string);
            this.currentInclude = string;
        }
        if (uRL != null) {
            this.visitedResources.addElement(uRL);
        }
    }

    private void pop() {
        this.currentReader = (LineNumberReader)this.readers.pop();
        this.currentInclude = (String)this.includes.pop();
    }

    public String getCurrentInclude() {
        return this.currentInclude;
    }

    public String[] getAllIncludes() {
        Object[] objectArray = new String[this.visitedIncludes.size()];
        this.visitedIncludes.copyInto(objectArray);
        return objectArray;
    }

    public URL[] getAllIncludesAsResources() {
        Object[] objectArray = new URL[this.visitedResources.size()];
        this.visitedResources.copyInto(objectArray);
        return objectArray;
    }

    public final int read() throws IOException {
        if (this.currentReader == null) {
            return -1;
        }
        int n = this.currentReader.read();
        if (n == -1 && !this.readers.empty()) {
            this.currentReader.close();
            this.pop();
            return this.read();
        }
        return n;
    }

    public final int read(char[] cArray) throws IOException {
        return this.read(cArray, 0, cArray.length);
    }

    public final int read(char[] cArray, int n, int n2) throws IOException {
        int n3 = this.currentReader.read(cArray, n, n2);
        if (n3 == -1 && !this.readers.empty()) {
            this.currentReader.close();
            this.pop();
            return this.read(cArray, n, n2);
        }
        return n3;
    }

    public boolean ready() throws IOException {
        return this.currentReader.ready();
    }

    public void reset() throws IOException {
        this.currentReader.reset();
    }

    public void close() throws IOException {
        if (this.currentReader != null) {
            this.currentReader.close();
        }
        if (!this.readers.empty()) {
            this.pop();
        }
    }

    public void mark(int n) throws IOException {
        this.currentReader.mark(n);
    }

    public boolean markSupported() {
        return this.currentReader.markSupported();
    }

    public long skip(long l) throws IOException {
        long l2 = this.currentReader.skip(l);
        if (l2 < l && !this.readers.empty()) {
            this.currentReader.close();
            this.pop();
            return this.currentReader.skip(l - l2);
        }
        return l2;
    }

    public void unread(char[] cArray, int n, int n2) {
        this.pushReader(new CharArrayReader(cArray, n, n2), null, null);
    }
}

