/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jsp.jsdk20;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUtils;
import org.gjt.jsp.JspParserContext;

public class HttpServletRequestWrapper
implements HttpServletRequest {
    private HttpServletRequest req;
    private Hashtable attrs = new Hashtable();
    private String requestAttr;
    private String servletAttr;
    private String pathAttr;
    private String queryAttr;
    private Hashtable extraParams;
    private boolean wrappedWrapper = false;

    public HttpServletRequestWrapper(HttpServletRequest httpServletRequest) {
        this(httpServletRequest, null);
    }

    public HttpServletRequestWrapper(HttpServletRequest httpServletRequest, String string) {
        this.req = httpServletRequest;
        if (string != null) {
            this.extraParams = HttpUtils.parseQueryString((String)string);
            return;
        }
        this.extraParams = null;
    }

    public String getRequestURI() {
        if (this.requestAttr != null) {
            return this.requestAttr;
        }
        return this.req.getRequestURI();
    }

    public String getServletPath() {
        if (this.servletAttr != null) {
            return this.servletAttr;
        }
        return this.req.getServletPath();
    }

    public String getPathInfo() {
        if (this.pathAttr != null) {
            return this.pathAttr;
        }
        return this.req.getPathInfo();
    }

    public String getPathTranslated() {
        if (this.pathAttr != null) {
            String string = this.req.getPathTranslated();
            String string2 = this.req.getPathInfo();
            if (string2 == null && (string2 = this.req.getRequestURI()) == null) {
                string2 = this.req.getServletPath();
            }
            if (string2 != null && string != null) {
                URL uRL = JspParserContext.getRealPath(string2, string, this.pathAttr);
                if (uRL == null) {
                    return null;
                }
                return uRL.getFile();
            }
            return this.pathAttr;
        }
        return this.req.getPathTranslated();
    }

    public String getQueryString() {
        return this.req.getQueryString();
    }

    public void setAttribute(String string, Object object) {
        if (string.startsWith("javax.servlet.forward.")) {
            if (string.equals("javax.servlet.forward.request")) {
                this.requestAttr = (String)object;
                return;
            }
            if (string.equals("javax.servlet.forward.servlet")) {
                this.servletAttr = (String)object;
                return;
            }
            if (string.equals("javax.servlet.forward.path")) {
                this.pathAttr = (String)object;
                return;
            }
            if (string.equals("javax.servlet.forward.query")) {
                this.queryAttr = (String)object;
            }
            return;
        }
        this.attrs.put(string, object);
        if (string.startsWith("javax.servlet.include.")) {
            if (string.equals("javax.servlet.include.request")) {
                this.requestAttr = (String)object;
                return;
            }
            if (string.equals("javax.servlet.include.servlet")) {
                this.servletAttr = (String)object;
                return;
            }
            if (string.equals("javax.servlet.include.path")) {
                this.pathAttr = (String)object;
                return;
            }
            if (string.equals("javax.servlet.include.query")) {
                this.queryAttr = (String)object;
            }
        }
    }

    public Enumeration getAttributeNames() {
        return this.attrs.keys();
    }

    public Object getAttribute(String string) {
        Object v = this.attrs.get(string);
        if (v == null) {
            return this.req.getAttribute(string);
        }
        return v;
    }

    public int getContentLength() {
        return this.req.getContentLength();
    }

    public String getContentType() {
        return this.req.getContentType();
    }

    public String getProtocol() {
        return this.req.getProtocol();
    }

    public String getScheme() {
        return this.req.getScheme();
    }

    public String getServerName() {
        return this.req.getServerName();
    }

    public int getServerPort() {
        return this.req.getServerPort();
    }

    public String getRemoteAddr() {
        return this.req.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.req.getRemoteHost();
    }

    public String getRealPath(String string) {
        return this.req.getRealPath(string);
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.req.getInputStream();
    }

    public String getParameter(String string) {
        String[] stringArray;
        if (this.extraParams != null && (stringArray = (String[])this.extraParams.get(string)) != null && stringArray.length > 0) {
            return stringArray[0];
        }
        return this.req.getParameter(string);
    }

    public String[] getParameterValues(String string) {
        String[] stringArray;
        if (this.extraParams != null && (stringArray = (String[])this.extraParams.get(string)) != null) {
            String[] stringArray2 = this.req.getParameterValues(string);
            if (stringArray2 == null) {
                return (String[])stringArray.clone();
            }
            String[] stringArray3 = new String[stringArray.length + stringArray2.length];
            System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
            System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
            return stringArray3;
        }
        return this.req.getParameterValues(string);
    }

    public Enumeration getParameterNames() {
        if (this.extraParams == null) {
            return this.req.getParameterNames();
        }
        return new CombinedEnumeration();
    }

    public BufferedReader getReader() throws IOException {
        return this.req.getReader();
    }

    public String getCharacterEncoding() {
        return this.req.getCharacterEncoding();
    }

    public Cookie[] getCookies() {
        return this.req.getCookies();
    }

    public String getMethod() {
        return this.req.getMethod();
    }

    public String getRemoteUser() {
        return this.req.getRemoteUser();
    }

    public String getAuthType() {
        return this.req.getAuthType();
    }

    public String getHeader(String string) {
        return this.req.getHeader(string);
    }

    public int getIntHeader(String string) {
        return this.req.getIntHeader(string);
    }

    public long getDateHeader(String string) {
        return this.req.getDateHeader(string);
    }

    public Enumeration getHeaderNames() {
        return this.req.getHeaderNames();
    }

    public HttpSession getSession(boolean bl) {
        return this.req.getSession(bl);
    }

    public String getRequestedSessionId() {
        return this.req.getRequestedSessionId();
    }

    public boolean isRequestedSessionIdValid() {
        return this.req.isRequestedSessionIdValid();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.req.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.req.isRequestedSessionIdFromUrl();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.req.isRequestedSessionIdFromUrl();
    }

    public HttpSession getSession() {
        return this.req.getSession(true);
    }

    public class CombinedEnumeration
    implements Enumeration {
        private Enumeration extraKeys;
        private Enumeration sourceKeys;

        public CombinedEnumeration() {
            HttpServletRequestWrapper.this = HttpServletRequestWrapper.this;
            this.sourceKeys = HttpServletRequestWrapper.this.req.getParameterNames();
            this.extraKeys = HttpServletRequestWrapper.this.extraParams.keys();
        }

        public boolean hasMoreElements() {
            if (this.extraKeys != null) {
                return this.extraKeys.hasMoreElements();
            }
            return this.sourceKeys.hasMoreElements();
        }

        public Object nextElement() {
            if (this.extraKeys != null) {
                Object var1_1 = null;
                while ((var1_1 = this.extraKeys.nextElement()) != null && HttpServletRequestWrapper.this.req.getParameter((String)var1_1) != null && this.extraKeys.hasMoreElements()) {
                }
                if (!this.extraKeys.hasMoreElements()) {
                    this.extraKeys = null;
                }
                if (var1_1 != null) {
                    return var1_1;
                }
            }
            return this.sourceKeys.nextElement();
        }
    }
}

