/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.facade;

import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Container;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Handler;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.ServerSession;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.facade.HttpServletRequestFacade;
import org.apache.tomcat.facade.HttpServletResponseFacade;
import org.apache.tomcat.facade.ServletContextFacade;
import org.apache.tomcat.facade.ServletHandler;

public final class Servlet22Interceptor
extends BaseInterceptor {
    public static final String SERVLET_STAMP = " ( JSP 1.1; Servlet 2.2 )";
    private int stmPoolSize = 32;
    private boolean useStmPool = true;

    public Servlet22Interceptor() {
    }

    public Servlet22Interceptor(Context ctx) {
    }

    public void setSTMPoolSize(int size) {
        this.stmPoolSize = size;
    }

    public void setUseSTMPool(boolean use) {
        this.useStmPool = use;
    }

    private void setEngineHeader(Context ctx) {
        String engineHeader = ctx.getEngineHeader();
        if (engineHeader == null) {
            StringBuffer sb = new StringBuffer();
            sb.append("Tomcat Web Server");
            sb.append("/");
            sb.append("3.3.1 Final");
            sb.append(SERVLET_STAMP);
            engineHeader = sb.toString();
        }
        ctx.setEngineHeader(engineHeader);
    }

    public void contextShutdown(Context ctx) throws TomcatException {
        Enumeration enumeration = ctx.getServletNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            Handler wrapper = ctx.getServletByName(key);
            if (!(wrapper instanceof ServletHandler)) continue;
            try {
                ((ServletHandler)wrapper).destroy();
            }
            catch (Exception ex) {
                ctx.log("Error in destroy ", (Throwable)ex);
            }
            ctx.removeServletByName(key);
        }
    }

    public void addContext(ContextManager cm, Context ctx) throws TomcatException {
        ctx.setFacade((Object)new ServletContextFacade(cm, ctx));
        this.setEngineHeader(ctx);
    }

    public void addContainer(Container ct) throws TomcatException {
        ServletHandler handler;
        String hN = ct.getHandlerName();
        if (hN == null) {
            return;
        }
        if (ct.getHandler() == null) {
            handler = new ServletHandler();
            handler.setServletClassName(hN);
            handler.setName(hN);
            handler.setContext(ct.getContext());
            if (this.debug > 0 && !"jsp".equals(hN)) {
                this.log("Create handler " + hN);
            }
            handler.setModule(this);
            ct.setHandler((Handler)handler);
            ct.getContext().addServlet((Handler)handler);
        }
        if (ct.getHandler() instanceof ServletHandler) {
            handler = (ServletHandler)ct.getHandler();
            handler.setSTMPoolSize(this.stmPoolSize);
            handler.setUseSTMPool(this.useStmPool);
        }
    }

    public int sessionState(Request req, ServerSession sess, int newState) {
        if (this.debug > 0) {
            this.log("sessionState " + sess.getId() + " " + newState + " " + sess.getState());
        }
        if (newState == 4 || newState == 2) {
            String key;
            if (this.debug > 0) {
                this.log("Unbinding variables ");
            }
            HttpSession httpSess = (HttpSession)sess.getFacade();
            Vector<String> removed = null;
            Enumeration e = sess.getAttributeNames();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                Object value = sess.getAttribute(key);
                if (!(value instanceof HttpSessionBindingListener)) continue;
                if (this.debug > 0) {
                    this.log("valueUnbound " + sess.getId() + " " + key);
                }
                try {
                    ((HttpSessionBindingListener)value).valueUnbound(new HttpSessionBindingEvent(httpSess, key));
                }
                catch (Throwable th) {
                    this.log("Exception during unbound", th);
                }
                if (removed == null) {
                    removed = new Vector<String>();
                }
                removed.addElement(key);
            }
            if (removed != null) {
                e = removed.elements();
                while (e.hasMoreElements()) {
                    key = (String)e.nextElement();
                    sess.removeAttribute(key);
                }
            }
        }
        return 0;
    }

    public int postRequest(Request rreq, Response rres) {
        HttpServletRequest req = (HttpServletRequest)rreq.getFacade();
        if (!(req instanceof HttpServletRequestFacade)) {
            return 0;
        }
        ((HttpServletRequestFacade)req).recycle();
        if (rres == null) {
            return 0;
        }
        HttpServletResponse res = (HttpServletResponse)rres.getFacade();
        if (res != null) {
            ((HttpServletResponseFacade)res).recycle();
        }
        return 0;
    }
}

