/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.facade;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletConfig;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.Handler;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.facade.Servlet22Interceptor;
import org.apache.tomcat.facade.ServletConfigImpl;
import org.apache.tomcat.facade.ServletHandler;
import org.apache.tomcat.facade.WebXmlReader;
import org.apache.tomcat.util.collections.EmptyEnumeration;
import org.apache.tomcat.util.depend.DependManager;
import org.apache.tomcat.util.depend.Dependency;

public final class ServletInfo {
    private ServletHandler handler;
    private ServletConfig configF;
    private String description = null;
    private Hashtable securityRoleRefs = new Hashtable();
    private Hashtable initArgs = null;
    private String jspFile = null;
    private int loadOnStartup = -1;
    private boolean loadingOnStartup = false;
    DependManager dependM;
    Dependency dependency;

    public ServletInfo() {
        this.handler = new ServletHandler();
        this.handler.setServletInfo(this);
    }

    public ServletInfo(ServletHandler handler) {
        this.handler = handler;
        handler.setServletInfo(this);
    }

    public String toString() {
        return "SW (" + this.jspFile + " CN=" + this.handler.getServletClassName() + ")";
    }

    public void addServlet(Context ctx, WebXmlReader wxR) throws TomcatException {
        BaseInterceptor[] mods = ctx.getContainer().getInterceptors();
        int i = 0;
        while (i < mods.length) {
            if (mods[i] instanceof Servlet22Interceptor) {
                this.handler.setModule(mods[i]);
                break;
            }
            ++i;
        }
        if (this.handler.getModule() == null) {
            throw new TomcatException("Can't find Servlet22Interceptor");
        }
        ctx.addServlet((Handler)this.handler);
        this.handler.setContext(ctx);
    }

    public void setContext(Context ctx) {
        this.handler.setContext(ctx);
    }

    public Context getContext() {
        return this.handler.getContext();
    }

    Handler getHandler() {
        return this.handler;
    }

    public void addInitParam(String name, String value) {
        if (this.initArgs == null) {
            this.initArgs = new Hashtable();
        }
        this.initArgs.put(name, value);
    }

    public String getInitParameter(String name) {
        if (this.initArgs != null) {
            return (String)this.initArgs.get(name);
        }
        return null;
    }

    public Enumeration getInitParameterNames() {
        if (this.initArgs != null) {
            return this.initArgs.keys();
        }
        return EmptyEnumeration.getEmptyEnumeration();
    }

    public void setLoadOnStartUp(int level) {
        this.loadOnStartup = level;
        this.loadingOnStartup = true;
    }

    public void setLoadOnStartUp(String level) {
        this.loadOnStartup = level.length() > 0 ? new Integer(level) : -1;
        this.loadingOnStartup = true;
    }

    public int getLoadOnStartUp() {
        return this.loadOnStartup;
    }

    public boolean getLoadingOnStartUp() {
        return this.loadingOnStartup;
    }

    public String getServletName() {
        return this.handler.getName();
    }

    public void setServletName(String servletName) {
        this.handler.setName(servletName);
    }

    public String getServletDescription() {
        return this.description;
    }

    public void setServletDescription(String description) {
        this.description = description;
    }

    public String getServletClassName() {
        return this.handler.getServletClassName();
    }

    public void setServletClassName(String servletClassName) {
        this.handler.setServletClassName(servletClassName);
    }

    public void addSecurityMapping(String name, String role, String description) {
        this.securityRoleRefs.put(name, role);
    }

    public String getSecurityRole(String name) {
        return (String)this.securityRoleRefs.get(name);
    }

    public String getJspFile() {
        return this.jspFile;
    }

    public void setJspFile(String path) {
        this.jspFile = path;
        if (this.handler.getName() == null) {
            this.handler.setName(this.jspFile);
        }
    }

    public DependManager getDependManager() {
        return this.dependM;
    }

    public void setDependManager(DependManager dep) {
        this.dependM = dep;
    }

    public Dependency getDependency() {
        return this.dependency;
    }

    public void setDependency(Dependency dep) {
        this.dependency = dep;
    }

    public void setDescription(String s) {
    }

    public ServletConfig getServletConfig() {
        if (this.configF == null) {
            this.configF = new ServletConfigImpl(this);
        }
        return this.configF;
    }
}

