/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.startup;

import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.compat.Jdk11Compat;

public class Main {
    public static final String PROPERTY_COMMON_LOADER = "org.apache.tomcat.common.classpath";
    String installDir;
    String libDir;
    String serverBase;
    String commonBase;
    String homeDir;
    ClassLoader parentL;
    static final Jdk11Compat jdk11Compat = Jdk11Compat.getJdkCompat();
    String[] args;
    URL[] commonCP;
    ClassLoader commonCL;
    static Hashtable tasks = new Hashtable();
    String task;
    private static int dL;

    public void setLibDir(String dir) {
        this.libDir = dir;
    }

    public void setLoaderProperty(String prop) {
    }

    public void setInstallDir(String dir) {
    }

    public void setParentLoader(ClassLoader p) {
        this.parentL = p;
    }

    public static void main(String[] args) {
        try {
            Main m = new Main();
            m.processArgs(args);
            m.execute();
        }
        catch (Exception ex) {
            System.out.println("Fatal error");
            ex.printStackTrace();
        }
    }

    void log(String s) {
        System.err.println("TomcatStartup: " + s);
    }

    public void processArgs(String[] args) {
        this.args = args;
    }

    private void initDirs() throws Exception {
        if (this.installDir == null) {
            this.installDir = IntrospectionUtils.guessInstall((String)"tomcat.install", (String)"tomcat.home", (String)"tomcat.jar");
        }
        if (this.installDir == null) {
            this.installDir = ".";
        }
        if (this.libDir == null) {
            this.libDir = this.installDir + File.separator + "lib" + File.separator + "common";
        }
    }

    public void initClassLoader() {
        if (this.parentL == null) {
            this.parentL = this.getClass().getClassLoader();
        }
        this.commonCL = jdk11Compat.newClassLoaderInstance(this.commonCP, this.parentL);
        if (dL > 0) {
            IntrospectionUtils.displayClassPath((String)"Main classpath: ", (URL[])this.commonCP);
        }
    }

    public void initSecurityFile() {
        if (this.args.length > 1 && "-sandbox".equals(this.args[1])) {
            File f;
            String oldPolicy = System.getProperty("java.security.policy");
            if (oldPolicy != null) {
                if (oldPolicy.startsWith("=")) {
                    oldPolicy = oldPolicy.substring(1);
                }
                if (!(f = new File(oldPolicy)).exists()) {
                    this.debug("Can't find old policy " + oldPolicy);
                    oldPolicy = null;
                }
            }
            if (null == oldPolicy) {
                f = null;
                String policyFile = this.installDir + File.separator + "conf" + File.separator + "tomcat.policy";
                this.debug("Setting policy " + policyFile);
                ((Hashtable)System.getProperties()).put("tomcat.home", this.installDir);
                ((Hashtable)System.getProperties()).put("java.security.policy", policyFile);
                jdk11Compat.refreshPolicy();
            }
        }
    }

    public void setTask(String s) {
        this.task = s;
    }

    String findTask(String[] args) {
        if (args.length == 0) {
            return null;
        }
        String arg = args[0];
        if (arg.startsWith("-")) {
            arg = "";
        }
        if (tasks.get(arg) == null) {
            return null;
        }
        if (dL > 0) {
            this.debug("Task: " + arg + " " + tasks.get(arg));
        }
        return arg;
    }

    public void printUsage() {
        PrintStream out = System.out;
        out.println("Usage: java " + this.getClass().getName() + " [task] [options]");
        out.println();
        out.println("Tasks: ");
        Enumeration keys = tasks.keys();
        while (keys.hasMoreElements()) {
            String t = (String)keys.nextElement();
            String classN = (String)tasks.get(t);
            out.println("    " + t);
            this.printOptions(classN);
        }
        out.println();
    }

    private void printOptions(String classN) {
    }

    public void execute() throws Exception {
        block4: {
            try {
                if (this.task == null) {
                    this.task = this.findTask(this.args);
                }
                if (null == this.task) {
                    this.printUsage();
                    return;
                }
                this.initDirs();
                this.commonCP = IntrospectionUtils.getClassPath((String)this.libDir, null, (String)PROPERTY_COMMON_LOADER, (boolean)false);
                this.initSecurityFile();
                this.initClassLoader();
                Class<?> cls = this.commonCL.loadClass((String)tasks.get(this.task));
                Object proxy = cls.newInstance();
                IntrospectionUtils.setAttribute(proxy, (String)"install", (Object)this.installDir);
                IntrospectionUtils.setAttribute(proxy, (String)"parentClassLoader", (Object)this.parentL);
                IntrospectionUtils.setAttribute(proxy, (String)"commonClassPath", (Object)this.commonCP);
                IntrospectionUtils.setAttribute(proxy, (String)"commonClassLoader", (Object)this.commonCL);
                IntrospectionUtils.setAttribute(proxy, (String)"args", (Object)this.args);
                IntrospectionUtils.execute(proxy, (String)"execute");
            }
            catch (Exception ex) {
                System.out.println("Guessed home=" + this.installDir);
                System.out.println("Exception: " + ex);
                ex.printStackTrace();
                if (!(ex instanceof InvocationTargetException)) break block4;
                Throwable t = ((InvocationTargetException)ex).getTargetException();
                System.out.println("Root Exception: " + t);
                t.printStackTrace();
            }
        }
    }

    private void debug(String s) {
        System.out.println("Main: " + s);
    }

    static {
        tasks.put("stop", "org.apache.tomcat.startup.StopTomcat");
        tasks.put("enableAdmin", "org.apache.tomcat.startup.EnableAdmin");
        tasks.put("start", "org.apache.tomcat.startup.EmbededTomcat");
        tasks.put("run", "org.apache.tomcat.startup.EmbededTomcat");
        tasks.put("jspc", "org.apache.tomcat.startup.Jspc");
        tasks.put("estart", "org.apache.tomcat.startup.EmbededTomcat");
        tasks.put("", "org.apache.tomcat.startup.EmbededTomcat");
        dL = 0;
    }
}

