/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.startup;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.res.StringManager;

public class StopTomcat {
    static final String DEFAULT_CONFIG = "conf/server.xml";
    private static StringManager sm = StringManager.getManager((String)"org.apache.tomcat.resources");
    String tomcatHome = null;
    String host = null;
    int port = -1;
    String secret;
    boolean commandLineParams = false;
    String secretFile = null;
    String shutdown = null;
    String[] args;
    boolean help = false;
    boolean isAjp13 = false;
    boolean isAjp12 = false;
    static String[] options1 = new String[]{"help", "stop", "ajp12", "ajp13"};
    static Hashtable optionAliases = new Hashtable();
    static Hashtable optionDescription = new Hashtable();

    public void setSecretFile(String s) {
        this.secretFile = s;
        this.commandLineParams = true;
    }

    public void setAjpid(String s) {
        this.secretFile = s;
        this.commandLineParams = true;
    }

    public void setAjpid12(String s) {
        this.secretFile = s;
        this.commandLineParams = true;
        this.isAjp12 = true;
        this.isAjp13 = false;
    }

    public void setAjpid13(String s) {
        this.secretFile = s;
        this.commandLineParams = true;
        this.isAjp12 = false;
        this.isAjp13 = true;
    }

    public void setH(String s) {
        this.tomcatHome = s;
        ((Hashtable)System.getProperties()).put("tomcat.home", s);
    }

    public void setHome(String s) {
        this.tomcatHome = s;
        ((Hashtable)System.getProperties()).put("tomcat.home", s);
    }

    public void setHost(String h) {
        this.host = h;
        this.commandLineParams = true;
    }

    public void setPort(int port) {
        this.port = port;
        this.commandLineParams = true;
    }

    public void setPass(String s) {
        this.secret = s;
        this.commandLineParams = true;
    }

    public void setSecret(String s) {
        this.secret = s;
        this.commandLineParams = true;
    }

    public void setHelp(boolean b) {
        this.help = b;
    }

    public void setAttribute(String s, Object o) {
        if (s.equals("args")) {
            this.setArgs((String[])o);
        }
    }

    public void setProperty(String name, String v) {
        if (!name.equals("stop")) {
            this.help = true;
        }
    }

    public void setAjp13(boolean b) {
        this.isAjp13 = b;
        this.isAjp12 = !b;
    }

    public void setAjp12(boolean b) {
        this.isAjp12 = b;
        this.isAjp13 = !b;
    }

    public void setArgs(String[] args) {
        this.args = args;
    }

    public void execute() throws Exception {
        if (this.args != null) {
            this.processArgs(this.args);
        }
        if (this.help) {
            StopTomcat.printUsage();
            return;
        }
        System.out.println(sm.getString("tomcat.stop"));
        try {
            this.stopTomcat();
        }
        catch (ConnectException ex) {
            System.out.println(sm.getString("tomcat.connectexception"));
        }
        catch (Exception te) {
            throw te;
        }
    }

    void stopTomcat() throws Exception {
        block29: {
            if (this.port < 0 || this.host == null || this.secret == null) {
                String tchome = this.getTomcatHome();
                String defAjp12File = tchome + "/conf/ajp12.id";
                String defAjp13File = tchome + "/conf/ajp13.id";
                String ajpFile = this.secretFile;
                int portSave = this.port;
                String hostSave = this.host;
                String secretSave = this.secret;
                boolean pickAjp = !this.isAjp13 && !this.isAjp12;
                try {
                    String line;
                    if (ajpFile == null) {
                        if (this.isAjp13) {
                            ajpFile = defAjp13File;
                        } else if (this.isAjp12) {
                            ajpFile = defAjp12File;
                        } else {
                            File f = new File(defAjp13File);
                            if (f.exists()) {
                                ajpFile = defAjp13File;
                                this.isAjp13 = true;
                            } else {
                                f = new File(defAjp12File);
                                if (f.exists()) {
                                    ajpFile = defAjp12File;
                                    this.isAjp12 = true;
                                }
                            }
                        }
                    } else if (pickAjp) {
                        this.isAjp12 = true;
                    }
                    if (this.isAjp13) {
                        Properties props = new Properties();
                        props.load(new FileInputStream(ajpFile));
                        line = props.getProperty("port");
                        if (this.port < 0) {
                            try {
                                this.port = Integer.parseInt(line);
                            }
                            catch (NumberFormatException ex) {
                                ex.printStackTrace();
                            }
                        }
                        line = props.getProperty("address");
                        if (this.host == null) {
                            this.host = line;
                        }
                        line = props.getProperty("secret");
                        if (this.secret == null) {
                            this.secret = line;
                        }
                        this.shutdown = props.getProperty("shutdown");
                        if (this.shutdown == null && this.secretFile == null && pickAjp) {
                            this.isAjp12 = true;
                            this.isAjp13 = false;
                            this.port = portSave;
                            this.host = hostSave;
                            this.secret = secretSave;
                            ajpFile = defAjp12File;
                        }
                    }
                    if (!this.isAjp12) break block29;
                    BufferedReader rd = new BufferedReader(new FileReader(ajpFile));
                    line = rd.readLine();
                    if (this.port < 0) {
                        try {
                            this.port = Integer.parseInt(line);
                        }
                        catch (NumberFormatException ex) {
                            ex.printStackTrace();
                        }
                    }
                    line = rd.readLine();
                    if (this.host == null) {
                        this.host = line;
                    }
                    line = rd.readLine();
                    if (this.secret == null) {
                        this.secret = line;
                    }
                }
                catch (IOException ex) {
                    System.out.println("Can't read " + ajpFile);
                    if (this.commandLineParams) break block29;
                    return;
                }
            }
        }
        if ("".equals(this.secret)) {
            this.secret = null;
        }
        System.out.println("Stopping tomcat on " + this.host + ":" + this.port + " " + this.secret);
        InetAddress address = null;
        if (this.host != null && !"".equals(this.host)) {
            try {
                address = InetAddress.getByName(this.host);
            }
            catch (UnknownHostException ex) {
                ex.printStackTrace();
            }
        }
        this.stopTomcat(address, this.port, this.secret);
    }

    public String getTomcatHome() {
        if (this.tomcatHome != null) {
            return this.tomcatHome;
        }
        String tchome = IntrospectionUtils.guessInstall((String)"tomcat.install", (String)"tomcat.home", (String)"stop-tomcat.jar");
        tchome = System.getProperty("tomcat.home");
        if (tchome == null) {
            System.out.println(sm.getString("tomcat.nohome"));
            tchome = ".";
        }
        return tchome;
    }

    public void stopTomcat(InetAddress address, int portInt, String secret) throws IOException {
        try {
            if (address == null) {
                address = InetAddress.getLocalHost();
            }
            Socket socket = new Socket(address, portInt);
            OutputStream os = socket.getOutputStream();
            if (this.isAjp13) {
                this.sendAjp13Stop(os, secret);
            } else {
                this.sendAjp12Stop(os, secret);
            }
            try {
                socket.setSoLinger(true, 0);
            }
            catch (SocketException ignore) {
                // empty catch block
            }
            os.flush();
            os.close();
        }
        catch (IOException ex) {
            System.out.println("Error stopping Tomcat with Ajp12 on " + address + ":" + portInt + " " + ex);
        }
    }

    public void sendAjp12Stop(OutputStream os, String secret) throws IOException {
        byte[] stopMessage = new byte[]{-2, 15};
        os.write(stopMessage);
        if (secret != null) {
            this.sendAjp12String(os, secret);
        }
        os.flush();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ignore) {
            // empty catch block
        }
    }

    public void sendAjp13Stop(OutputStream os, String secret) throws IOException {
        byte[] stopMessage = new byte[5];
        stopMessage[0] = 18;
        stopMessage[1] = 52;
        int len = 1;
        if (secret != null) {
            len = secret.length() + 4;
        }
        stopMessage[2] = (byte)(len / 256);
        stopMessage[3] = (byte)(len % 256);
        stopMessage[4] = 7;
        os.write(stopMessage);
        if (secret != null) {
            this.sendAjp13String(os, secret);
        }
        os.flush();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ignore) {
            // empty catch block
        }
    }

    public void sendAjp12String(OutputStream os, String s) throws IOException {
        int len = s.length();
        os.write(len / 256);
        os.write(len % 256);
        os.write(s.getBytes());
    }

    public void sendAjp13String(OutputStream os, String s) throws IOException {
        int len = s.length();
        os.write(len / 256);
        os.write(len % 256);
        os.write(s.getBytes());
        os.write(0);
    }

    public boolean processArgs(String[] args) {
        try {
            return IntrospectionUtils.processArgs((Object)this, (String[])args, (String[])this.getOptions1(), null, (Hashtable)this.getOptionAliases());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public String[] getOptions1() {
        return options1;
    }

    public Hashtable getOptionAliases() {
        return optionAliases;
    }

    public static void printUsage() {
        System.out.println("Usage: java org.apache.tomcat.startup.StopTomcat {options}");
        System.out.println("  Options are:");
        System.out.println("    -ajp12                            Use Ajp12 protocol for shutdown");
        System.out.println("    -ajp13                            Use Ajp13 protocol for shutdown");
        System.out.println("                                          Shutdown feature of Ajp13");
        System.out.println("                                          connector must be enabled.");
        System.out.println("    -ajpid file (or -secretFile file) Use this file instead of conf/ajp13.id");
        System.out.println("                                          or conf/ajp12.id.  You must set");
        System.out.println("                                          -ajp13 option if file is from");
        System.out.println("                                          Ajp13 connector");
        System.out.println("    -help (or -?)                     Show this usage report");
        System.out.println("    -host <host>                      Host to send the shutdown command");
        System.out.println("    -home <dir> (or -h <dir>)         Use this directory as tomcat.home, to");
        System.out.println("                                          find conf/ajp13.id or conf/ajp12.id");
        System.out.println("    -pass <pw> (or -secret <pw>)      Password to use, aka secret");
        System.out.println("    -port <port>                      Port to send the shutdown command");
        System.out.println("Note: the '-' on the options is optional.");
        System.out.println();
    }

    public static void main(String[] args) {
        try {
            StopTomcat tomcat = new StopTomcat();
            tomcat.setArgs(args);
            tomcat.execute();
        }
        catch (Exception ex) {
            System.out.println(sm.getString("tomcat.fatal"));
            ex.printStackTrace();
            System.exit(1);
        }
    }

    static {
        optionAliases.put("h", "home");
        optionAliases.put("?", "help");
    }
}

