/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.io.CharConversionException;
import java.io.IOException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Container;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Handler;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.ServerSession;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.buf.UDecoder;
import org.apache.tomcat.util.http.Cookies;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.http.Parameters;

public class Request {
    public static final String DEFAULT_CHARACTER_ENCODING = "ISO-8859-1";
    public static final String SESSIONID_FROM_COOKIE = "cookie";
    public static final String SESSIONID_FROM_URL = "url";
    public static final int MAX_INCLUDE = 10;
    public static final String ATTRIB_REAL_REQUEST = "org.apache.tomcat.request";
    public static final int STATE_UNUSED = 0;
    public static final int STATE_INVALID = -1;
    public static final int STATE_NEW = 1;
    public static final int STATE_CONTEXT_MAPPED = 2;
    public static final int STATE_MAPPED = 3;
    protected int serverPort;
    protected String localHost;
    protected int state;
    protected MessageBytes schemeMB = MessageBytes.newInstance();
    protected MessageBytes unparsedURIMB = MessageBytes.newInstance();
    protected MessageBytes methodMB = MessageBytes.newInstance();
    protected MessageBytes uriMB = MessageBytes.newInstance();
    protected MessageBytes queryMB = MessageBytes.newInstance();
    protected MessageBytes protoMB = MessageBytes.newInstance();
    protected MessageBytes contextMB = MessageBytes.newInstance();
    protected MessageBytes servletPathMB = MessageBytes.newInstance();
    protected MessageBytes pathInfoMB = MessageBytes.newInstance();
    protected MessageBytes remoteAddrMB = MessageBytes.newInstance();
    protected MessageBytes remoteHostMB = MessageBytes.newInstance();
    protected String jvmRoute;
    protected Hashtable attributes = new Hashtable();
    protected MimeHeaders headers;
    protected Parameters params = new Parameters();
    protected boolean didReadFormData = false;
    protected int contentLength = -1;
    protected int available = -1;
    protected MessageBytes contentTypeMB = null;
    protected String charEncoding = null;
    protected MessageBytes serverNameMB = MessageBytes.newInstance();
    protected String authType;
    protected boolean notAuthenticated = true;
    protected String remoteUser;
    protected Principal principal;
    protected String[] userRoles;
    protected Container security;
    protected String[] reqRoles;
    protected Response response;
    protected ContextManager contextM;
    protected Context context;
    protected Object requestFacade;
    protected String reqSessionId;
    protected String sessionIdSource;
    protected String sessionId;
    protected ServerSession serverSession;
    protected Handler handler = null;
    protected Container container;
    protected Cookies scookies;
    protected Request top;
    protected Request parent;
    protected Request child;
    protected UDecoder urlDecoder;
    protected Exception errorException;
    private Object[] notes = new Object[32];
    private int encodingInfo;
    private int attributeInfo;
    private static int CACHED_POST_LEN = 8192;
    private byte[] postData = null;
    private String[] checkRoles = new String[1];
    byte[] b = new byte[1];

    public Request() {
        this.headers = new MimeHeaders();
        this.scookies = new Cookies(this.headers);
        this.urlDecoder = new UDecoder();
        this.params.setQuery(this.queryMB);
        this.params.setURLDecoder(this.urlDecoder);
        this.params.setHeaders(this.headers);
        this.initRequest();
    }

    public final int getState() {
        return this.state;
    }

    public final void setState(int state) {
        this.state = state;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public Context getContext() {
        return this.context;
    }

    public UDecoder getURLDecoder() {
        return this.urlDecoder;
    }

    public void setContextManager(ContextManager cm) {
        this.contextM = cm;
        try {
            this.encodingInfo = cm.getNoteId(2, "req.encoding");
            this.attributeInfo = cm.getNoteId(2, "req.attribute");
        }
        catch (TomcatException ex) {
            ex.printStackTrace();
        }
    }

    public ContextManager getContextManager() {
        return this.contextM;
    }

    public Object getFacade() {
        return this.requestFacade;
    }

    public void setFacade(Object facade) {
        this.requestFacade = facade;
    }

    public void setResponse(Response response) {
        this.response = response;
    }

    public Response getResponse() {
        return this.response;
    }

    public MimeHeaders getMimeHeaders() {
        return this.headers;
    }

    public MessageBytes scheme() {
        return this.schemeMB;
    }

    public MessageBytes method() {
        return this.methodMB;
    }

    public String getMethod() {
        return this.methodMB.toString();
    }

    public void setMethod(String method) {
        this.methodMB.setString(method);
    }

    public MessageBytes requestURI() {
        return this.uriMB;
    }

    public String getRequestURI() {
        return this.uriMB.toString();
    }

    public void setRequestURI(String r) {
        this.uriMB.setString(r);
    }

    public MessageBytes unparsedURI() {
        return this.unparsedURIMB;
    }

    public MessageBytes query() {
        return this.queryMB;
    }

    public MessageBytes queryString() {
        return this.query();
    }

    public MessageBytes servletPath() {
        return this.servletPathMB;
    }

    public MessageBytes pathInfo() {
        return this.pathInfoMB;
    }

    public MessageBytes protocol() {
        return this.protoMB;
    }

    public MessageBytes serverName() {
        return this.serverNameMB;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public MessageBytes remoteAddr() {
        return this.remoteAddrMB;
    }

    public MessageBytes remoteHost() {
        return this.remoteHostMB;
    }

    public String getLocalHost() {
        return this.localHost;
    }

    public void setLocalHost(String host) {
        this.localHost = host;
    }

    public void handlePostParameters() {
        if (this.didReadFormData) {
            return;
        }
        this.didReadFormData = true;
        if (!this.method().equalsIgnoreCase("POST")) {
            return;
        }
        String contentType = this.getContentType();
        if (contentType == null || !contentType.startsWith("application/x-www-form-urlencoded")) {
            return;
        }
        int len = this.getContentLength();
        int available = this.getAvailable();
        if (available > 0) {
            try {
                byte[] formData = null;
                if (available < CACHED_POST_LEN) {
                    if (this.postData == null) {
                        this.postData = new byte[CACHED_POST_LEN];
                    }
                    formData = this.postData;
                } else {
                    formData = new byte[available];
                }
                this.readBody(formData, available);
                this.handleQueryParameters();
                this.params.processParameters(formData, 0, available);
            }
            catch (CharConversionException cex) {
                this.contextM.log("CharConversionException processing parameters: " + this + " " + cex.toString());
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return;
            }
        }
    }

    public void handleQueryParameters() {
        this.getCharacterEncoding();
        if (this.charEncoding != null) {
            this.params.setEncoding(this.getCharacterEncoding());
        } else {
            this.params.setEncoding(DEFAULT_CHARACTER_ENCODING);
        }
        this.params.handleQueryParameters();
    }

    public Parameters parameters() {
        return this.params;
    }

    public String getCharacterEncoding() {
        return this.getCharEncoding();
    }

    public String getCharEncoding() {
        if (this.charEncoding != null) {
            return this.charEncoding;
        }
        Object result = null;
        Context ctx = this.getContext();
        if (ctx != null) {
            BaseInterceptor[] reqI = ctx.getContainer().getInterceptors(14);
            int i = 0;
            while (i < reqI.length) {
                result = reqI[i].getInfo(ctx, this, this.encodingInfo, null);
                if (result != null) break;
                ++i;
            }
            if (result != null) {
                this.charEncoding = (String)result;
                return this.charEncoding;
            }
        }
        if (this.charEncoding == null) {
            this.charEncoding = DEFAULT_CHARACTER_ENCODING;
        }
        return this.charEncoding;
    }

    public void setCharEncoding(String enc) {
        this.charEncoding = enc;
    }

    public void setContentLength(int len) {
        this.contentLength = len;
        this.available = len;
    }

    public int getContentLength() {
        if (this.contentLength > -1) {
            return this.contentLength;
        }
        MessageBytes clB = this.getMimeHeaders().getValue("content-length");
        this.available = this.contentLength = clB == null || clB.isNull() ? -1 : clB.getInt();
        return this.contentLength;
    }

    public String getContentType() {
        this.contentType();
        if (this.contentTypeMB == null || this.contentTypeMB.isNull()) {
            return null;
        }
        return this.contentTypeMB.toString();
    }

    public void setContentType(String type) {
        this.contentTypeMB.setString(type);
    }

    public MessageBytes contentType() {
        if (this.contentTypeMB == null) {
            this.contentTypeMB = this.getMimeHeaders().getValue("content-type");
        }
        return this.contentTypeMB;
    }

    public void setContentType(MessageBytes mb) {
        this.contentTypeMB = mb;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public String getAuthType() {
        return this.authType;
    }

    public void setRemoteUser(String s) {
        this.remoteUser = s;
        this.notAuthenticated = false;
    }

    public String getRemoteUser() {
        Context ctx;
        if (this.notAuthenticated && (ctx = this.getContext()) != null) {
            this.notAuthenticated = false;
            int status = 0;
            BaseInterceptor[] reqI = ctx.getContainer().getInterceptors(3);
            int i = 0;
            while (i < reqI.length) {
                status = reqI[i].authenticate(this, this.response);
                if (status != -1) break;
                ++i;
            }
        }
        return this.remoteUser;
    }

    public boolean isSecure() {
        return this.scheme().equalsIgnoreCase("HTTPS");
    }

    public void setUserPrincipal(Principal p) {
        this.principal = p;
    }

    public Principal getUserPrincipal() {
        if (this.getRemoteUser() == null) {
            return null;
        }
        return this.principal;
    }

    public void setRequiredRoles(String[] roles) {
        this.reqRoles = roles;
    }

    public Container getSecurityContext() {
        return this.security;
    }

    public void setSecurityContext(Container ct) {
        this.security = ct;
    }

    public String[] getRequiredRoles() {
        return this.reqRoles;
    }

    public void setUserRoles(String[] roles) {
        this.userRoles = roles;
    }

    public String[] getUserRoles() {
        return this.userRoles;
    }

    public boolean isUserInRole(String role) {
        this.checkRoles[0] = role;
        int status = 0;
        BaseInterceptor[] reqI = this.getContainer().getInterceptors(4);
        int i = 0;
        while (i < reqI.length) {
            status = reqI[i].authorize(this, this.response, this.checkRoles);
            if (status != -1) break;
            ++i;
        }
        return status == 0;
    }

    public String getJvmRoute() {
        return this.jvmRoute;
    }

    public void setJvmRoute(String jvmRoute) {
        if (jvmRoute == null || "".equals(jvmRoute)) {
            this.jvmRoute = null;
        }
        this.jvmRoute = jvmRoute;
    }

    public String getRequestedSessionId() {
        return this.reqSessionId;
    }

    public void setRequestedSessionId(String reqSessionId) {
        this.reqSessionId = reqSessionId;
    }

    public String getSessionIdSource() {
        return this.sessionIdSource;
    }

    public void setSessionIdSource(String s) {
        this.sessionIdSource = s;
    }

    public void setSessionId(String id) {
        if (!this.response.isIncluded()) {
            this.sessionId = id;
        }
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSession(ServerSession serverSession) {
        this.serverSession = serverSession;
    }

    public ServerSession getSession(boolean create) {
        if (this.serverSession != null && !this.serverSession.isValid()) {
            this.serverSession = null;
        }
        if (!create || this.serverSession != null) {
            return this.serverSession;
        }
        BaseInterceptor[] reqI = this.getContainer().getInterceptors(7);
        int i = 0;
        while (i < reqI.length) {
            this.serverSession = reqI[i].findSession(this, null, create);
            if (this.serverSession != null) break;
            ++i;
        }
        if (this.serverSession != null) {
            this.setSessionId(this.serverSession.getId().toString());
        }
        return this.serverSession;
    }

    public Cookies getCookies() {
        return this.scookies;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public Container getContainer() {
        if (this.container == null && this.context == null) {
            this.container = this.contextM.getContainer();
        }
        if (this.container == null) {
            this.container = this.context.getContainer();
        }
        return this.container;
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public Object getAttribute(String name) {
        Object value = this.attributes.get(name);
        if (value != null) {
            return value;
        }
        Object result = null;
        Context ctx = this.getContext();
        if (ctx == null) {
            return null;
        }
        BaseInterceptor[] reqI = ctx.getContainer().getInterceptors(14);
        int i = 0;
        while (i < reqI.length) {
            result = reqI[i].getInfo(ctx, this, this.attributeInfo, name);
            if (result != null) break;
            ++i;
        }
        if (result != null) {
            return result;
        }
        if (name.equals(ATTRIB_REAL_REQUEST)) {
            if (!this.context.allowAttribute(name)) {
                return null;
            }
            return this;
        }
        return null;
    }

    public void setAttribute(String name, Object value) {
        int status = -1;
        Context ctx = this.getContext();
        if (ctx != null) {
            BaseInterceptor[] reqI = ctx.getContainer().getInterceptors(15);
            int i = 0;
            while (i < reqI.length) {
                status = reqI[i].setInfo(ctx, this, this.attributeInfo, name, value);
                if (status != -1) break;
                ++i;
            }
            if (status != -1) {
                return;
            }
        }
        if (name != null && value != null) {
            this.attributes.put(name, value);
        }
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public Request getParent() {
        return this.parent;
    }

    public void setParent(Request req) {
        this.parent = req;
    }

    public Request getChild() {
        return this.child;
    }

    public void setChild(Request req) {
        this.child = req;
    }

    public Request getTop() {
        if (this.top == null) {
            if (this.parent == null) {
                this.top = this;
            } else {
                int i = 10;
                Request p = this.parent;
                while (i-- > 0 && p.getParent() != null) {
                    p = p.getParent();
                }
                if (i == 0) {
                    throw new IllegalStateException("Too deep includes");
                }
                this.top = p;
            }
        }
        return this.top;
    }

    public Enumeration getHeaders(String name) {
        return this.getMimeHeaders().values(name);
    }

    public String getHeader(String name) {
        return this.getMimeHeaders().getHeader(name);
    }

    public Enumeration getHeaderNames() {
        return this.getMimeHeaders().names();
    }

    public void setAvailable(int len) {
        this.available = len;
    }

    public int getAvailable() {
        return this.available;
    }

    public int doRead(byte[] b, int off, int len) throws IOException {
        return -1;
    }

    public int doRead() throws IOException {
        byte[] b = new byte[1];
        int rc = this.doRead(b, 0, 1);
        if (rc <= 0) {
            return -1;
        }
        return b[0];
    }

    public int readBody(byte[] body, int len) throws IOException {
        int inputLen;
        int offset = 0;
        do {
            if ((inputLen = this.doRead(body, offset, len - offset)) > 0) continue;
            return offset;
        } while (len - (offset += inputLen) > 0);
        return len;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("R( ");
        if (this.context != null) {
            sb.append(this.context.getPath());
            if (!this.servletPath().isNull()) {
                sb.append(" + " + this.servletPath().toString() + " + " + this.pathInfo().toString());
            }
        } else {
            sb.append(this.requestURI().toString());
        }
        sb.append(")");
        return sb.toString();
    }

    public final void setNote(int pos, Object value) {
        this.notes[pos] = value;
    }

    public final Object getNote(int pos) {
        return this.notes[pos];
    }

    public Object getNote(String name) throws TomcatException {
        int id = this.contextM.getNoteId(2, name);
        return this.getNote(id);
    }

    public void setNote(String name, Object value) throws TomcatException {
        int id = this.contextM.getNoteId(2, name);
        this.setNote(id, value);
    }

    public void recycle() {
        this.initRequest();
    }

    public void initRequest() {
        this.context = null;
        this.attributes.clear();
        this.params.recycle();
        this.contentLength = -1;
        this.contentTypeMB = null;
        this.charEncoding = null;
        this.authType = null;
        this.remoteUser = null;
        this.principal = null;
        this.reqSessionId = null;
        this.serverSession = null;
        this.didReadFormData = false;
        this.container = null;
        this.handler = null;
        this.errorException = null;
        this.jvmRoute = null;
        this.headers.clear();
        this.serverNameMB.recycle();
        this.serverPort = -1;
        this.sessionIdSource = null;
        this.sessionId = null;
        this.scookies.recycle();
        int i = 0;
        while (i < 32) {
            this.notes[i] = null;
            ++i;
        }
        this.parent = null;
        this.child = null;
        this.top = null;
        this.notAuthenticated = true;
        this.userRoles = null;
        this.reqRoles = null;
        this.security = null;
        this.uriMB.recycle();
        this.unparsedURIMB.recycle();
        this.contextMB.recycle();
        this.pathInfoMB.recycle();
        this.servletPathMB.recycle();
        this.queryMB.recycle();
        this.methodMB.recycle();
        this.protoMB.recycle();
        this.remoteAddrMB.recycle();
        this.remoteHostMB.recycle();
        this.schemeMB.setString("http");
        this.methodMB.setString("GET");
        this.uriMB.setString("/");
        this.queryMB.setString("");
        this.protoMB.setString("HTTP/1.0");
        this.remoteAddrMB.setString("127.0.0.1");
        this.remoteHostMB.setString("localhost");
    }
}

