/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.JspUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class TagLibraryInfoImpl
extends TagLibraryInfo {
    private static final String TLD = "META-INF/taglib.tld";
    private static final String WEBAPP_INF = "/WEB-INF/web.xml";
    Document tld;
    Hashtable jarEntries;
    JspCompilationContext ctxt;

    private final void print(String name, String value, PrintWriter w) {
        if (value != null) {
            w.print(name + " = {\n\t");
            w.print(value);
            w.print("\n}\n");
        }
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        this.print("tlibversion", this.tlibversion, out);
        this.print("jspversion", this.jspversion, out);
        this.print("shortname", this.shortname, out);
        this.print("urn", this.urn, out);
        this.print("info", this.info, out);
        this.print("uri", this.uri, out);
        int i = 0;
        while (i < this.tags.length) {
            out.println(this.tags[i].toString());
            ++i;
        }
        return sw.toString();
    }

    private InputStream getResourceAsStream(String uri) throws FileNotFoundException {
        if (uri.indexOf(":") > 0) {
            return this.ctxt.getResourceAsStream(uri);
        }
        String real = this.ctxt.getRealPath(uri);
        return real == null ? null : new FileInputStream(real);
    }

    public TagLibraryInfoImpl(JspCompilationContext ctxt, String prefix, String uriIn) throws IOException, JasperException {
        super(prefix, uriIn);
        Document webtld;
        NodeList nList;
        this.ctxt = ctxt;
        InputStream in = null;
        URL url = null;
        boolean relativeURL = false;
        this.uri = uriIn;
        InputStream is = this.getResourceAsStream(WEBAPP_INF);
        if (is != null && (nList = (webtld = JspUtil.parseXMLDoc(is, "/org/apache/jasper/resources/web.dtd", "-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN")).getElementsByTagName("taglib")).getLength() != 0) {
            int i = 0;
            while (i < nList.getLength()) {
                String tmpUri;
                String tagLoc = null;
                boolean match = false;
                Element e = (Element)nList.item(i);
                NodeList uriList = e.getElementsByTagName("taglib-uri");
                Element uriElem = (Element)uriList.item(0);
                Text t = (Text)uriElem.getFirstChild();
                if (t != null && (tmpUri = t.getData()) != null && (tmpUri = tmpUri.trim()).equals(uriIn)) {
                    match = true;
                    NodeList locList = e.getElementsByTagName("taglib-location");
                    Element locElem = (Element)locList.item(0);
                    Text tl = (Text)locElem.getFirstChild();
                    if (tl != null && (tagLoc = tl.getData()) != null) {
                        tagLoc = tagLoc.trim();
                    }
                }
                if (match && tagLoc != null) {
                    this.uri = tagLoc;
                    if (!this.uri.startsWith("/") && this.isRelativeURI(this.uri)) {
                        this.uri = "/WEB-INF/" + this.uri;
                    }
                }
                ++i;
            }
        }
        if (!this.uri.startsWith("/") && this.isRelativeURI(this.uri)) {
            this.uri = ctxt.resolveRelativeUri(this.uri);
        }
        if (!this.uri.endsWith("jar")) {
            in = this.getResourceAsStream(this.uri);
            if (in == null) {
                throw new JasperException(Constants.getString("jsp.error.tld_not_found", new Object[]{this.uri}));
            }
            this.parseTLD(in);
        }
        if (this.uri.endsWith("jar")) {
            ZipEntry entry;
            if (!this.isRelativeURI(this.uri)) {
                url = new URL(this.uri);
                in = url.openStream();
            } else {
                relativeURL = true;
                in = this.getResourceAsStream(this.uri);
            }
            ZipInputStream zin = new ZipInputStream(in);
            this.jarEntries = new Hashtable();
            this.ctxt = ctxt;
            boolean tldFound = false;
            while ((entry = zin.getNextEntry()) != null) {
                ByteArrayOutputStream baos;
                if (((ZipEntry)((Object)nList)).getName().equals(TLD)) {
                    baos = new ByteArrayOutputStream();
                    while (zin.available() != 0) {
                        int b = ((InflaterInputStream)zin).read();
                        if (b == -1) break;
                        baos.write(b);
                    }
                    baos.close();
                    ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                    tldFound = true;
                    this.parseTLD(bais);
                } else {
                    baos = new ByteArrayOutputStream();
                    while (zin.available() != 0) {
                        int b = ((InflaterInputStream)zin).read();
                        if (b == -1) break;
                        baos.write(b);
                    }
                    baos.close();
                    this.jarEntries.put(((ZipEntry)((Object)nList)).getName(), baos.toByteArray());
                }
                zin.closeEntry();
            }
            if (!tldFound) {
                throw new JasperException(Constants.getString("jsp.error.tld_not_found", new Object[]{TLD}));
            }
        }
    }

    private boolean isRelativeURI(String uri) {
        return uri.indexOf(58) == -1;
    }

    private void parseTLD(InputStream in) throws JasperException {
        this.tld = JspUtil.parseXMLDoc(in, "/org/apache/jasper/resources/web-jsptaglib_1_1.dtd", "-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.1//EN");
        Vector<TagInfo> tagVector = new Vector<TagInfo>();
        NodeList list = this.tld.getElementsByTagName("taglib");
        if (list.getLength() != 1) {
            throw new JasperException(Constants.getString("jsp.error.more.than.one.taglib"));
        }
        Element elem = (Element)list.item(0);
        list = elem.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node tmp = list.item(i);
            if (tmp instanceof Element) {
                Text t;
                Element e = (Element)tmp;
                String tname = e.getTagName();
                if (tname.equals("tlibversion")) {
                    t = (Text)e.getFirstChild();
                    if (t != null) {
                        this.tlibversion = t.getData().trim();
                    }
                } else if (tname.equals("jspversion")) {
                    t = (Text)e.getFirstChild();
                    if (t != null) {
                        this.jspversion = t.getData().trim();
                    }
                } else if (tname.equals("shortname")) {
                    t = (Text)e.getFirstChild();
                    if (t != null) {
                        this.shortname = t.getData().trim();
                    }
                } else if (tname.equals("uri")) {
                    t = (Text)e.getFirstChild();
                    if (t != null) {
                        this.urn = t.getData().trim();
                    }
                } else if (tname.equals("info")) {
                    t = (Text)e.getFirstChild();
                    if (t != null) {
                        this.info = t.getData().trim();
                    }
                } else if (tname.equals("tag")) {
                    tagVector.addElement(this.createTagInfo(e));
                } else {
                    Constants.message("jsp.warning.unknown.element.in.TLD", new Object[]{e.getTagName()}, 2);
                }
            }
            ++i;
        }
        this.tags = new TagInfo[tagVector.size()];
        tagVector.copyInto(this.tags);
    }

    private TagInfo createTagInfo(Element elem) throws JasperException {
        String name = null;
        String tagclass = null;
        String teiclass = null;
        String bodycontent = "JSP";
        String info = null;
        Vector<TagAttributeInfo> attributeVector = new Vector<TagAttributeInfo>();
        NodeList list = elem.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node tmp = list.item(i);
            if (tmp instanceof Element) {
                Text t;
                Element e = (Element)tmp;
                String tname = e.getTagName();
                if (tname.equals("name")) {
                    t = (Text)e.getFirstChild();
                    if (t != null) {
                        name = t.getData().trim();
                    }
                } else if (tname.equals("tagclass")) {
                    t = (Text)e.getFirstChild();
                    if (t != null) {
                        tagclass = t.getData().trim();
                    }
                } else if (tname.equals("teiclass")) {
                    t = (Text)e.getFirstChild();
                    if (t != null) {
                        teiclass = t.getData().trim();
                    }
                } else if (tname.equals("bodycontent")) {
                    t = (Text)e.getFirstChild();
                    if (t != null) {
                        bodycontent = t.getData().trim();
                    }
                } else if (tname.equals("info")) {
                    t = (Text)e.getFirstChild();
                    if (t != null) {
                        info = t.getData().trim();
                    }
                } else if (tname.equals("attribute")) {
                    attributeVector.addElement(this.createAttribute(e));
                } else {
                    Constants.message("jsp.warning.unknown.element.in.tag", new Object[]{e.getTagName()}, 2);
                }
            }
            ++i;
        }
        Object[] tagAttributeInfo = new TagAttributeInfo[attributeVector.size()];
        attributeVector.copyInto(tagAttributeInfo);
        TagExtraInfo tei = null;
        if (teiclass != null && !teiclass.equals("")) {
            try {
                Class<?> teiClass = this.ctxt.getClassLoader().loadClass(teiclass);
                tei = (TagExtraInfo)teiClass.newInstance();
            }
            catch (ClassNotFoundException cex) {
                Constants.message("jsp.warning.teiclass.is.null", new Object[]{teiclass, cex.getMessage()}, 2);
            }
            catch (IllegalAccessException iae) {
                Constants.message("jsp.warning.teiclass.is.null", new Object[]{teiclass, iae.getMessage()}, 2);
            }
            catch (InstantiationException ie) {
                Constants.message("jsp.warning.teiclass.is.null", new Object[]{teiclass, ie.getMessage()}, 2);
            }
        }
        TagInfo taginfo = new TagInfo(name, tagclass, bodycontent, info, (TagLibraryInfo)this, tei, (TagAttributeInfo[])tagAttributeInfo);
        return taginfo;
    }

    TagAttributeInfo createAttribute(Element elem) {
        String name = null;
        boolean required = false;
        boolean rtexprvalue = false;
        boolean reqTime = false;
        String type = null;
        NodeList list = elem.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node tmp = list.item(i);
            if (tmp instanceof Element) {
                Text t;
                Element e = (Element)tmp;
                String tname = e.getTagName();
                if (tname.equals("name")) {
                    t = (Text)e.getFirstChild();
                    if (t != null) {
                        name = t.getData().trim();
                    }
                } else if (tname.equals("required")) {
                    t = (Text)e.getFirstChild();
                    if (t != null) {
                        required = Boolean.valueOf(t.getData().trim());
                        if (t.getData().equalsIgnoreCase("yes")) {
                            required = true;
                        }
                    }
                } else if (tname.equals("rtexprvalue")) {
                    t = (Text)e.getFirstChild();
                    if (t != null) {
                        rtexprvalue = Boolean.valueOf(t.getData().trim());
                        if (t.getData().equalsIgnoreCase("yes")) {
                            rtexprvalue = true;
                        }
                    }
                } else if (tname.equals("type")) {
                    t = (Text)e.getFirstChild();
                    if (t != null) {
                        type = t.getData().trim();
                    }
                } else {
                    Constants.message("jsp.warning.unknown.element.in.attribute", new Object[]{e.getTagName()}, 2);
                }
            }
            ++i;
        }
        return new TagAttributeInfo(name, required, type, rtexprvalue);
    }

    /*
     * WARNING - void declaration
     */
    static void copy(InputStream in, String fileName) throws IOException, FileNotFoundException {
        int nRead;
        byte[] buf = new byte[1024];
        FileOutputStream out = new FileOutputStream(fileName);
        while ((nRead = in.read(buf, 0, buf.length)) != -1) {
            void var4_4;
            out.write(buf, 0, (int)var4_4);
        }
    }
}

