/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import java.util.Enumeration;
import java.util.Stack;
import javax.servlet.jsp.tagext.Tag;
import org.apache.jasper.runtime.TagHandlerPool;
import org.apache.tomcat.util.log.Log;

public class TagHandlerPoolImpl
implements TagHandlerPool {
    Class myHandlerClass = null;
    Stack myHandlers = new Stack();
    Log myLog = null;
    String myPoolName = null;
    static /* synthetic */ Class class$javax$servlet$jsp$tagext$Tag;

    private TagHandlerPoolImpl() {
    }

    public TagHandlerPoolImpl(Class handlerClass, String poolName) {
        if (!(class$javax$servlet$jsp$tagext$Tag == null ? (class$javax$servlet$jsp$tagext$Tag = TagHandlerPoolImpl.class$("javax.servlet.jsp.tagext.Tag")) : class$javax$servlet$jsp$tagext$Tag).isAssignableFrom(handlerClass)) {
            throw new IllegalArgumentException("TagHandlerPoolImpl should only be used with Tag objects");
        }
        this.myHandlerClass = handlerClass;
        this.myPoolName = poolName;
        this.myLog = Log.getLog("tag_pool_log", this);
        if (this.myLog.getLevel() >= 3) {
            this.myLog.log("New tag pool named '" + this.myPoolName + "' created to handle " + handlerClass.getName(), 3);
        }
    }

    public Tag getHandler() {
        Tag returnValue;
        block11: {
            returnValue = null;
            try {
                Stack stack = this.myHandlers;
                synchronized (stack) {
                    if (this.myHandlers.empty()) {
                        if (this.myLog.getLevel() >= 4) {
                            this.myLog.log("Allocating new tag of type " + this.myHandlerClass.getName(), 4);
                        }
                        returnValue = (Tag)this.myHandlerClass.newInstance();
                    } else {
                        if (this.myLog.getLevel() >= 4) {
                            this.myLog.log("Obtaining cached tag of type " + this.myHandlerClass.getName(), 4);
                        }
                        returnValue = (Tag)this.myHandlers.pop();
                    }
                }
            }
            catch (InstantiationException exception) {
                if (this.myLog.getLevel() >= 2) {
                    this.myLog.log("Failed to allocate tag of type " + this.myHandlerClass.getName() + ": " + exception.toString(), 2);
                }
            }
            catch (IllegalAccessException exception) {
                if (this.myLog.getLevel() < 2) break block11;
                this.myLog.log("Failed to allocate tag of type " + this.myHandlerClass.getName() + ": " + exception.toString(), 2);
            }
        }
        return returnValue;
    }

    public void releaseHandler(Tag usedTag, boolean removeFromPool) {
        if (this.myLog.getLevel() >= 4) {
            String message = null;
            message = removeFromPool ? "Removing tag of type " + this.myHandlerClass.getName() + " from cache" : "Returning tag of type " + this.myHandlerClass.getName() + " to cache";
            this.myLog.log(message, 4);
        }
        if (removeFromPool) {
            usedTag.release();
        } else {
            Stack stack = this.myHandlers;
            synchronized (stack) {
                this.myHandlers.push(usedTag);
            }
        }
    }

    public void shutdown() {
        Stack stack = this.myHandlers;
        synchronized (stack) {
            if (this.myLog.getLevel() >= 3) {
                this.myLog.log("Shutting down pool '" + this.myPoolName + "', pool contained " + this.myHandlers.size() + " tags", 3);
            }
            Enumeration handlers = this.myHandlers.elements();
            while (handlers.hasMoreElements()) {
                ((Tag)handlers.nextElement()).release();
            }
            this.myHandlers.removeAllElements();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

